/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.gdi.Cursor;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.BalloonListener;
import com.jniwrapper.win32.shell.NotifyIconData;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.system.DllVersionInfo;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.WndClass;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TrayIcon
extends Component {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$shell$TrayIcon == null ? (class$com$jniwrapper$win32$shell$TrayIcon = TrayIcon.class$("com.jniwrapper.win32.shell.TrayIcon")) : class$com$jniwrapper$win32$shell$TrayIcon));
    static final FunctionName FUNCTION_SHELL_NOTIFY_ICON = new FunctionName("Shell_NotifyIcon");
    static final FunctionName FUNCTION_REGISTER_WINDOW_MESSAGE = new FunctionName("RegisterWindowMessage");
    static final int NIM_ADD = 0;
    static final int NIM_MODIFY = 1;
    static final int NIM_DELETE = 2;
    static final int NIF_MESSAGE = 1;
    static final int NIF_ICON = 2;
    static final int NIF_TIP = 4;
    static final int NIF_STATE = 8;
    static final int NIF_INFO = 16;
    static final int NIS_HIDDEN = 1;
    static final int NIS_SHAREDICON = 2;
    public static final int WM_TRAY = 1025;
    public static final int WM_RESTORE_TRAY;
    private static final int NIN_BALLOONSHOWN = 1026;
    private static final int NIN_BALLOONHIDE = 1027;
    private static final int NIN_BALLOONTIMEOUT = 1028;
    private static final int NIN_BALLOONUSERCLICK = 1029;
    static final String CLASS_NAME = "JW_TrayWindowClassName";
    private static Map _messageHandlers;
    private static Object _trayWindowLock;
    private static int _curID;
    private static long _hWnd;
    private final int _trayID;
    private boolean _disposed = false;
    private List _listeners = new ArrayList();
    private boolean _hidingAvailable = false;
    private boolean _visible = false;
    private Icon _icon;
    private JPopupMenu _popupMenu = null;
    private JFrame _popupWindow = null;
    private TrayIconListener _popupTrayIconListener = null;
    static /* synthetic */ Class class$com$jniwrapper$win32$shell$TrayIcon;

    public TrayIcon() {
        this(null);
    }

    public TrayIcon(Icon icon) {
        DllVersionInfo dllVersionInfo = new DllVersionInfo("Comctl32");
        this._hidingAvailable = dllVersionInfo.getMajorVersion() >= 5;
        this._trayID = _curID++;
        TrayIcon.ensureEventProcessing();
        _messageHandlers.put(new Integer(this._trayID), this);
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setCallbackMessage(1025);
        notifyicondata.setFlags(23L);
        this.notify(0, notifyicondata);
        this._visible = true;
        this.setIcon(icon);
    }

    private void notify(int operation, NotifyIconData notifyIconData) {
        if (this._disposed) {
            throw new IllegalStateException("Already disposed");
        }
        Function function = Shell32.getInstance().getFunction(FUNCTION_SHELL_NOTIFY_ICON.toString());
        Bool result = new Bool();
        long errorCode = function.invoke((Parameter)result, (Parameter)new Int32(operation), (Parameter)new Pointer((Parameter)notifyIconData));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode, "Icon operation failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureEventProcessing() {
        Object object = _trayWindowLock;
        synchronized (object) {
            if (_hWnd == 0L) {
                Thread thread = new Thread(){

                    public void run() {
                        TrayIcon.createEmptyNativeWindow();
                        Wnd.eventLoop(_hWnd);
                    }
                };
                thread.setDaemon(true);
                thread.start();
                try {
                    _trayWindowLock.wait();
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
                if (_hWnd == 0L) {
                    throw new RuntimeException("Event processing window creation failed");
                }
            }
        }
    }

    public void setIcon(Icon icon) {
        if (icon != null && !icon.isNull()) {
            this._icon = icon;
            NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
            notifyicondata.setIcon(icon);
            notifyicondata.setFlags(2L);
            this.notify(1, notifyicondata);
        }
    }

    public void showMessage(TrayMessage value) {
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setFlags(16L);
        notifyicondata.setInfoTitle(value.getTitle());
        notifyicondata.setInfo(value.getMessage());
        notifyicondata.setTimeout(value.getTimeout() * 1000);
        notifyicondata.setInfoFlags(value.getIconType());
        this.notify(1, notifyicondata);
    }

    public void dispose() {
        if (!this._disposed) {
            this.notify(2, new NotifyIconData(_hWnd, this._trayID));
            _messageHandlers.remove(new Integer(this._trayID));
            this._disposed = true;
        }
    }

    public void setToolTip(String tip) {
        NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
        notifyicondata.setToolTip(tip);
        notifyicondata.setFlags(4L);
        this.notify(1, notifyicondata);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this._popupMenu = popupMenu;
        if (this._popupWindow == null) {
            this._popupWindow = new JFrame();
            this._popupWindow.setLocation(-300, -300);
            this._popupWindow.pack();
            Wnd wnd = new Wnd(this._popupWindow);
            wnd.setTopmost(true);
            wnd.setWindowExStyle(128L);
            this._popupWindow.setVisible(true);
            this._popupWindow.addWindowListener(new WindowAdapter(){

                public void windowDeactivated(WindowEvent e) {
                    if (TrayIcon.this._popupMenu != null) {
                        TrayIcon.this._popupMenu.setVisible(false);
                    }
                }
            });
        }
        if (this._popupTrayIconListener == null) {
            this._popupTrayIconListener = new TrayIconListener(){

                public void trayActionPerformed(long message, int x, int y) {
                    if (message == 517L) {
                        if (TrayIcon.this._popupMenu.getSize().equals(new Dimension(0, 0))) {
                            int px = x - (int)TrayIcon.this._popupWindow.getLocation().getX();
                            int py = y - (int)TrayIcon.this._popupWindow.getLocation().getY();
                            TrayIcon.this._popupMenu.show(TrayIcon.this._popupWindow, px, py);
                            px = x - (int)TrayIcon.this._popupMenu.getSize().getWidth() >= 0 ? x - (int)TrayIcon.this._popupMenu.getSize().getWidth() : x;
                            py = y - (int)TrayIcon.this._popupMenu.getSize().getHeight() >= 0 ? y - (int)TrayIcon.this._popupMenu.getSize().getHeight() : y;
                            TrayIcon.this._popupMenu.setLocation(px, py);
                        } else {
                            int px = x - (int)TrayIcon.this._popupMenu.getSize().getWidth() >= 0 ? x - (int)TrayIcon.this._popupWindow.getLocation().getX() - (int)TrayIcon.this._popupMenu.getSize().getWidth() : x - (int)TrayIcon.this._popupWindow.getLocation().getX();
                            int py = y - (int)TrayIcon.this._popupMenu.getSize().getHeight() >= 0 ? y - (int)TrayIcon.this._popupWindow.getLocation().getY() - (int)TrayIcon.this._popupMenu.getSize().getHeight() : y - (int)TrayIcon.this._popupWindow.getLocation().getY();
                            TrayIcon.this._popupMenu.show(TrayIcon.this._popupWindow, px, py);
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    TrayIcon.access$200(3.access$400(this.this$1)).repaint();
                                }
                            });
                        }
                        TrayIcon.this._popupWindow.setVisible(true);
                    }
                }

                static /* synthetic */ TrayIcon access$400(3 x0) {
                    return x0.TrayIcon.this;
                }
            };
        }
        this.addTrayListener(this._popupTrayIconListener);
    }

    public JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    public void removePopupMenu() {
        if (this._popupMenu == null) {
            return;
        }
        this._popupWindow.dispatchEvent(new WindowEvent(this._popupWindow, 201));
        this._popupWindow = null;
        this._popupMenu = null;
        this.removeTrayListener(this._popupTrayIconListener);
    }

    public void addTrayListener(TrayIconListener listener) {
        this._listeners.add(listener);
    }

    public void addTrayListener(MouseListener listener) {
        this._listeners.add(listener);
    }

    public void addTrayListener(BalloonListener listener) {
        this._listeners.add(listener);
    }

    public void removeTrayListener(TrayIconListener listener) {
        this._listeners.remove(listener);
    }

    public void removeTrayListener(MouseListener listener) {
        this._listeners.remove(listener);
    }

    public void removeTrayListener(BalloonListener listener) {
        this._listeners.remove(listener);
    }

    private MouseEvent getMouseEvent(int message, int x, int y) {
        MouseEvent mouseEvent;
        switch (message) {
            case 515: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 2, false, 1);
                break;
            }
            case 518: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 2, false, 2);
                break;
            }
            case 521: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 2, false, 3);
                break;
            }
            case 513: 
            case 514: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 1, false, 1);
                break;
            }
            case 516: 
            case 517: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 1, false, 2);
                break;
            }
            case 519: 
            case 520: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 1, false, 3);
                break;
            }
            default: {
                mouseEvent = new MouseEvent(this, this._trayID, System.currentTimeMillis(), 0, x, y, 0, false, 0);
            }
        }
        return mouseEvent;
    }

    private void onIconMessage(long message, int x, int y) {
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            Object listener;
            Object anyListener = i.next();
            if (anyListener instanceof TrayIconListener) {
                listener = (TrayIconListener)anyListener;
                listener.trayActionPerformed(message, x, y);
                continue;
            }
            if (anyListener instanceof MouseListener) {
                listener = (MouseListener)anyListener;
                int intMessage = (int)message;
                switch (intMessage) {
                    case 515: 
                    case 518: 
                    case 521: {
                        listener.mouseClicked(this.getMouseEvent(intMessage, x, y));
                        break;
                    }
                    case 513: 
                    case 516: 
                    case 519: {
                        listener.mousePressed(this.getMouseEvent(intMessage, x, y));
                        break;
                    }
                    case 514: 
                    case 517: 
                    case 520: {
                        listener.mouseReleased(this.getMouseEvent(intMessage, x, y));
                        break;
                    }
                    case 673: {
                        listener.mouseEntered(this.getMouseEvent(intMessage, x, y));
                        break;
                    }
                    case 675: {
                        listener.mouseExited(this.getMouseEvent(intMessage, x, y));
                    }
                }
                continue;
            }
            if (!(anyListener instanceof BalloonListener)) continue;
            listener = (BalloonListener)anyListener;
            switch ((int)message) {
                case 1026: {
                    listener.balloonShown(new EventObject(this));
                    break;
                }
                case 1027: {
                    listener.balloonHide(new EventObject(this));
                    break;
                }
                case 1028: {
                    listener.balloonTimeOut(new EventObject(this));
                    break;
                }
                case 1029: {
                    listener.balloonUserClick(new EventObject(this));
                }
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this._visible != visible) {
            this._visible = visible;
            NotifyIconData notifyicondata = new NotifyIconData(_hWnd, this._trayID);
            if (this._hidingAvailable) {
                notifyicondata.setFlags(8L);
                notifyicondata.setState(visible ? 0L : 1L);
                notifyicondata.setStateMask(1L);
                this.notify(1, notifyicondata);
            } else {
                notifyicondata.setFlags(23L);
                notifyicondata.setCallbackMessage(1025);
                if (visible && this._icon != null && !this._icon.isNull()) {
                    notifyicondata.setIcon(this._icon);
                }
                this.notify(visible ? 0 : 2, notifyicondata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createEmptyNativeWindow() {
        Object object = _trayWindowLock;
        synchronized (object) {
            WndClass wndClass = new WndClass(new TrayIconWindowProc(), CLASS_NAME);
            wndClass.register();
            Wnd hWnd = Wnd.createWindow(CLASS_NAME);
            _hWnd = hWnd.getValue();
            _trayWindowLock.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Function registerWindowMessage = User32.getInstance().getFunction(FUNCTION_REGISTER_WINDOW_MESSAGE.toString());
        UInt res = new UInt();
        registerWindowMessage.invoke((Parameter)res, (Parameter)new Str("TaskbarCreated"));
        WM_RESTORE_TRAY = (int)res.getValue();
        _messageHandlers = new HashMap();
        _trayWindowLock = new Object();
        _curID = 0;
    }

    private static class TrayIconWindowProc
    extends WindowProc {
        boolean _timerRuning = false;
        boolean _mouseIn = false;
        int _mouseX = 0;
        int _mouseY = 0;
        Timer _timer;
        TrayIcon _handler = null;

        private TrayIconWindowProc() {
        }

        Timer getTimer() {
            if (this._timer == null) {
                this._timer = new Timer(150, new ActionListener(this){
                    private final /* synthetic */ TrayIconWindowProc this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (this.this$0._timerRuning) {
                            this.this$0._timer.stop();
                            this.this$0._timerRuning = false;
                        }
                        Point cursorPosition = Cursor.getCursorPosition();
                        int mx = (int)cursorPosition.getX();
                        int my = (int)cursorPosition.getY();
                        if (this.this$0._handler != null && (mx != this.this$0._mouseX || my != this.this$0._mouseY)) {
                            TrayIcon.access$600(this.this$0._handler, 675L, mx, my);
                            this.this$0._mouseIn = false;
                            this.this$0._mouseY = 0;
                            this.this$0._mouseY = 0;
                        }
                    }
                });
            }
            return this._timer;
        }

        public void callback() {
            int msg = (int)this._msg.getValue();
            if (msg == 1025) {
                long lParam = this._lParam.getValue();
                long wParam = this._wParam.getValue();
                Point cursorPos = Cursor.getCursorPosition();
                int mx = (int)cursorPos.getX();
                int my = (int)cursorPos.getY();
                Integer id = new Integer((int)wParam);
                this._handler = (TrayIcon)_messageHandlers.get(id);
                if (!(this._mouseIn || this._handler == null || mx == this._mouseX && my == this._mouseY)) {
                    this._handler.onIconMessage(673L, mx, my);
                }
                if (lParam == 512L) {
                    Timer timer = this.getTimer();
                    if (this._timerRuning) {
                        timer.stop();
                        this._timerRuning = false;
                    }
                    timer.start();
                    this._timerRuning = true;
                }
                this._mouseX = mx;
                this._mouseY = my;
                if (this._handler != null) {
                    this._handler.onIconMessage(lParam, this._mouseX, this._mouseY);
                }
                this._mouseIn = true;
                this._lResult.setValue(0L);
            } else if (msg == WM_RESTORE_TRAY) {
                Iterator iterator = _messageHandlers.keySet().iterator();
                while (iterator.hasNext()) {
                    TrayIcon trayIcon = (TrayIcon)_messageHandlers.get(iterator.next());
                    NotifyIconData notifyicondata = new NotifyIconData(_hWnd, trayIcon._trayID);
                    notifyicondata.setCallbackMessage(1025);
                    notifyicondata.setFlags(23L);
                    trayIcon.notify(0, notifyicondata);
                    trayIcon._visible = true;
                    trayIcon.setIcon(trayIcon._icon);
                }
            } else {
                super.callback();
            }
        }
    }
}

