/*
 * Decompiled with CFR 0.152.
 */
package com.sautinsoft;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class HtmlToRtf {
    static {
        System.loadLibrary("HtmlToRtf");
    }

    private native String htmltortf_file(String var1, String var2);

    private native String htmltortf_string(String var1);

    public String convertHtmlFileToRtfFile(String htmlfile, String outfolder) {
        return this.htmltortf_file(htmlfile, outfolder);
    }

    public String convertHtmlToRtf(String html) {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            File htmlFile = File.createTempFile("htr", ".html", new File(tmpDir));
            String htmlFn = htmlFile.getAbsolutePath();
            htmlFile.deleteOnExit();
            HtmlToRtf.writeFile(html, htmlFn);
            String result = this.htmltortf_file(htmlFn, tmpDir);
            if (result.equals("")) {
                return HtmlToRtf.readFile(htmlFn.replaceFirst(".html", ".rtf"));
            }
            return result;
        }
        catch (Exception e) {
            return "ERROR: " + e.getLocalizedMessage();
        }
    }

    public static void main(String[] args) {
        HtmlToRtf JN = new HtmlToRtf();
        String fileHtml = HtmlToRtf.readFile("C:\\test.html");
        String fileRtf = JN.convertHtmlToRtf(fileHtml);
        HtmlToRtf.writeFile(fileRtf, "C:\\testStr.rtf");
    }

    private static String readFile(String filename) {
        byte[] result = null;
        try {
            File file = new File(filename);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            int numBytes = (int)file.length();
            byte[] buff = new byte[numBytes];
            int readBytes = bis.read(buff);
            bis.close();
            result = buff;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(result);
    }

    private static void writeFile(String contents, String filename) {
        try {
            File file = new File(filename);
            FileOutputStream fis = new FileOutputStream(file);
            fis.write(contents.getBytes());
            fis.flush();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

