/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.eclipseplugin.ui;

import com.jniwrapper.win32.com.generator.eclipseplugin.ui.BaseDialog;
import com.jniwrapper.win32.com.generator.eclipseplugin.ui.ContainerSelectionDialog;
import com.jniwrapper.win32.com.generator.eclipseplugin.utility.ResourcesUtility;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModeSelectionDialog
extends BaseDialog {
    protected Button generateSourceButton;
    protected Button packToJarButton;
    protected Button javaDocsCheckbox;
    protected Button browseButton;
    protected Button browseForJarButton;
    protected Button browseForJavaDocs;
    protected Text sourceFolderPathText;
    protected Text jarNameText;
    protected Text javaDocsLocationText;
    protected boolean packToJar;
    protected String sourceFolderPath;
    protected String jarName;
    protected String destinationFolder;
    protected boolean generateDocs;
    protected String javaDocsLocation;
    protected IContainer container;
    protected IContainer generateToContainer;

    public ModeSelectionDialog(Shell parentShell, IContainer container) {
        super(parentShell, "Select generator mode", 400, 150);
        this.description = "Select what you wish the generator to do.";
        this.container = container;
    }

    public boolean isPackToJar() {
        return this.packToJar;
    }

    public boolean doGenerateJavaDocs() {
        return this.generateDocs;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getSourceFolderPath() {
        return this.sourceFolderPath;
    }

    public String getJavaDocsLocation() {
        return this.javaDocsLocation;
    }

    public IContainer getGenerateToContainer() {
        return this.generateToContainer;
    }

    protected Control createButtonPanel(Composite parent) {
        return this.createRightPanelButtons(parent);
    }

    protected void createControls(Composite parent) {
        Composite radioGroup = new Composite(parent, 16);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        radioGroup.setLayout((Layout)layout);
        radioGroup.setLayoutData((Object)new GridData(768));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModeSelectionDialog.this.refreshControlsEnablement();
                ModeSelectionDialog.this.validateContent();
            }
        };
        this.generateSourceButton = new Button(radioGroup, 16);
        this.generateSourceButton.setLayoutData((Object)new GridData(32));
        this.generateSourceButton.setText("Generate source files to:");
        this.generateSourceButton.addSelectionListener((SelectionListener)listener);
        this.sourceFolderPathText = new Text(radioGroup, 2052);
        this.sourceFolderPathText.setLayoutData((Object)new GridData(768));
        this.sourceFolderPathText.setEditable(false);
        this.sourceFolderPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ModeSelectionDialog.this.validateContent();
            }
        });
        this.browseButton = new Button(radioGroup, 8);
        this.browseButton.setText("...");
        this.browseButton.setLayoutData((Object)new GridData(128));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(ModeSelectionDialog.this.getShell(), ModeSelectionDialog.this.container);
                if (dialog.open() == 0) {
                    ModeSelectionDialog.this.generateToContainer = dialog.getSelectedContainer() == null ? ModeSelectionDialog.this.container : dialog.getSelectedContainer();
                    ModeSelectionDialog.this.sourceFolderPathText.setText(ResourcesUtility.normalizePath(ModeSelectionDialog.this.generateToContainer.getLocation().toString()));
                }
            }
        });
        this.packToJarButton = new Button(radioGroup, 16);
        this.packToJarButton.setLayoutData((Object)new GridData(32));
        this.packToJarButton.setText("Pack generated classes to JAR:");
        this.packToJarButton.addSelectionListener((SelectionListener)listener);
        this.jarNameText = new Text(radioGroup, 2052);
        GridData data = new GridData(768);
        this.jarNameText.setLayoutData((Object)data);
        this.jarNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModeSelectionDialog.this.validateContent();
            }
        });
        this.browseForJarButton = new Button(radioGroup, 8);
        this.browseForJarButton.setText("...");
        this.browseForJarButton.setLayoutData((Object)new GridData(128));
        this.browseForJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ModeSelectionDialog.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.jar"});
                String path = dialog.open();
                if (path != null) {
                    ModeSelectionDialog.this.jarNameText.setText(ResourcesUtility.normalizePath(path));
                }
            }
        });
        Label separator = new Label(radioGroup, 258);
        data = new GridData(768);
        data.horizontalSpan = 3;
        separator.setLayoutData((Object)data);
        this.javaDocsCheckbox = new Button(radioGroup, 32);
        this.javaDocsCheckbox.setLayoutData((Object)new GridData(32));
        this.javaDocsCheckbox.setText("Generate java docs to:");
        this.javaDocsCheckbox.addSelectionListener((SelectionListener)listener);
        this.javaDocsLocationText = new Text(radioGroup, 2052);
        this.javaDocsLocationText.setLayoutData((Object)new GridData(768));
        this.browseForJavaDocs = new Button(radioGroup, 8);
        this.browseForJavaDocs.setText("...");
        this.browseForJavaDocs.setLayoutData((Object)new GridData(128));
        this.browseForJavaDocs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ModeSelectionDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    ModeSelectionDialog.this.javaDocsLocationText.setText(ResourcesUtility.normalizePath(path));
                }
            }
        });
        this.refreshControlsEnablement();
    }

    protected void saveChanges() {
        this.packToJar = this.packToJarButton.getSelection();
        if (!this.packToJar) {
            this.sourceFolderPath = this.sourceFolderPathText.getText();
        } else {
            int lastSlashIndex;
            this.jarName = this.jarNameText.getText();
            int lastBackSlashIndex = this.jarName.lastIndexOf("\\");
            this.destinationFolder = this.jarName.substring(0, lastBackSlashIndex > (lastSlashIndex = this.jarName.lastIndexOf("/")) ? lastBackSlashIndex : lastSlashIndex);
        }
        this.generateDocs = this.javaDocsCheckbox.getSelection();
        this.javaDocsLocation = this.javaDocsLocationText.getText();
    }

    private void refreshControlsEnablement() {
        boolean enabled = this.javaDocsCheckbox.getSelection();
        this.javaDocsLocationText.setEditable(enabled);
        this.browseForJavaDocs.setEnabled(enabled);
        enabled = this.packToJarButton.getSelection();
        this.jarNameText.setEditable(enabled);
        this.browseForJarButton.setEnabled(enabled);
        this.browseButton.setEnabled(!enabled);
    }

    private void validateContent() {
        boolean enabled = true;
        if (this.generateSourceButton.getSelection()) {
            enabled = this.sourceFolderPathText.getText().trim().length() > 0;
        } else {
            Path jarPath = new Path(this.jarNameText.getText());
            if (jarPath.getFileExtension() != null && jarPath.getFileExtension().equals("jar")) {
                enabled = true;
                jarPath = jarPath.removeLastSegments(1);
            } else {
                enabled = false;
            }
            this.javaDocsLocationText.setText(jarPath + "/docs");
        }
        if (this.javaDocsCheckbox.getSelection() && this.javaDocsLocationText.getText().trim().length() == 0) {
            enabled = false;
        }
        this.setOKEnabled(enabled);
    }

    private void setOKEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public void create() {
        super.create();
        this.setOKEnabled(false);
    }
}

