/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin.ui;

import com.intellij.ide.util.projectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.jniwrapper.win32.com.generator.ideaplugin.util.VersionManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class SelectSourceFolderDialog
extends DialogWrapper
implements TreeSelectionListener {
    private final DefaultMutableTreeNode ROOT = new DefaultMutableTreeNode("Modules");
    private JTree _modulesTree = new JTree();
    private DefaultTreeModel _treeModel = new DefaultTreeModel(this.ROOT);
    private Project _project;
    private SourceFolder _sourceFolder;
    private TreePath _selectedPath;

    public SelectSourceFolderDialog(Project project, SourceFolder sourceFolder, boolean canBeParent) {
        super(canBeParent);
        if (sourceFolder != null) {
            this._sourceFolder = sourceFolder;
        }
        this._project = project;
        this._modulesTree.setRootVisible(false);
        this._modulesTree.setShowsRootHandles(true);
        this._modulesTree.setCellRenderer((TreeCellRenderer)((Object)new ModuleTreeRenderer()));
        this._modulesTree.setModel(this._treeModel);
        this._modulesTree.addTreeSelectionListener(this);
        this.setTitle("Select Source Folder");
        this.setOKActionEnabled(false);
        this.init();
        this.updateModuleList();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("Select source folder within a module to generate code to."), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane(this._modulesTree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void doOKAction() {
        TreePath selectionPath = this._modulesTree.getSelectionPath();
        Object userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        if (userObject instanceof SourceFolder) {
            this._sourceFolder = (SourceFolder)userObject;
            super.doOKAction();
        }
    }

    private void updateModuleList() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._treeModel.getRoot();
        rootNode.removeAllChildren();
        Module[] modules = ModuleManager.getInstance((Project)this._project).getModules();
        for (int i = 0; i < modules.length; ++i) {
            DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(modules[i]);
            rootNode.add(moduleNode);
            ContentEntry[] contentEntries = ModuleRootManager.getInstance((Module)modules[i]).getContentEntries();
            for (int j = 0; j < contentEntries.length; ++j) {
                SourceFolder[] sourceFolders = contentEntries[j].getSourceFolders();
                for (int s = 0; s < sourceFolders.length; ++s) {
                    DefaultMutableTreeNode sourceFolderNode = new DefaultMutableTreeNode(sourceFolders[s]);
                    moduleNode.add(sourceFolderNode);
                    if (this._sourceFolder == null || !sourceFolders[s].equals(this._sourceFolder)) continue;
                    this._selectedPath = new TreePath(sourceFolderNode.getPath());
                }
            }
        }
        this._treeModel.reload();
        this._modulesTree.updateUI();
        if (this._selectedPath != null) {
            this._modulesTree.collapsePath(this._selectedPath);
            this._modulesTree.setSelectionPath(this._selectedPath);
        }
    }

    protected Action[] createActions() {
        return new Action[]{new CreateModuleAction(), this.getOKAction(), this.getCancelAction()};
    }

    protected void dispose() {
        this._modulesTree.removeTreeSelectionListener(this);
        super.dispose();
    }

    public SourceFolder getSourceFolder() {
        return this._sourceFolder;
    }

    private void createModule() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                ModulesProvider provider = VersionManager.getInstance().createModulesProvider(SelectSourceFolderDialog.this._project);
                if (provider == null) {
                    Messages.showErrorDialog((Project)SelectSourceFolderDialog.this._project, (String)"Cannot open Add Module Dialog.", (String)"Add Module Dialog");
                    return;
                }
                AddModuleWizard moduleWizard = new AddModuleWizard(SelectSourceFolderDialog.this._project, provider);
                moduleWizard.show();
                if (moduleWizard.isOK()) {
                    ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)SelectSourceFolderDialog.this._project).getModifiableModel();
                    ModuleBuilder moduleBuilder = moduleWizard.getModuleBuilder();
                    try {
                        Module module = moduleBuilder.createModule(modifiableModel);
                        modifiableModel.commit();
                        ContentEntry[] contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries();
                        for (int i = 0; i < contentEntries.length; ++i) {
                            SourceFolder[] sourceFolders = contentEntries[i].getSourceFolders();
                            if (sourceFolders.length == 0) continue;
                            SelectSourceFolderDialog.this._sourceFolder = sourceFolders[0];
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getPath();
        if (path != null) {
            DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = pathComponent.getUserObject();
            if (userObject instanceof SourceFolder) {
                this._sourceFolder = (SourceFolder)userObject;
            }
            this.setOKActionEnabled(userObject instanceof SourceFolder);
        } else {
            this.setOKActionEnabled(false);
        }
    }

    public class ModuleTreeRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof Module) {
                CellAppearanceUtils.forModule((Module)((Module)userObject)).customize((SimpleColoredComponent)this);
            } else if (userObject instanceof SourceFolder) {
                CellAppearanceUtils.forSourceFolder((SourceFolder)((SourceFolder)userObject)).customize((SimpleColoredComponent)this);
            }
        }
    }

    private final class CreateModuleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionevent) {
            SelectSourceFolderDialog.this.createModule();
            SelectSourceFolderDialog.this.updateModuleList();
        }

        public CreateModuleAction() {
            super("Add Module...");
            this.putValue("MnemonicKey", new Integer(69));
        }
    }
}

