/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.com.generator.ideaplugin;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.jniwrapper.win32.com.generator.ideaplugin.ComfyJPluginConfiguration;
import com.jniwrapper.win32.com.generator.ideaplugin.ui.ProjectJDKComboBox;
import com.jniwrapper.win32.com.generator.ideaplugin.util.GeneratorPreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdom.Element;

public class ComfyJPluginConfigurable
implements ProjectComponent,
Configurable,
JDOMExternalizable {
    public static final String INCORRECT_VERSION = "The selected ComfyJ version is not supported.\nYou can download the latest version of ComfyJ by the following url:\nhttp://www.teamdev.com/comfyj/downloads.jsf";
    public static final String INCORRECT_VERSION_TITLE = "ComfyJ Version Mismatch";
    public static final String INCORRECT_LOCATION = "In this location ComfyJ is not found.";
    public static final String INCORRECT_LOCATION_TITLE = "ComfyJ Location Mismatch";
    private JRadioButton _projectJDKRBtn = new JRadioButton("Use project JDK:");
    private JRadioButton _specificJDKRBtn = new JRadioButton("Use specific JDK:");
    private JButton _specificJDKBtn = new FixedSizeButton(20);
    private JTextField _comfyJPath = new JTextField();
    private ProjectJDKComboBox _specificJDK = new ProjectJDKComboBox();
    private SimpleColoredComponent _projectJDK = new SimpleColoredComponent();
    private GeneratorPreferences _preferences = GeneratorPreferences.getInstance();
    private ComfyJPluginConfiguration _configuration = ComfyJPluginConfiguration.getInstance();
    private Project _project;
    private ImageIcon _icon;
    private boolean _modified = false;

    public ComfyJPluginConfigurable(Project project) {
        this._project = project;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createSelectJDKPanel(panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createComfyJPanel(panel), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 10), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateJDKPanel();
        return panel;
    }

    private JPanel createComfyJPanel(final JComponent panel) {
        JPanel comfyJPathPanel = new JPanel(new GridBagLayout());
        comfyJPathPanel.add((Component)new JLabel("ComfyJ path:", 4), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._comfyJPath.setText(this._preferences.getComfyJPath());
        comfyJPathPanel.add((Component)this._comfyJPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        FixedSizeButton comfyJPath = new FixedSizeButton(20);
        comfyJPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
                fileChooserDescriptor.setTitle("Select ComfyJ Folder");
                fileChooserDescriptor.setDescription("Specify path to ComfyJ installation folder");
                VirtualFile[] virtualFiles = FileChooser.chooseFiles((Component)panel, (FileChooserDescriptor)fileChooserDescriptor);
                for (int i = 0; i < virtualFiles.length; ++i) {
                    String generatorPath = virtualFiles[i].getPath();
                    if (!ComfyJPluginConfigurable.this._configuration.checkComfyJLocation(generatorPath)) {
                        Messages.showErrorDialog((Project)ComfyJPluginConfigurable.this._project, (String)ComfyJPluginConfigurable.INCORRECT_LOCATION, (String)ComfyJPluginConfigurable.INCORRECT_LOCATION_TITLE);
                        return;
                    }
                    if (!ComfyJPluginConfigurable.this._configuration.checkComfyJVersion(generatorPath)) {
                        Messages.showErrorDialog((Project)ComfyJPluginConfigurable.this._project, (String)ComfyJPluginConfigurable.INCORRECT_VERSION, (String)ComfyJPluginConfigurable.INCORRECT_VERSION_TITLE);
                        return;
                    }
                    ComfyJPluginConfigurable.this._comfyJPath.setText(generatorPath);
                    ComfyJPluginConfigurable.this._preferences.setComfyJPath(generatorPath);
                }
            }
        });
        comfyJPathPanel.add((Component)comfyJPath, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return comfyJPathPanel;
    }

    private JPanel createSelectJDKPanel(final JComponent panel) {
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ComfyJPluginConfigurable.this.updateJDKPanel();
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._projectJDKRBtn);
        buttonGroup.add(this._specificJDKRBtn);
        this._projectJDKRBtn.addItemListener(itemListener);
        this._specificJDKRBtn.addItemListener(itemListener);
        this._projectJDKRBtn.setSelected(this._configuration.getBooleanSetting("PROJECT_JDK_RBTN"));
        this._specificJDKRBtn.setSelected(this._configuration.getBooleanSetting("SPECIFIC_JDK_RBTN"));
        JPanel projectJDKPanel = new JPanel(new GridBagLayout());
        JLabel descriptionJDKPanel = new JLabel("Specify JDK to use for code generation and compilation");
        projectJDKPanel.add((Component)descriptionJDKPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        projectJDKPanel.add((Component)this._projectJDKRBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        projectJDKPanel.add((Component)this._projectJDK, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 10, 0, 10), 0, 0));
        projectJDKPanel.add((Component)this._specificJDKRBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._specificJDK.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    ComfyJPluginConfigurable.this._preferences.setSpecificJDK(ComfyJPluginConfigurable.this._specificJDK.getSelectedJDK());
                }
            }
        });
        projectJDKPanel.add((Component)this._specificJDK, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        this._specificJDKBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (panel.isShowing()) {
                    ProjectJdksEditor projectEditor = new ProjectJdksEditor(null, (Component)panel);
                    projectEditor.show();
                    ProjectJdk selectedJDK = projectEditor.getSelectedJdk();
                    if (projectEditor.isOK() && selectedJDK != null) {
                        ComfyJPluginConfigurable.this._preferences.setSpecificJDK(selectedJDK);
                    }
                    ComfyJPluginConfigurable.this.updateJDKPanel();
                }
            }
        });
        projectJDKPanel.add((Component)this._specificJDKBtn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        JPanel selectJDKPanel = new JPanel(new GridBagLayout());
        selectJDKPanel.setBorder(BorderFactory.createTitledBorder("JDK settings:"));
        selectJDKPanel.add((Component)projectJDKPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return selectJDKPanel;
    }

    private void updateJDKPanel() {
        this._projectJDK.setEnabled(this._projectJDKRBtn.isSelected());
        if (this._projectJDKRBtn.isSelected()) {
            this._preferences.setProjectJDK(ProjectRootManager.getInstance((Project)this._project).getProjectJdk());
        }
        this._specificJDKBtn.setEnabled(this._specificJDKRBtn.isSelected());
        this._specificJDK.setEnabled(this._specificJDKRBtn.isSelected());
        this._specificJDK.update(this._preferences.getSpecificJDK());
        this._projectJDK.clear();
        CellAppearanceUtils.forJdk((ProjectJdk)this._preferences.getProjectJDK(), (boolean)false, (boolean)false).customize(this._projectJDK);
        this._projectJDK.repaint();
    }

    public boolean isModified() {
        boolean modified = false;
        if (this._projectJDKRBtn.isSelected() != this._configuration.getBooleanSetting("PROJECT_JDK_RBTN")) {
            modified = true;
        } else if (this._specificJDKRBtn.isSelected() != this._configuration.getBooleanSetting("SPECIFIC_JDK_RBTN")) {
            modified = true;
        } else if (!this._comfyJPath.getText().equals(this._configuration.getStringSetting("COMFYJ_PATH"))) {
            modified = true;
        } else if (!this._preferences.getSpecificJDKName().equals(this._configuration.getStringSetting("SPECIFIC_JDK"))) {
            modified = true;
        } else if (!this._preferences.getProjectJDKName().equals(this._configuration.getStringSetting("PROJECT_JDK"))) {
            modified = true;
        }
        return modified | this._modified;
    }

    public void apply() throws ConfigurationException {
        String comfyJPath = this._comfyJPath.getText();
        if (!"".equals(comfyJPath) && !this._configuration.checkComfyJLocation(comfyJPath)) {
            throw new ConfigurationException(INCORRECT_LOCATION, INCORRECT_LOCATION_TITLE);
        }
        if (!"".equals(comfyJPath) && !this._configuration.checkComfyJVersion(comfyJPath)) {
            throw new ConfigurationException(INCORRECT_VERSION, INCORRECT_VERSION_TITLE);
        }
        this._preferences.setComfyJPath(comfyJPath);
        this._configuration.setSetting("PROJECT_JDK_RBTN", this._projectJDKRBtn.isSelected());
        this._configuration.setSetting("SPECIFIC_JDK_RBTN", this._specificJDKRBtn.isSelected());
        this._configuration.setSetting("COMFYJ_PATH", this._preferences.getComfyJPath());
        this._configuration.setSetting("PROJECT_JDK", this._preferences.getProjectJDKName());
        this._configuration.setSetting("SPECIFIC_JDK", this._preferences.getSpecificJDKName());
        this._modified = false;
    }

    public void reset() {
        this._projectJDKRBtn.setSelected(this._configuration.getBooleanSetting("PROJECT_JDK_RBTN"));
        this._specificJDKRBtn.setSelected(this._configuration.getBooleanSetting("SPECIFIC_JDK_RBTN"));
        this._preferences.setProjectJDK(this._configuration.getStringSetting("PROJECT_JDK"));
        this._preferences.setSpecificJDK(this._configuration.getStringSetting("SPECIFIC_JDK"));
        this._comfyJPath.setText(this._preferences.getComfyJPath());
        this._modified = false;
    }

    public void disposeUIResources() {
    }

    public String getComponentName() {
        return "JNIWrapper ComfyJ Generator";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public String getDisplayName() {
        return "ComfyJ Generator";
    }

    public Icon getIcon() {
        if (this._icon == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this._icon = new ImageIcon(classLoader.getResource("images/comfyjgenerator.png"));
        }
        return this._icon;
    }

    public String getHelpTopic() {
        return null;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        this._configuration.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this._configuration.writeExternal(element);
    }
}

