/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.generator.c;

import com.jniwrapper.generator.c.Type;

public class TypeID {
    public static final int IS_UNKNOWN_TYPE = -1;
    public static final int IS_COMPLEX_TYPE = 0;
    public static final int IS_STRUCTIRE_TYPE = 1;
    public static final int IS_UNION_TYPE = 2;
    public static final int IS_ENUM_TYPE = 3;
    public static final int IS_CALLBACK_TYPE = 4;

    public static boolean isComplexType(Type type) {
        return type.getTypeId() == 0;
    }

    public static boolean isStructure(Type type) {
        return type.getTypeId() == 1;
    }

    public static boolean isUnion(Type type) {
        return type.getTypeId() == 2;
    }

    public static boolean isStructureOrUnion(Type type) {
        int n2 = type.getTypeId();
        return n2 == 1 || n2 == 2;
    }

    public static boolean isEnumeration(Type type) {
        return type.getTypeId() == 3;
    }

    public static boolean isCallback(Type type) {
        return type.getTypeId() == 4;
    }

    public static String getTypeName(int n2) {
        String string = "";
        switch (n2) {
            case 1: {
                string = "Structure";
                break;
            }
            case 2: {
                string = "Union";
                break;
            }
            case 3: {
                string = "Enumeration";
                break;
            }
            case 4: {
                string = "Callback";
                break;
            }
            case -1: {
                string = "Unknown type";
                break;
            }
            case 0: {
                string = "Complex type";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }
}

