/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt8;

public class RGBQuad
extends Structure {
    private UInt8 _blue = new UInt8();
    private UInt8 _green = new UInt8();
    private UInt8 _red = new UInt8();
    private UInt8 _reserved = new UInt8();

    public RGBQuad(int r, int g, int b) {
        this();
        this.setRed(r);
        this.setGreen(g);
        this.setBlue(b);
    }

    public RGBQuad() {
        this.init();
    }

    private void init() {
        this.init(new Parameter[]{this._blue, this._green, this._red, this._reserved});
        this._reserved.setValue(0L);
    }

    public RGBQuad(RGBQuad that) {
        this.init();
        this.setRed(that.getRed());
        this.setGreen(that.getGreen());
        this.setBlue(that.getBlue());
    }

    public long getBlue() {
        return this._blue.getValue();
    }

    public void setBlue(long value) {
        this._blue.setValue(value);
    }

    public long getGreen() {
        return this._green.getValue();
    }

    public void setGreen(long value) {
        this._green.setValue(value);
    }

    public long getRed() {
        return this._red.getValue();
    }

    public void setRed(long value) {
        this._red.setValue(value);
    }

    public int getRGB() {
        int result = (int)(this.getRed() << 16 | this.getGreen() << 8 | this.getBlue());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RGBQuad) {
            RGBQuad quad = (RGBQuad)((Object)obj);
            return this.getRed() == quad.getRed() && this.getGreen() == quad.getGreen() && this.getBlue() == quad.getBlue();
        }
        return false;
    }

    public int hashCode() {
        int result = this._blue.hashCode();
        result = 29 * result + this._green.hashCode();
        result = 29 * result + this._red.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("RGBQuad (");
        result.append(this.getRed());
        result.append(", ");
        result.append(this.getGreen());
        result.append(", ");
        result.append(this.getBlue());
        result.append(")");
        return result.toString();
    }

    public Object clone() {
        return new RGBQuad(this);
    }
}

