using System;
using System.Collections;
using System.Text;
using NI.Email.Mime;
using NI.Email.Mime.Decoder;
using NI.Email.Mime.Message;

namespace NI.Mime4Net.Samples.InfiniteMimeStream {
	
	class Program {
		static void Main(string[] args) {

			string startMimePart = @"Content-type: multipart/x-mixed-replace;boundary=---ThisRandomString---

-----ThisRandomString---
";
			string infiniteMimePart = @"Content-type: text/html

This part updates every 2 seconds
-----ThisRandomString---
";

			DelayedMemoryStream inputStream = new DelayedMemoryStream(
				Encoding.ASCII.GetBytes(startMimePart), Encoding.ASCII.GetBytes(infiniteMimePart) );

			MimeStreamParser mimeStreamParser = new MimeStreamParser();
			mimeStreamParser.SetContentHandler( new MimePartHandler() );
			mimeStreamParser.Parse(inputStream);

		}

		class MimePartHandler : IContentHandler {

			public void Body(BodyDescriptor bd, System.IO.Stream inputStream) {
				// skip multipart
				if (bd.IsMultipart) return;

				Console.WriteLine("Received new part, content type: "+bd.MimeType);

				string enc = bd.TransferEncoding;
				if ("base64".Equals(enc)) {
					inputStream = new Base64InputStream(inputStream);
				} else if ("quoted-printable".Equals(enc)) {
					inputStream = new QuotedPrintableInputStream(inputStream);
				}
	            
				if (bd.MimeType.StartsWith("text/")) {
					MemoryTextBody body = new MemoryTextBody(inputStream, bd.Charset);
					Console.WriteLine( body.Reader.ReadToEnd() );
				} 
				

			}

			public void EndBodyPart() {
			}

			public void EndHeader() {
			}

			public void EndMessage() {
			}

			public void EndMultipart() {
			}

			public void Epilogue(System.IO.Stream inputStream) {
			}

			public void Field(string fieldData) {
			}

			public void Preamble(System.IO.Stream inputStream) {
			}

			public void Raw(System.IO.Stream inputStream) {
			}

			public void StartBodyPart() {
			}

			public void StartHeader() {
			}

			public void StartMessage() {
			}

			public void StartMultipart(BodyDescriptor bd) {
			}

		}
}
}
