using System;
using System.Text;
using System.IO;
using System.Threading;
using System.Collections;

//using NI.Email.MonoWebMail;
using NI.Email.Mime.Message;
using NI.Email.Mime.Field;
using NI.Email.Mime.Util;
using NI.Email.Mime.Field.Address;

using NUnit.Framework;

namespace NI.Tests.Email.Mime.Message
{
	[TestFixture]
	public class MessageBuilderTest
	{
        [Test]
        public void ComposeMessage()
        {
            MimeMessage parent = new MimeMessage();
            Multipart multi = new Multipart();

            Header parentHeader = new Header();
            parentHeader.AddMimeVersion();

            parentHeader.AddSubject("test composed message");

            ArrayList fromList = new ArrayList();
            fromList.Add(new Mailbox("test1@foo.net"));
            parentHeader.AddFrom(new MailboxList(fromList, false));

            ArrayList mbList = new ArrayList();
            mbList.Add(new Mailbox("firstTo@foo.baz.net"));
            mbList.Add(new Mailbox("secondTo@bar.baz.org"));
            ArrayList toList = new ArrayList();
            toList.Add(new Group("The Powerful Receivers", new MailboxList(mbList, false)));
            toList.Add(new NamedMailbox("Joe Cocker", new Mailbox("joe@cockersfamily.biz")));
            toList.Add(new Mailbox("simple@mail.baz.net"));

            parentHeader.AddTo(new AddressList(toList, false));

            parentHeader.AddContentTransferEncoding(ContentTransferEncodingField.Encoding8Bit);

            IDictionary otherValues = new Hashtable();
            otherValues[ContentTypeField.ParamCharset] = "US-ASCII";
            otherValues["fooparam"] = "foovalue";
            parentHeader.AddContentType(ContentTypeField.TypeMultipartMixed, otherValues);

            parentHeader.AddField(DateTimeField.Parse(MimeField.Date, new DateTime(2003, 8, 18)));
            
            parent.Header = parentHeader;

            BodyPart bodyFirst = new BodyPart();
            Header bodyFirstHeader = new Header();
            otherValues.Clear();
            otherValues[ContentTypeField.ParamCharset] = "US-ASCII";
            bodyFirstHeader.AddContentType(ContentTypeField.TypeTextHtml, otherValues, false);

            bodyFirst.Header = bodyFirstHeader;
            MemoryStream streamFirst = new MemoryStream();
            StreamWriter writer = MessageBuilderUtil.GetWriter(streamFirst);
            writer.WriteLine("some sample text");
            streamFirst.Position = 0;
            bodyFirst.Body = new MemoryTextBody(streamFirst);
            multi.AddBodyPart(bodyFirst);
            parent.Body = multi;

            MemoryStream ms = new MemoryStream();
            parent.WriteTo(ms);

            /*FileStream fs = new FileStream("test_composed_message.msg", FileMode.Create);
            parent.WriteTo(fs);

            SimpleSmtpSender sender = new SimpleSmtpSender("");
            sender.Connect();
            sender.Send("", "", "test composed message subject", ms);
            sender.Close();

            ms.Close();
            fs.Close();*/
        }
        
        //[Test]
		public void test_WriteTo()
		{
            string[] fileNames = Directory.GetFiles("../../testmsgs", "*.msg");
			for (int i = 0; i < fileNames.Length; ++i)
			{
				MimeMessage msg = new MimeMessage(new FileStream(fileNames[i], FileMode.Open, FileAccess.Read));
                FileStream fs = new FileStream(fileNames[i].Replace(".msg", ".mmsg"), FileMode.Create);
				msg.WriteTo(fs);
				fs.Flush();
				fs.Close();
			}
		}

		//[Test]
		public void test_ChangeAndWriteTo()
		{
			string[] fileNames = Directory.GetFiles("../../testmsgs", "*.msg");
			for (int i = 0; i < fileNames.Length; ++i)
			{
				MimeMessage msg = new MimeMessage(new FileStream(fileNames[i], FileMode.Open, FileAccess.Read));
                msg.Header.ChangeField(MimeField.From, MimeField.Parse("From: changed@mail.com"));
				FileStream fs = new FileStream(fileNames[i].Replace(".msg", ".mmsg"), FileMode.Create);
				msg.WriteTo(fs);
				fs.Flush();
				fs.Close();
			}
		}

		//[Test]
		public void test_WriteToAndSend()
		{
			string[] fileNames = Directory.GetFiles("../../testmsgs", "*.msg");
			for (int i = 0; i < fileNames.Length; ++i)
			{
				MimeMessage msg = new MimeMessage(new FileStream(fileNames[i], FileMode.Open, FileAccess.Read));
				msg.Header.ChangeField(MimeField.From, MimeField.Parse("From: changed@mail.com"));
                FileStream fs = new FileStream(fileNames[i].Replace(".msg", ".mmsg"), FileMode.Create);
				msg.WriteTo(fs);
				fs.Flush();
				fs.Close();
			}
			
			fileNames = Directory.GetFiles("../../testmsgs", "*.*msg");
			// specify your SMTP server here
			try
			{
				/*SimpleSmtpSender sender = new SimpleSmtpSender("test_smtp_server");
				sender.Connect();
				for (int i = 0; i < fileNames.Length; ++i)
				{
					Console.WriteLine(String.Format("Sending {0} ...", fileNames[i]));
					// specify valid from and to here
					sender.Send("your@mail.here", "your@mail.here", "SUBJ", new FileStream(fileNames[i], FileMode.Open, FileAccess.Read));
					Thread.Sleep(1000);
				}
				sender.Close();*/
			}
			catch (Exception ex)
			{
				throw ex;
			}
		}


	}
}
