﻿using System;
using System.Collections.Generic;
using System.Text;

using HiMap.Carto;
using HiMap.Driver;
using HiMap.Geometry;
using HiMap.MapControls;
using HiMap.MapControls.Tools;
using HiMap.Style;

namespace HiMap
{
    public class ToolInfoClass : HiMap.MapControls.Tools.ToolClass
    {
        //Override the event
        protected override void OnMouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            //Create a spatial query object
            HiMap.Carto.ISpatialFilter sf = new HiMap.Carto.SpatialFilterClass();

            //Set buffers
            sf.Buffer = 20;
            //Set a center point to query
            sf.Geometry = (HiMap.Geometry.IGeometry)this.Map.PointToMapPoint(e.X, e.Y);
            //Define a metadata
            HiMap.Carto.IFeatureClass cls;
            //Define a feature cursor

            HiMap.Carto.IFeatureCursor fc;
            //Loop layer
            for (int i = 0; i < this.Map.Map.LayerCount; i++)
            {
                //Get a metadata
                cls = (HiMap.Carto.IFeatureClass)this.Map.Map.GetLayer(i).Class;
                //Query data
                fc = cls.Search(sf);
                //Rearrange data
                fc.Flush();
                //Get data
                HiMap.Carto.IFeature feat = fc.Next();

                while (feat != null)
                {
                    //Display data id
                    System.Windows.Forms.MessageBox.Show("Name: " + feat.GetValue(cls.Fields.FindField("Name")));
                    
                    //Go to next data
                    feat = fc.Next();
                }

            }
        }
    }
}
