﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;


namespace HiMap
{
    /// <summary>
    /// Tool for create polylines
    /// </summary>
    public class ToolCreatePolyline : ToolCreatePoint
    {
        public ToolCreatePolyline(Form frm, IFeatureLayer layer):base(frm,layer)
        {
        }
        protected override void OnToolCreate(HiMap.MapControls.MapControl Map)
        {
            base.OnToolCreate(Map);
            MePic = new PicCtrl(_frm, Map, listPoint, listPoint1, PicType.Polyline);
        }
        protected override void Btn3Click(object sender, EventArgs e)
        {
            if (listPoint.Count < 2)
            {
                System.Windows.Forms.MessageBox.Show("A line must have 2 nodes least, continue to draw.");
                return;
            }
            IFeatureClass cls = (IFeatureClass)_layer.Class;
            IFeature feat = null;
            IPointCollection line = new PolylineClass();
            for (int i = 0; i < listPoint.Count; i++)
            {
                feat = cls.CreateFeature();
                line.AddPoint(listPoint[i]);
            }
            feat.Shape = line;
            feat.Save();
            BtnExitClick(null, null);
        }
    }
}
