﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;

namespace HiMap
{
    public enum PicType {Point,Polyline,Polygon}

    public class PicCtrl
    {
        //Parent form
        Form _frm;
        //Map control
        MapControls.MapControl _Map;
        //Map points collection
        List<IPoint> _MapPoints;
        //Screen points
        List<System.Drawing.Point> _Points;
        //Geometry type
        PicType _Type;
        //pictureBox collection
        List<System.Windows.Forms.PictureBox> _Pics;
        //Picture name index
        int NameIndex;
        //Picture has been drag whther or not
        bool isMouseDown;
        //Picture start location
        int PicStaX, PicStaY;
        public PicCtrl(Form frm, MapControls.MapControl Map, List<IPoint> MapPoints, List<System.Drawing.Point> Points,PicType Type) 
        {
            _frm = frm;
            _Map = Map;
            _MapPoints = MapPoints;
            _Points = Points;
            _Type = Type;
            NameIndex = 0;
            isMouseDown = false;
            _Pics = new List<PictureBox>();
        }

        public PictureBox this[int index] 
        {
            get 
            {
                return _Pics[index];
            }
        }

        //Delete picture
        public void Delete(int index)
        {
            _frm.Controls.Remove(_Pics[index]);
            _Pics.RemoveAt(index);
            _MapPoints.RemoveAt(index);
            _Points.RemoveAt(index);
            this.Draw();
        }

        //Create a picture
        public void CreatePic(int x, int y)
        {
            PictureBox pic = new PictureBox();
            pic.Name = "pic" + NameIndex.ToString();
            pic.Visible = false;
            pic.Width = 14;
            pic.Height = 14;
            pic.BackColor = System.Drawing.Color.Red;
            pic.Location = new System.Drawing.Point(x - 8, this._Map.Location.Y + y - 8);
            pic.MouseDown += new MouseEventHandler(PicMouseDown);
            pic.MouseMove += new MouseEventHandler(PicMouseMove);
            pic.MouseUp += new MouseEventHandler(PicMouseUp);
            _frm.Controls.Add(pic);
            _frm.Controls.SetChildIndex(pic, 0);
            NameIndex++;
            pic.Visible = true;
            _Pics.Add(pic);
        }

        //Clear controls of the form
        public void Clear() 
        {
            int i;
            i = _frm.Controls.Count - 1;
            while (i >= 0)
            {
                if (_frm.Controls[i].GetType() == typeof(PictureBox))
                {
                    _frm.Controls.RemoveAt(i);
                }
                i--;
            }
            //Edit the name index to original

            NameIndex = 0;
            _Pics.Clear();
        }

        //Draw
        public void Draw() 
        {
            switch (_Type) 
            { 
                case PicType.Point:
                    break;
                case PicType.Polyline:
                    this.Drawline();
                    break;
                case PicType.Polygon:
                    this.DrawPolygon();
                    break;
            }
        }

        private void PicMouseMove(object sender, MouseEventArgs e)
        {
            PictureBox MePic = (PictureBox)sender;
            if (isMouseDown == true)
            {
                MePic.Location = new System.Drawing.Point(MePic.Location.X + e.X - PicStaX, MePic.Location.Y + e.Y - PicStaY);
            }
        }



        private void PicMouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            isMouseDown = true;
            PicStaX = e.X;
            PicStaY = e.Y;
        }

        private void PicMouseUp(object sender, MouseEventArgs e)
        {
            PictureBox MePic = (PictureBox)sender;
            this._MapPoints[_Pics.IndexOf(MePic)] = this._Map.PointToMapPoint(MePic.Location.X + 8 - _Map.Location.X, MePic.Location.Y + 8 - _Map.Location.Y);
            this._Points[_Pics.IndexOf(MePic)] = new System.Drawing.Point(MePic.Location.X + 8 - _Map.Location.X, MePic.Location.Y + 8 - _Map.Location.Y);
            this._Map.MapRefresh();
            isMouseDown = false;
            this.Draw();
        }

        //Draw line
        private void Drawline()
        {
            if (this._Points.Count >= 2)
            {
                this._Map.MapRefresh();
                System.Drawing.Point[] pts = new System.Drawing.Point[this._Points.Count];
                for (int i = 0; i < this._Points.Count; i++)
                {
                    pts[i] = new System.Drawing.Point();
                    pts[i].X = this._Points[i].X;
                    pts[i].Y = this._Points[i].Y;
                }
                this._Map.DrawLine(new System.Drawing.Pen(System.Drawing.Color.FromArgb(128, 255, 255)), pts);
            }
        }
        //Drwa polygon
        private void DrawPolygon()
        {
            if (this._Points.Count >= 3)
            {
                this._Map.MapRefresh();
                System.Drawing.Point[] pts = new System.Drawing.Point[this._Points.Count];
                for (int i = 0; i < this._Points.Count; i++)
                {
                    pts[i] = new System.Drawing.Point();
                    pts[i].X = this._Points[i].X;
                    pts[i].Y = this._Points[i].Y;
                }
                this._Map.DrawPolygon(new System.Drawing.Pen(System.Drawing.Color.FromArgb(128, 255, 255))
                    , new System.Drawing.SolidBrush(System.Drawing.Color.FromArgb(128, 255, 255))
                    , pts);
            }
        }

    }
}
