﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using HiMap.Carto;
using HiMap.MapControls.Tools;
using HiMap.Geometry;

namespace HiMap
{
    public partial class FrmInfo : Form
    {
        IFeature _feat;
        public FrmInfo(IFeature feat)
        {
            InitializeComponent();
            //Check the Name field was exist whether or not.
            IFeatureClass cls = (IFeatureClass)feat.Class;

            if (cls.Fields.FieldCount <= 0)
            {
                return;
            }

            int index = cls.Fields.FindField(cls.Fields.GetField(0).Name);
            if (index == -1)
            {
                MessageBox.Show(cls.Fields.GetField(0).Name + " Field doesn't exist, function failed.");
                this.Close();
            }
            else
            {
                if (feat.GetValue(index) != null)
                {
                    this.txtName.Text = feat.GetValue(index).ToString();
                }
                else
                {
                    this.txtName.Text = "";
                }
                _feat = feat;
            }
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            //Save changes
            IFeatureClass cls = (IFeatureClass)_feat.Class;
            int index=cls.Fields.FindField("Name");
            if (index==-1)
            {
                MessageBox.Show("Field does not exist, can't modify");
                return;
            }
            _feat.SetValue(index, txtName.Text);
            _feat.Save();
            this.Close();
        }
    }
}