//ZylFileGPSReceiver
//Copyright by Zyl Soft 2003 - 2006

unit ZylFileGPSReceiver;

{$C-}
interface

{$I IdCompilerDefines.inc}

uses
  ZylCustomGPSReceiver, SysUtils, Windows, Classes
  {$ifndef CPPB5}
  , Forms
  {$endif};

type
  TConnectEvent = procedure(Sender: TObject; FileName: String) of object;

  TZylFileGPSReceiver = class(TZylCustomGPSReceiver)
  private
    FFileName: String;
    FDelay: Integer;

    FConnected: Boolean;

    FOnConnect: TConnectEvent;
    FOnDisconnect: TConnectEvent;

    procedure SetFileName(Value: String);
    function ProcessFromFile(FileName: String): Integer;
  public
    //constructor
    constructor Create(AOwner: TComponent);override;
    //destructor
    destructor Destroy();override;

    //starts communication
    procedure Open();
    //stops communication
    procedure Close();

  published
    { Published declarations }
    property FileName: String read FFileName write SetFileName;

    property ForceCheckSum;
    {$ifndef CPPB5}
    property NMEALog;
    {$endif}
    property Commands;

    property Delay: Integer read FDelay write FDelay default 1000;

    property OnConnect: TConnectEvent read FOnConnect write FOnConnect;
    property OnDisconnect: TConnectEvent read FOnDisconnect write FOnDisconnect;
    //fires when new data was received
    property OnReceive;
    property OnLatitudeChange;
    property OnLongitudeChange;
    property OnAltitudeChange;
    property OnSpeedChange;
    property OnHeadingChange;
    property OnPosition2DChange;
    property OnPosition3DChange;
    property OnSatelliteReceive;
    property OnSatellitesReceive;
    property OnArrival;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Zyl Soft', [TZylFileGPSReceiver]);
end;

{ TZylFileGPSReceiver }

constructor TZylFileGPSReceiver.Create(AOwner: TComponent);
begin
  inherited;

  FFileName := '';
  FDelay := 1000;

  FConnected := False;

  FOnConnect := nil;
  FOnDisconnect := nil;
end;

destructor TZylFileGPSReceiver.Destroy;
begin
  FConnected := False;
  Sleep(50);
  inherited;
end;

procedure TZylFileGPSReceiver.Open;
begin
  if FileExists(FFileName) then
  begin
    FConnected := True;
    if Assigned(FOnConnect) then
      FOnConnect(Self, FFileName);
    ProcessFromFile(FFileName);
  end;
end;

procedure TZylFileGPSReceiver.Close;
begin
  FConnected := False;
end;

function TZylFileGPSReceiver.ProcessFromFile(FileName: String): Integer;
var
  f: TextFile;
  str: String;
  strNMEA: String;
begin
  Result := 0;
  if FileExists(FileName) then
  begin
    AssignFile(f, FileName);
    Reset(f);
    strNMEA := '';
    while FConnected and not Eof(f) do
    begin
      Readln(f, str);
      if Pos('$GPRMC', str) > 0 then
      begin
        Result := Result + 1;
        Sleep(FDelay);
        FeedGPSReceiver(strNMEA);
        strNMEA := str + #13#10;
      end
      else
      begin
        strNMEA := strNMEA + str + #13#10;
      end;
      {$ifndef CPPB5}
      Application.ProcessMessages;
      {$endif}
    end;
    CloseFile(f);
    if Assigned(FOnDisconnect) then
      FOnDisconnect(Self, FFileName);
  end;
end;

procedure TZylFileGPSReceiver.SetFileName(Value: String);
begin
  if (FFileName <> Value) and FileExists(Value) then
  begin
    FFileName := Value;
    if FConnected then
    begin
      Close();
      Sleep(50);
      Open();
    end;
  end;
end;

end.
 