unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ZylGPSReceiver, ComCtrls, ExtCtrls,
  ZylCustomGPSReceiver;

type
  TfrmMain = class(TForm)
    btnStart: TButton;
    btnStop: TButton;
    ZylGPSReceiver: TZylGPSReceiver;
    memRaw: TMemo;
    GroupBox1: TGroupBox;
    efLatDeg: TEdit;
    Label1: TLabel;
    efLatMin: TEdit;
    Label2: TLabel;
    efLatSec: TEdit;
    Label3: TLabel;
    efLatDir: TEdit;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    efLongDeg: TEdit;
    efLongMin: TEdit;
    efLongSec: TEdit;
    efLongDir: TEdit;
    GroupBox3: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    efAlt: TEdit;
    efSpeed: TEdit;
    efHeading: TEdit;
    efSatCount: TEdit;
    Label13: TLabel;
    lstPort: TListBox;
    Label15: TLabel;
    Label16: TLabel;
    lblUTCTime: TLabel;
    lblLocalTime: TLabel;
    PaintBox: TPaintBox;
    btnUpload: TButton;
    GroupBox4: TGroupBox;
    Label14: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    efSignal: TEdit;
    efSNR: TEdit;
    efFrq: TEdit;
    efDataRate: TEdit;
    procedure ZylGPSReceiverReceive(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure ZylGPSReceiverSpeedChange(Sender: TObject; Value: Extended);
    procedure ZylGPSReceiverHeadingChange(Sender: TObject; Value: Extended);
    procedure ZylGPSReceiverConnect(Sender: TObject; Port: TCommPort);
    procedure ZylGPSReceiverDisconnect(Sender: TObject; Port: TCommPort);
    procedure ZylGPSReceiverAltitudeChange(Sender: TObject; Value: Extended);
    procedure ZylGPSReceiverLatitudeChange(Sender: TObject; Degree,
      Minute: Integer; Second: Extended; Direction: TCardinalPoint);
    procedure ZylGPSReceiverLongitudeChange(Sender: TObject; Degree,
      Minute: Integer; Second: Extended; Direction: TCardinalPoint);
    procedure ZylGPSReceiver2DPositionChange(Sender: TObject; Latitude,
      Longitude: Extended);
    procedure ZylGPSReceiver3DPositionChange(Sender: TObject; Latitude,
      Longitude, Altitude: Extended);
    procedure ZylGPSReceiverSatelliteReceive(Sender: TObject;
      Satellite: TSatellite);
    procedure PaintBoxPaint(Sender: TObject);
    procedure ZylGPSReceiverSatellitesReceive(Sender: TObject);
    procedure btnUploadClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.ZylGPSReceiverReceive(Sender: TObject);
//var
//  f: TextFile;
begin
  efLatDeg.Text := IntToStr(ZylGPSReceiver.GetLatitudeDegree);
  efLatMin.Text := IntToStr(ZylGPSReceiver.GetLatitudeMinute);
  efLatSec.Text := FloatToStr(ZylGPSReceiver.GetLatitudeSecond);
  if ZylGPSReceiver.GetLatitudeDirection = cpNorth then
    efLatDir.Text := 'North'
  else
    efLatDir.Text := 'South';

  efLongDeg.Text := IntToStr(ZylGPSReceiver.GetLongitudeDegree);
  efLongMin.Text := IntToStr(ZylGPSReceiver.GetLongitudeMinute);
  efLongSec.Text := FloatToStr(ZylGPSReceiver.GetLongitudeSecond);
  if ZylGPSReceiver.GetLongitudeDirection = cpEast then
    efLongDir.Text := 'East'
  else
    efLongDir.Text := 'West';

  efAlt.Text := FloatToStr(ZylGPSReceiver.GetAltitude);
  efSpeed.Text := FloatToStr(ZylGPSReceiver.GetSpeed_KMH);
  efHeading.Text := FloatToStr(ZylGPSReceiver.GetHeading);
  efSatCount.Text := IntToStr(ZylGPSReceiver.GetSatelliteCount);

  lblUTCTime.Caption := DateTimeToStr(ZylGPSReceiver.GetUTCDateTime);
  lblLocalTime.Caption := DateTimeToStr(ZylGPSReceiver.GetLocalDateTime);

  try
    efSignal.Text := FloatToStr(ZylGPSReceiver.GetReceiverStatus.SignalStrength);
    efSNR.Text := FloatToStr(ZylGPSReceiver.GetReceiverStatus.SNR);
    efFrq.Text := FloatToStr(ZylGPSReceiver.GetReceiverStatus.Frequency);
    efDataRate.Text := FloatToStr(ZylGPSReceiver.GetReceiverStatus.DataRate);
  except
  end;

  try
    memRaw.Lines.Add(ZylGPSReceiver.GetRawData);
    memRaw.Lines.Add('Fix = ' + IntToStr(ZylGPSReceiver.IsFix));
    //AssignFile(f, 'c:\gpsout.txt');
    //Append(f);
    //Write(f, ZylGPSReceiver.GetRawData);
    //CloseFile(f);
    memRaw.Lines.Add('---------------------------------------------------------')
  except
    memRaw.Lines.Clear;
  end;
end;

procedure TfrmMain.btnStartClick(Sender: TObject);
begin
  ZylGPSReceiver.Port := TCommPort(lstPort.ItemIndex + 1);
  ZylGPSReceiver.Open;
end;

procedure TfrmMain.btnStopClick(Sender: TObject);
begin
  ZylGPSReceiver.Close;
end;

procedure TfrmMain.ZylGPSReceiverSpeedChange(Sender: TObject; Value: Extended);
begin
  memRaw.Lines.Add('Speed Changed:' + FloatToStr(Value) + ' KM/H');
end;

procedure TfrmMain.ZylGPSReceiverHeadingChange(Sender: TObject;
  Value: Extended);
begin
  memRaw.Lines.Add('Heading Changed:' + FloatToStr(Value) + ' Degrees');
end;

procedure TfrmMain.ZylGPSReceiverConnect(Sender: TObject; Port: TCommPort);
begin
  memRaw.Lines.Add('Connected to:' + ZylGPSReceiver.CommPortToString(Port));
end;

procedure TfrmMain.ZylGPSReceiverDisconnect(Sender: TObject;
  Port: TCommPort);
begin
  memRaw.Lines.Add('Disconnected from:' + ZylGPSReceiver.CommPortToString(Port));
end;

procedure TfrmMain.ZylGPSReceiverAltitudeChange(Sender: TObject;
  Value: Extended);
begin
  memRaw.Lines.Add('Altitude Changed:' + FloatToStr(Value) + ' M');
end;

procedure TfrmMain.ZylGPSReceiverLatitudeChange(Sender: TObject; Degree,
  Minute: Integer; Second: Extended; Direction: TCardinalPoint);
begin
  memRaw.Lines.Add('Latitude Changed: ' + FloatToStr(ZylGPSReceiver.DMSToDecimalDegrees(Degree, Minute, Second, Direction)));
end;

procedure TfrmMain.ZylGPSReceiverLongitudeChange(Sender: TObject; Degree,
  Minute: Integer; Second: Extended; Direction: TCardinalPoint);
begin
  memRaw.Lines.Add('Longitude Changed: ' + FloatToStr(ZylGPSReceiver.DMSToDecimalDegrees(Degree, Minute, Second, Direction)));
end;

procedure TfrmMain.ZylGPSReceiver2DPositionChange(Sender: TObject;
  Latitude, Longitude: Extended);
begin
  memRaw.Lines.Add('2D Position Changed. Distance to New York City = ' + FloatToStr(ZylGPSReceiver.Distance_Km(Latitude, Longitude, 40.77, 73.98)) + ' KM');
end;

procedure TfrmMain.ZylGPSReceiver3DPositionChange(Sender: TObject;
  Latitude, Longitude, Altitude: Extended);
begin
  memRaw.Lines.Add('3D Position Changed.');
end;

procedure TfrmMain.ZylGPSReceiverSatelliteReceive(Sender: TObject;
  Satellite: TSatellite);
var
  str: String;
begin
  str := 'Satellite Received' + ' Code=' + IntToStr(Satellite.PseudoRandomCode);
  str := str + ' Elevation=' + IntToStr(Satellite.Elevation);
  str := str + ' Azimuth=' + IntToStr(Satellite.Azimuth);
  str := str + ' Signal=' + IntToStr(Satellite.SignalToNoiseRatio);
  memRaw.Lines.Add(str);
end;

procedure TfrmMain.PaintBoxPaint(Sender: TObject);
var
  origX, origY: Word;
  circleCount: Word;
  i: Integer;
  p: TPoint;
  x, y: Word;
  Azim, Elev: Word;
  objSat: TSatellite;
  lst: TList;
begin
  origX := PaintBox.Width div 2;
  origY := PaintBox.Height div 2;
  circleCount := 6;
  PaintBox.Canvas.Brush.Color := clBlack;
  PaintBox.Canvas.Pen.Color := clBtnFace;
  PaintBox.Canvas.Pen.Width := 1;
  for i := 1 to circleCount do
  begin
    PaintBox.Canvas.Ellipse((i-1)*PaintBox.Width div (2*CircleCount), (i-1)*PaintBox.Height div (2*CircleCount),
      (2*CircleCount - i + 1)*PaintBox.Width div (2*CircleCount), (2*CircleCount - i + 1)*PaintBox.Height div (2*CircleCount));
  end;

  p.X := PaintBox.Width div 2;
  p.Y := 0;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(PaintBox.Width div 2, PaintBox.Height);

  p.X := PaintBox.Width div 2 + Round((sin(pi/6)/cos(pi/6)) * PaintBox.Height / 2);
  p.Y := 0;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(PaintBox.Width div 2 - Round((sin(pi/6)/cos(pi/6)) * PaintBox.Height / 2), PaintBox.Height);

  p.X := PaintBox.Width div 2 + Round((sin(pi/3)/cos(pi/3)) * PaintBox.Height / 2);
  p.Y := 0;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(PaintBox.Width div 2 - Round((sin(pi/3)/cos(pi/3)) * PaintBox.Height / 2), PaintBox.Height);

  p.X := PaintBox.Width div 2 + Round((sin(2*pi/3)/cos(2*pi/3)) * PaintBox.Height / 2);
  p.Y := 0;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(PaintBox.Width div 2 - Round((sin(2*pi/3)/cos(2*pi/3)) * PaintBox.Height / 2), PaintBox.Height);

  
  p.X := PaintBox.Width div 2 + Round((sin(5*pi/6)/cos(5*pi/6)) * PaintBox.Height / 2);
  p.Y := 0;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(PaintBox.Width div 2 - Round((sin(5*pi/6)/cos(5*pi/6)) * PaintBox.Height / 2), PaintBox.Height);

  p.X := PaintBox.Width;
  p.Y := PaintBox.Height div 2;
  PaintBox.Canvas.PenPos := p;
  PaintBox.Canvas.LineTo(0, PaintBox.Height div 2);

  //draw origin
  PaintBox.Canvas.Ellipse(origX-3, origY-3, origX+3, origY+3);

  lst := ZylGPSReceiver.GetSatellites;
  for i := 0 to lst.Count - 1 do
  begin
    objSat := lst[i];
    x := Round((PaintBox.Width/2 - PaintBox.Width*objSat.Elevation/180) * sin(PI - objSat.Azimuth*PI/180)) + PaintBox.Width div 2;
    y := Round((PaintBox.Width/2 - PaintBox.Width*objSat.Elevation/180) * cos(PI - objSat.Azimuth*PI/180)) + PaintBox.Height div 2;
    if objSat.SignalToNoiseRatio > 0 then
      PaintBox.Canvas.Brush.Color := clGreen
    else
      PaintBox.Canvas.Brush.Color := clRed;
    PaintBox.Canvas.Ellipse(X-12, Y-12, X+12, Y+12);
    if objSat.PseudoRandomCode <= 9 then
      PaintBox.Canvas.TextOut(X-6, Y-6, IntToStr(objSat.PseudoRandomCode))
    else
      PaintBox.Canvas.TextOut(X-8, Y-8, IntToStr(objSat.PseudoRandomCode))    
  end;
end;

procedure TfrmMain.ZylGPSReceiverSatellitesReceive(Sender: TObject);
begin
  PaintBox.Repaint;
end;

procedure TfrmMain.btnUploadClick(Sender: TObject);
begin
  ZylGPSReceiver.UploadWaypoint('WP1',
    ZylGPSReceiver.DMSToDecimalDegrees(46, 45, 6.53, cpNorth),
    ZylGPSReceiver.DMSToDecimalDegrees(23, 33, 19.72, cpEast)
  );
  ZylGPSReceiver.UploadWaypoint('WP2',
    ZylGPSReceiver.DMSToDecimalDegrees(46, 46, 6.53, cpNorth),
    ZylGPSReceiver.DMSToDecimalDegrees(23, 34, 19.72, cpEast)
  );

  ZylGPSREceiver.UploadRoute('WP1, WP2');
end;

end.
