unit FMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ZylBurner, ComCtrls, ShellCtrls, FileCtrl, ExtCtrls,
  Buttons;

type
  TForm1 = class(TForm)
    ZylBurner: TZylBurner;
    btnBurn: TButton;
    btnErase: TButton;
    ListBox: TListBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    btnAddFile: TButton;
    btnRemove: TButton;
    btnAddDirectory: TButton;
    efDrive: TEdit;
    Label1: TLabel;
    gbMedia: TRadioGroup;
    chkFull: TCheckBox;
    btnEject: TButton;
    gbDisk: TRadioGroup;
    efImage: TEdit;
    btnBurnImg: TButton;
    btnBrowse: TBitBtn;
    OpenDialog: TOpenDialog;
    efNeroPath: TEdit;
    btnBrowse1: TBitBtn;
    Label2: TLabel;
    procedure btnBurnClick(Sender: TObject);
    procedure btnEraseClick(Sender: TObject);
    procedure btnAddFileClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnAddDirectoryClick(Sender: TObject);
    procedure btnEjectClick(Sender: TObject);
    procedure ZylBurnerError(Sender: TObject; ErrorCode: Integer);
    procedure ZylBurnerSuccess(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure btnBurnImgClick(Sender: TObject);
    procedure btnBrowse1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnBurnClick(Sender: TObject);
var
  i: Integer;
begin
  ZylBurner.NeroCmdLocation := Trim(efNeroPath.Text);
  if gbMedia.ItemIndex = 1 then
    ZylBurner.DVD := True
  else
    ZylBurner.DVD := False;

  ZylBurner.DiskType := TDiskType(gbDisk.ItemIndex);  

  ZylBurner.Files.Clear;
  for i := 0 to ListBox.Items.Count - 1 do
    ZylBurner.Files.Add(ListBox.Items[i]);

  if Trim(efDrive.Text) <> '' then
    ZylBurner.Burn(efDrive.Text[1])
  else
    MessageDlg('Please enter the drive letter.', mtError, [mbOK], 0);
end;

procedure TForm1.btnEraseClick(Sender: TObject);
begin
  ZylBurner.NeroCmdLocation := Trim(efNeroPath.Text);
  if Trim(efDrive.Text) <> '' then
    ZylBurner.Erase(efDrive.Text[1], chkFull.Checked)
  else
    MessageDlg('Please enter the drive letter.', mtError, [mbOK], 0);
end;

procedure TForm1.btnAddFileClick(Sender: TObject);
begin
  if FileListBox.FileName <> '' then
    ListBox.Items.Add(FileListBox.FileName);
end;

procedure TForm1.btnRemoveClick(Sender: TObject);
begin
  if ListBox.ItemIndex >= 0 then
    ListBox.Items.Delete(ListBox.ItemIndex);
end;

procedure TForm1.btnAddDirectoryClick(Sender: TObject);
begin
  if DirectoryListBox.Directory <> '' then
    ListBox.Items.Add(DirectoryListBox.Directory);
end;

procedure TForm1.btnEjectClick(Sender: TObject);
begin
  ZylBurner.NeroCmdLocation := Trim(efNeroPath.Text);
  if Trim(efDrive.Text) <> '' then
    ZylBurner.Eject(efDrive.Text[1])
  else
    MessageDlg('Please enter the drive letter.', mtError, [mbOK], 0);
end;

procedure TForm1.ZylBurnerError(Sender: TObject; ErrorCode: Integer);
begin
  ShowMessage('Error.');
end;

procedure TForm1.ZylBurnerSuccess(Sender: TObject);
begin
  ShowMessage('Success.');
end;

procedure TForm1.btnBrowseClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    efImage.Text := OpenDialog.FileName;
  end;
end;

procedure TForm1.btnBurnImgClick(Sender: TObject);
begin
  ZylBurner.NeroCmdLocation := Trim(efNeroPath.Text);
  if FileExists(Trim(efImage.Text)) then
  begin
    if Trim(efDrive.Text) <> '' then
      ZylBurner.BurnImage(Trim(efImage.Text), efDrive.Text[1])
    else
      MessageDlg('Please enter the drive letter.', mtError, [mbOK], 0);
  end
  else
  begin
    MessageDlg('File not found.', mtError, [mbOK], 0);
  end;
end;

procedure TForm1.btnBrowse1Click(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    efNeroPath.Text := OpenDialog.FileName;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  efNeroPath.Text := ZylBurner.NeroCmdLocation;
end;

end.
