{include file="header.tpl"}

{if $err.principal}<p class="err">Loan amount must be in the range from {$config.min_principal} to {$config.max_principal}.</p>{/if}
{if $err.interest_rate}<p class="err">Interest rate must be in the range from {$config.min_interest_rate} to {$config.max_interest_rate}.</p>{/if}
{if $err.start_year}<p class="err">Start year must be in the range from {$config.min_start_year} to {$config.max_start_year}.</p>{/if}
{if $err.start_month}<p class="err">Start month must be in the range from 1 to 12.</p>{/if}
{if $err.term}<p class="err">Loan term must be in the range from {$config.min_term} to {$config.max_term}.</p>{/if}

<form method="post">
<input type="hidden" name="param[action]" value="calculate">

<table cellpadding="0" cellspacing="0"><tr><td id="params" valign="top">
  <table cellpadding="3" cellspacing="0" width="100%">
    <tr><th colspan="2" align="center">Loan Information</th></tr>
    <tr><td align="right">Loan amount:</td><td><input type="text" name="param[principal]" value="{$param.principal|default:$config.principal|escape}" size="10"> {$config.currency_char}</td></tr>
    <tr><td align="right">Interest rate:</td><td><input type="text" name="param[interest_rate]" value="{$param.interest_rate|default:$config.interest_rate|escape}" size="3"> %</td></tr>
    <tr><td align="right">Loan term:</td><td><input type="text" name="param[term]" value="{$param.term|default:$config.term|escape}" size="3"> years</td></tr>
    <tr><td align="right">Start date:</td><td>{html_options options=$config.month_names selected=$param.start_month|default:$current_month name="param[start_month]"} {html_options values=$years output=$years selected=$param.start_year|default:$current_year name="param[start_year]"}</td></tr>
    <tr><td align="right">Show results by:</td><td>{html_options options=$config.amort_schedules selected=$param.amort_schedule|default:$config.amort_schedule name="param[amort_schedule]"}</td></tr>
    <tr><td colspan="2" align="center" id="calculate_btn"><input type="submit" value="Calculate"></td></tr>
  </table>
  <!-- DO NOT REMOVE/MODIFY THIS LINE. SEE THE LICENSE AGREEMENT. THANKS --><p id="powered_by">Powered by <a href="http://www.amortization-calc.com/" target="_blank">Amortization Schedule Calculator</a></p><!-- DO NOT REMOVE/MODIFY THIS LINE. SEE THE LICENSE AGREEMENT. THANKS -->
{if $summary}
</td><td width="50">
</td><td valign="top">
  <table cellspacing="0" cellpadding="0" width="100%" id="summary">
    <tr>
      <td colspan="3"><h2>Loan Summary</h2></td>
    </tr>
    <tr>
      <td><h3>{$summary.payment|escape}</h3> Monthly Principal & Interest</td>
      <td width="25"></td>
      <td><h3>{$summary.total|escape}</h3> Total of {$summary.periods|escape} Payments</td>
    </tr>
    <tr><td height="15"></td></tr>
    <tr>
      <td><h3>{$summary.interest|escape}</h3> Total Interest Paid</td>
      <td width="25"></td>
      <td><h3>{$summary.end_date|escape}</h3> Pay-off Date</td>
    </tr>
  </table>

  {if $yvals}
  <h2>Amortization Schedule</h2>
  <table cellspacing="2" cellpadding="3" id="schedule" width="100%">
    <tr>
    	<th>Year</th>
    	<th>Interest</th>
    	<th>Principal</th>
    	<th>Balance</th>
    </tr>
    {foreach item=yval from=$yvals}
    <tr>
    	<td align="center">{$yval.year}</td>
    	<td align="right">{$yval.interest}</td>
    	<td align="right">{$yval.principal}</td>
    	<td align="right">{$yval.balance}</td>
    </tr>
    {/foreach}
  </table>
  {/if}

  {if $mvals}
  <h2>Amortization Schedule</h2>
  <table cellspacing="2" cellpadding="3" id="schedule" width="100%">
    <tr>
    	<th>Month</th>
    	<th>Interest</th>
    	<th>Principal</th>
    	<th>Balance</th>
    </tr>
    {foreach item=mval from=$mvals}
    <tr>
    	<td align="center">{$mval.date}</td>
    	<td align="right">{$mval.interest}</td>
    	<td align="right">{$mval.principal}</td>
    	<td align="right">{$mval.balance}</td>
    </tr>
    {/foreach}
  </table>
  {/if}
{/if}
</td></tr></table>

</form>

{include file="footer.tpl"}
