CREATE TABLE `#__flippingbook_books` (
  `id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `alias` text NOT NULL,
  `description` text NOT NULL,
  `preview_image` varchar(255) NOT NULL,
  `background_image` varchar(255) NOT NULL,
  `flash_width` int(4) NOT NULL,
  `flash_height` int(4) NOT NULL,
  `book_width` int(4) NOT NULL,
  `book_height` int(4) NOT NULL,
  `page_background_color` varchar(10) NOT NULL,
  `rotation` varchar(4) NOT NULL,
  `flip_area` int(4) NOT NULL,
  `static_shadows_depth` int(3) NOT NULL,
  `dynamic_shadows_depth` int(3) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(6) NOT NULL,
  `background_color` varchar(10) NOT NULL,
  `always_opened` tinyint(1) NOT NULL,
  `first_page` int(4) NOT NULL,
  `scale_content` tinyint(1) NOT NULL,
  `show_navigation` tinyint(1) NOT NULL,
  `show_description` tinyint(1) NOT NULL,
  `show_book_title` tinyint(1) NOT NULL,
  `show_back_button` tinyint(1) NOT NULL,
  `slide_show` tinyint(1) NOT NULL,
  `slide_show_display_duration` int(8) NOT NULL,
  `slide_show_loop` tinyint(1) NOT NULL,
  `page_flip_delay` int(6) NOT NULL,
  `flip_corner_on_load` tinyint(1) NOT NULL,
  `open_book_in` int(4) NOT NULL,
  `new_window_height` int(4) NOT NULL,
  `new_window_width` int(4) NOT NULL,
  `zoom_image_size_autodetect` tinyint(1) NOT NULL default '0',
  `checked_out_time` int(11) NOT NULL default '0',
  `checked_out` int(11) NOT NULL,
  `emailIcon` tinyint(1) NOT NULL,
  `printIcon` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

INSERT INTO `#__flippingbook_books` VALUES (1, 'FlippingBook Joomla Component in action', 'flippingbook-joomla-component-in-action', 'It is recommended that you start getting familiar with the component from this sample showing basic component settings and capabilities. You can <a href="http://page-flip-tools.com/download/joomla_1.5_demo.zip">click here</a> to download the complete source code for this demo.', 'book_preview.png', 'sample_background.jpg', 540, 410, 480, 350, 'FFFFFF', '0', 75, 1, 2, 1, 3, 'FFFFFF', 0, 1, 0, 1, 1, 1, 1, 0, 2, 1, 5, 0, 1, 600, 640, 0, 0, 0, 1, 1);

CREATE TABLE `#__flippingbook_config` (
  `id` int(9) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `type` varchar(10) NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

INSERT INTO `#__flippingbook_config` VALUES (1, 'flipOnClick', '1', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (2, 'moveSpeed', '2', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (3, 'closeSpeed', '2', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (4, 'flipSound', 'images/flippingbook/newspaper.mp3', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (5, 'loadOnDemand', '1', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (6, 'cachePages', '1', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (7, 'cacheSize', '10', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (8, 'preloaderType', 'Progress Bar', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (9, 'book_list_title', 'My books', 'global');
INSERT INTO `#__flippingbook_config` VALUES (10, 'language', 'english.php', 'global');
INSERT INTO `#__flippingbook_config` VALUES (11, 'style', 'grayscale.css', 'global');
INSERT INTO `#__flippingbook_config` VALUES (12, 'columns', '2', 'global');
INSERT INTO `#__flippingbook_config` VALUES (13, 'allowPagesUnload', '0', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (14, 'flashCookie', '0', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (15, 'gotoSpeed', '3', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (16, 'showUnderlyingPages', '1', 'xml');
INSERT INTO `#__flippingbook_config` VALUES (17, 'emailIcon', '1', 'global');
INSERT INTO `#__flippingbook_config` VALUES (18, 'printIcon', '1', 'global');
INSERT INTO `#__flippingbook_config` VALUES (19, 'bookListStyle', 'blog', 'global');


CREATE TABLE `#__flippingbook_pages` (
  `id` int(11) NOT NULL auto_increment,
  `file` varchar(255) NOT NULL,
  `book_id` int(4) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '1',
  `link_url` text NOT NULL,
  `link_url_target` int(1) NOT NULL default '4',
  `link_window_height` int(4) NOT NULL default '480',
  `link_window_width` int(4) NOT NULL default '640',
  `zoom_url` text NOT NULL,
  `zoom_url_target` int(1) NOT NULL default '3',
  `zoom_window_height` int(4) NOT NULL default '600',
  `zoom_window_width` int(4) NOT NULL default '800',
  `checked_out_time` int(11) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

INSERT INTO `#__flippingbook_pages` VALUES (1, 'page_01.swf', 1, 1, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (2, 'page_02.swf', 1, 2, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (3, 'page_03.jpg', 1, 3, 1, 'http://page-flip-tools.com', 2, 480, 640, 'page_03_zoom.jpg', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (4, 'page_04.jpg', 1, 4, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (5, 'page_05.jpg', 1, 5, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (6, 'page_06.jpg', 1, 6, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (7, 'page_07.jpg', 1, 7, 1, '', 2, 600, 800, '', 4, 600, 800, 0, 0);
INSERT INTO `#__flippingbook_pages` VALUES (8, 'page_08.swf', 1, 8, 1, '', 2, 480, 640, '', 4, 600, 800, 0, 0);