//svg
class SVGException {
	static const SVG_WRONG_TYPE_ERR:Number=0;
	static const SVG_INVALID_VALUE_ERR:Number=1;
	static const SVG_MATRIX_NOT_INVERTABLE:Number=2;

	var code:Number;
}

interface SVGElement extends Element {
	var id:String;
	var xmlbase:String;
	const ownerSVGElement:SVGSVGElement;
	const viewportElement:SVGElement;
}

interface SVGAnimatedBoolean {
	var baseVal:Boolean;
	const animVal:Boolean;
}

interface SVGAnimatedString {
	var baseVal:String;
	const animVal:String;
}

interface SVGStringList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:String):String;
	throws(DOMException) function getItem(index:Number):String;
	throws(DOMException, SVGException) function insertItemBefore(newItem:String, index:Number):String;
	throws(DOMException, SVGException) function replaceItem(newItem:String, index:Number):String;
	throws(DOMException) function removeItem(index:Number):String;
	throws(DOMException, SVGException) function appendItem(newItem:String):String;
}

interface SVGAnimatedEnumeration {
	var baseVal:Number;
	const animVal:Number;
}

interface SVGAnimatedInteger {
	var baseVal:Number;
	const animVal:Number;
}

interface SVGNumber {
	var value:Number;
}

interface SVGAnimatedNumber {
	var baseVal:Number;
	const animVal:Number;
}

interface SVGNumberList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:SVGNumber):SVGNumber;
	throws(DOMException) function getItem(index:Number):SVGNumber;
	throws(DOMException, SVGException) function insertItemBefore(newItem:SVGNumber, index:Number):SVGNumber;
	throws(DOMException, SVGException) function replaceItem(newItem:SVGNumber, index:Number):SVGNumber;
	throws(DOMException) function removeItem(index:Number):SVGNumber;
	throws(DOMException, SVGException) function appendItem(newItem:SVGNumber):SVGNumber;
}

interface SVGAnimatedNumberList {
	const baseVal:SVGNumberList;
	const animVal:SVGNumberList;
}

interface SVGLength {
	static const SVG_LENGTHTYPE_UNKNOWN:Number=0;
	static const SVG_LENGTHTYPE_NUMBER:Number=1;
	static const SVG_LENGTHTYPE_PERCENTAGE:Number=2;
	static const SVG_LENGTHTYPE_EMS:Number=3;
	static const SVG_LENGTHTYPE_EXS:Number=4;
	static const SVG_LENGTHTYPE_PX:Number=5;
	static const SVG_LENGTHTYPE_CM:Number=6;
	static const SVG_LENGTHTYPE_MM:Number=7;
	static const SVG_LENGTHTYPE_IN:Number=8;
	static const SVG_LENGTHTYPE_PT:Number=9;
	static const SVG_LENGTHTYPE_PC:Number=10;
	const unitType:Number;
	var value:Number;
	var valueInSpecifiedUnits:Number;
	var valueAsString:String;
	function newValueSpecifiedUnits(unitType:Number, valueInSpecifiedUnits:Number):void;
	function convertToSpecifiedUnits(unitType:Number):void;
}

interface SVGAnimatedLength {
	const baseVal:SVGLength;
	const animVal:SVGLength;
}

interface SVGLengthList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:SVGLength):SVGLength;
	throws(DOMException) function getItem(index:Number):SVGLength;
	throws(DOMException, SVGException) function insertItemBefore(newItem:SVGLength, index:Number):SVGLength;
	throws(DOMException, SVGException) function replaceItem(newItem:SVGLength, index:Number):SVGLength;
	throws(DOMException) function removeItem(index:Number):SVGLength;
	throws(DOMException, SVGException) function appendItem(newItem:SVGLength):SVGLength;
}

interface SVGAnimatedLengthList {
	const baseVal:SVGLengthList;
	const animVal:SVGLengthList;
}

interface SVGAngle {
	static const SVG_ANGLETYPE_UNKNOWN:Number=0;
	static const SVG_ANGLETYPE_UNSPECIFIED:Number=1;
	static const SVG_ANGLETYPE_DEG:Number=2;
	static const SVG_ANGLETYPE_RAD:Number=3;
	static const SVG_ANGLETYPE_GRAD:Number=4;
	const unitType:Number;
	var value:Number;
	var valueInSpecifiedUnits:Number;
	var valueAsString:String;
	function newValueSpecifiedUnits(unitType:Number, valueInSpecifiedUnits:Number):void;
	function convertToSpecifiedUnits(unitType:Number):void;
}

interface SVGAnimatedAngle {
	const baseVal:SVGAngle;
	const animVal:SVGAngle;
}

interface SVGColor extends CSSValue {
	static const SVG_COLORTYPE_UNKNOWN:Number=0;
	static const SVG_COLORTYPE_RGBCOLOR:Number=1;
	static const SVG_COLORTYPE_RGBCOLOR_ICCCOLOR:Number=2;
	static const SVG_COLORTYPE_CURRENTCOLOR:Number=3;
	const colorType:Number;
	const rgbColor:RGBColor;
	const iccColor:SVGICCColor;
	throws(SVGException) function setRGBColor(rgbColor:String):void;
	throws(SVGException) function setRGBColorICCColor(rgbColor:String, iccColor:String):void;
	throws(SVGException) function setColor(colorType:Number, rgbColor:String, iccColor:String):void;
}

interface SVGICCColor {
	var colorProfile:String;
	const colors:SVGNumberList;
}

interface SVGRect {
	var x:Number;
	var y:Number;
	var width:Number;
	var height:Number;
}

interface SVGAnimatedRect {
	const baseVal:SVGRect;
	const animVal:SVGRect;
}

interface SVGUnitTypes {
	static const SVG_UNIT_TYPE_UNKNOWN:Number=0;
	static const SVG_UNIT_TYPE_USERSPACEONUSE:Number=1;
	static const SVG_UNIT_TYPE_OBJECTBOUNDINGBOX:Number=2;
}

interface SVGStylable {
	const className:SVGAnimatedString;
	const style:CSSStyleDeclaration;
	function getPresentationAttribute(name:String):CSSValue;
}

interface SVGLocatable {
	const nearestViewportElement:SVGElement;
	const farthestViewportElement:SVGElement;
	function getBBox():SVGRect;
	function getCTM():SVGMatrix;
	function getScreenCTM():SVGMatrix;
	throws(SVGException) function getTransformToElement(element:SVGElement):SVGMatrix;
}

interface SVGTransformable extends SVGLocatable {
	const transform:SVGAnimatedTransformList;
}

interface SVGTests {
	const requiredFeatures:SVGStringList;
	const requiredExtensions:SVGStringList;
	const systemLanguage:SVGStringList;
	function hasExtension(extension:String):Boolean;
}

interface SVGLangSpace {
	var xmllang:String;
	var xmlspace:String;
}

interface SVGExternalResourcesRequired {
	const externalResourcesRequired:SVGAnimatedBoolean;
}

interface SVGFitToViewBox {
	const viewBox:SVGAnimatedRect;
	const preserveAspectRatio:SVGAnimatedPreserveAspectRatio;
}

interface SVGZoomAndPan {
	static const SVG_ZOOMANDPAN_UNKNOWN:Number=0;
	static const SVG_ZOOMANDPAN_DISABLE:Number=1;
	static const SVG_ZOOMANDPAN_MAGNIFY:Number=2;
	var zoomAndPan:Number;
}

interface SVGViewSpec extends SVGZoomAndPan, SVGFitToViewBox {
	const transform:SVGTransformList;
	const viewTarget:SVGElement;
	const viewBoxString:String;
	const preserveAspectRatioString:String;
	const transformString:String;
	const viewTargetString:String;
}

interface SVGURIReference {
	const href:SVGAnimatedString;
}

interface SVGCSSRule extends CSSRule {
	static const COLOR_PROFILE_RULE:Number=7;
}

interface SVGRenderingIntent {
	static const RENDERING_INTENT_UNKNOWN:Number=0;
	static const RENDERING_INTENT_AUTO:Number=1;
	static const RENDERING_INTENT_PERCEPTUAL:Number=2;
	static const RENDERING_INTENT_RELATIVE_COLORIMETRIC:Number=3;
	static const RENDERING_INTENT_SATURATION:Number=4;
	static const RENDERING_INTENT_ABSOLUTE_COLORIMETRIC:Number=5;
}

interface SVGDocument extends Document, DocumentEvent {
	const title:String;
	const referrer:String;
	const domain:String;
	const URL:String;
	const rootElement:SVGSVGElement;
}

interface SVGSVGElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGLocatable, SVGFitToViewBox, SVGZoomAndPan, EventTarget, DocumentEvent, ViewCSS, DocumentCSS {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	var contentScriptType:String;
	var contentStyleType:String;
	const viewport:SVGRect;
	const pixelUnitToMillimeterX:Number;
	const pixelUnitToMillimeterY:Number;
	const screenPixelToMillimeterX:Number;
	const screenPixelToMillimeterY:Number;
	var useCurrentView:Boolean;
	const currentView:SVGViewSpec;
	var currentScale:Number;
	const currentTranslate:SVGPoint;
	function suspendRedraw(max_wait_milliseconds:Number):Number;
	throws(DOMException) function unsuspendRedraw(suspend_handle_id:Number):void;
	function unsuspendRedrawAll():void;
	function forceRedraw():void;
	function pauseAnimations():void;
	function unpauseAnimations():void;
	function animationsPaused():Boolean;
	function getCurrentTime():Number;
	function setCurrentTime(seconds:Number):void;
	function getIntersectionList(rect:SVGRect, referenceElement:SVGElement):NodeList;
	function getEnclosureList(rect:SVGRect, referenceElement:SVGElement):NodeList;
	function checkIntersection(element:SVGElement, rect:SVGRect):Boolean;
	function checkEnclosure(element:SVGElement, rect:SVGRect):Boolean;
	function deselectAll():void;
	function createSVGNumber():SVGNumber;
	function createSVGLength():SVGLength;
	function createSVGAngle():SVGAngle;
	function createSVGPoint():SVGPoint;
	function createSVGMatrix():SVGMatrix;
	function createSVGRect():SVGRect;
	function createSVGTransform():SVGTransform;
	function createSVGTransformFromMatrix(matrix:SVGMatrix):SVGTransform;
	function getElementById(elementId:String):Element;
}

interface SVGGElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
}

interface SVGDefsElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
}

interface SVGDescElement extends SVGElement, SVGLangSpace, SVGStylable {
}

interface SVGTitleElement extends SVGElement, SVGLangSpace, SVGStylable {
}

interface SVGSymbolElement extends SVGElement, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGFitToViewBox, EventTarget {
}

interface SVGUseElement extends SVGElement, SVGURIReference, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	const instanceRoot:SVGElementInstance;
	const animatedInstanceRoot:SVGElementInstance;
}

interface SVGElementInstance extends EventTarget {
	const correspondingElement:SVGElement;
	const correspondingUseElement:SVGUseElement;
	const parentNode:SVGElementInstance;
	const childNodes:SVGElementInstanceList;
	const firstChild:SVGElementInstance;
	const lastChild:SVGElementInstance;
	const previousSibling:SVGElementInstance;
	const nextSibling:SVGElementInstance;
}

interface SVGElementInstanceList {
	const length:Number;
	function item(index:Number):SVGElementInstance;
}

interface SVGImageElement extends SVGElement, SVGURIReference, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	const preserveAspectRatio:SVGAnimatedPreserveAspectRatio;
}

interface SVGSwitchElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
}

interface GetSVGDocument {
	throws(DOMException) function getSVGDocument():SVGDocument;
}

interface SVGStyleElement extends SVGElement {
	var xmlspace:String;
	var type:String;
	var media:String;
	var title:String;
}

interface SVGPoint {
	var x:Number;
	var y:Number;
	function matrixTransform(matrix:SVGMatrix):SVGPoint;
}

interface SVGPointList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:SVGPoint):SVGPoint;
	throws(DOMException) function getItem(index:Number):SVGPoint;
	throws(DOMException, SVGException) function insertItemBefore(newItem:SVGPoint, index:Number):SVGPoint;
	throws(DOMException, SVGException) function replaceItem(newItem:SVGPoint, index:Number):SVGPoint;
	throws(DOMException) function removeItem(index:Number):SVGPoint;
	throws(DOMException, SVGException) function appendItem(newItem:SVGPoint):SVGPoint;
}

interface SVGMatrix {
	var a:Number;
	var b:Number;
	var c:Number;
	var d:Number;
	var e:Number;
	var f:Number;
	function multiply(secondMatrix:SVGMatrix):SVGMatrix;
	throws(SVGException) function inverse():SVGMatrix;
	function translate(x:Number, y:Number):SVGMatrix;
	function scale(scaleFactor:Number):SVGMatrix;
	function scaleNonUniform(scaleFactorX:Number, scaleFactorY:Number):SVGMatrix;
	function rotate(angle:Number):SVGMatrix;
	throws(SVGException) function rotateFromVector(x:Number, y:Number):SVGMatrix;
	function flipX():SVGMatrix;
	function flipY():SVGMatrix;
	function skewX(angle:Number):SVGMatrix;
	function skewY(angle:Number):SVGMatrix;
}

interface SVGTransform {
	static const SVG_TRANSFORM_UNKNOWN:Number=0;
	static const SVG_TRANSFORM_MATRIX:Number=1;
	static const SVG_TRANSFORM_TRANSLATE:Number=2;
	static const SVG_TRANSFORM_SCALE:Number=3;
	static const SVG_TRANSFORM_ROTATE:Number=4;
	static const SVG_TRANSFORM_SKEWX:Number=5;
	static const SVG_TRANSFORM_SKEWY:Number=6;
	const type:Number;
	const matrix:SVGMatrix;
	const angle:Number;
	function setMatrix(matrix:SVGMatrix):void;
	function setTranslate(tx:Number, ty:Number):void;
	function setScale(sx:Number, sy:Number):void;
	function setRotate(angle:Number, cx:Number, cy:Number):void;
	function setSkewX(angle:Number):void;
	function setSkewY(angle:Number):void;
}

interface SVGTransformList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:SVGTransform):SVGTransform;
	throws(DOMException) function getItem(index:Number):SVGTransform;
	throws(DOMException, SVGException) function insertItemBefore(newItem:SVGTransform, index:Number):SVGTransform;
	throws(DOMException, SVGException) function replaceItem(newItem:SVGTransform, index:Number):SVGTransform;
	throws(DOMException) function removeItem(index:Number):SVGTransform;
	throws(DOMException, SVGException) function appendItem(newItem:SVGTransform):SVGTransform;
	function createSVGTransformFromMatrix(matrix:SVGMatrix):SVGTransform;
	function consolidate():SVGTransform;
}

interface SVGAnimatedTransformList {
	const baseVal:SVGTransformList;
	const animVal:SVGTransformList;
}

interface SVGPreserveAspectRatio {
	static const SVG_PRESERVEASPECTRATIO_UNKNOWN:Number=0;
	static const SVG_PRESERVEASPECTRATIO_NONE:Number=1;
	static const SVG_PRESERVEASPECTRATIO_XMINYMIN:Number=2;
	static const SVG_PRESERVEASPECTRATIO_XMIDYMIN:Number=3;
	static const SVG_PRESERVEASPECTRATIO_XMAXYMIN:Number=4;
	static const SVG_PRESERVEASPECTRATIO_XMINYMID:Number=5;
	static const SVG_PRESERVEASPECTRATIO_XMIDYMID:Number=6;
	static const SVG_PRESERVEASPECTRATIO_XMAXYMID:Number=7;
	static const SVG_PRESERVEASPECTRATIO_XMINYMAX:Number=8;
	static const SVG_PRESERVEASPECTRATIO_XMIDYMAX:Number=9;
	static const SVG_PRESERVEASPECTRATIO_XMAXYMAX:Number=10;
	static const SVG_MEETORSLICE_UNKNOWN:Number=0;
	static const SVG_MEETORSLICE_MEET:Number=1;
	static const SVG_MEETORSLICE_SLICE:Number=2;
	var align:Number;
	var meetOrSlice:Number;
}

interface SVGAnimatedPreserveAspectRatio {
	const baseVal:SVGPreserveAspectRatio;
	const animVal:SVGPreserveAspectRatio;
}

interface SVGPathSeg {
	static const PATHSEG_UNKNOWN:Number=0;
	static const PATHSEG_CLOSEPATH:Number=1;
	static const PATHSEG_MOVETO_ABS:Number=2;
	static const PATHSEG_MOVETO_REL:Number=3;
	static const PATHSEG_LINETO_ABS:Number=4;
	static const PATHSEG_LINETO_REL:Number=5;
	static const PATHSEG_CURVETO_CUBIC_ABS:Number=6;
	static const PATHSEG_CURVETO_CUBIC_REL:Number=7;
	static const PATHSEG_CURVETO_QUADRATIC_ABS:Number=8;
	static const PATHSEG_CURVETO_QUADRATIC_REL:Number=9;
	static const PATHSEG_ARC_ABS:Number=10;
	static const PATHSEG_ARC_REL:Number=11;
	static const PATHSEG_LINETO_HORIZONTAL_ABS:Number=12;
	static const PATHSEG_LINETO_HORIZONTAL_REL:Number=13;
	static const PATHSEG_LINETO_VERTICAL_ABS:Number=14;
	static const PATHSEG_LINETO_VERTICAL_REL:Number=15;
	static const PATHSEG_CURVETO_CUBIC_SMOOTH_ABS:Number=16;
	static const PATHSEG_CURVETO_CUBIC_SMOOTH_REL:Number=17;
	static const PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS:Number=18;
	static const PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL:Number=19;
	const pathSegType:Number;
	const pathSegTypeAsLetter:String;
}

interface SVGPathSegClosePath extends SVGPathSeg {
}

interface SVGPathSegMovetoAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegMovetoRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegLinetoAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegLinetoRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegCurvetoCubicAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x1:Number;
	var y1:Number;
	var x2:Number;
	var y2:Number;
}

interface SVGPathSegCurvetoCubicRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x1:Number;
	var y1:Number;
	var x2:Number;
	var y2:Number;
}

interface SVGPathSegCurvetoQuadraticAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x1:Number;
	var y1:Number;
}

interface SVGPathSegCurvetoQuadraticRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x1:Number;
	var y1:Number;
}

interface SVGPathSegArcAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var r1:Number;
	var r2:Number;
	var angle:Number;
	var largeArcFlag:Boolean;
	var sweepFlag:Boolean;
}

interface SVGPathSegArcRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var r1:Number;
	var r2:Number;
	var angle:Number;
	var largeArcFlag:Boolean;
	var sweepFlag:Boolean;
}

interface SVGPathSegLinetoHorizontalAbs extends SVGPathSeg {
	var x:Number;
}

interface SVGPathSegLinetoHorizontalRel extends SVGPathSeg {
	var x:Number;
}

interface SVGPathSegLinetoVerticalAbs extends SVGPathSeg {
	var y:Number;
}

interface SVGPathSegLinetoVerticalRel extends SVGPathSeg {
	var y:Number;
}

interface SVGPathSegCurvetoCubicSmoothAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x2:Number;
	var y2:Number;
}

interface SVGPathSegCurvetoCubicSmoothRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
	var x2:Number;
	var y2:Number;
}

interface SVGPathSegCurvetoQuadraticSmoothAbs extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegCurvetoQuadraticSmoothRel extends SVGPathSeg {
	var x:Number;
	var y:Number;
}

interface SVGPathSegList {
	const numberOfItems:Number;
	throws(DOMException) function clear():void;
	throws(DOMException, SVGException) function initialize(newItem:SVGPathSeg):SVGPathSeg;
	throws(DOMException) function getItem(index:Number):SVGPathSeg;
	throws(DOMException, SVGException) function insertItemBefore(newItem:SVGPathSeg, index:Number):SVGPathSeg;
	throws(DOMException, SVGException) function replaceItem(newItem:SVGPathSeg, index:Number):SVGPathSeg;
	throws(DOMException) function removeItem(index:Number):SVGPathSeg;
	throws(DOMException, SVGException) function appendItem(newItem:SVGPathSeg):SVGPathSeg;
}

interface SVGAnimatedPathData {
	const pathSegList:SVGPathSegList;
	const normalizedPathSegList:SVGPathSegList;
	const animatedPathSegList:SVGPathSegList;
	const animatedNormalizedPathSegList:SVGPathSegList;
}

interface SVGPathElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget, SVGAnimatedPathData {
	const pathLength:SVGAnimatedNumber;
	function getTotalLength():Number;
	function getPointAtLength(distance:Number):SVGPoint;
	function getPathSegAtLength(distance:Number):Number;
	function createSVGPathSegClosePath():SVGPathSegClosePath;
	function createSVGPathSegMovetoAbs(x:Number, y:Number):SVGPathSegMovetoAbs;
	function createSVGPathSegMovetoRel(x:Number, y:Number):SVGPathSegMovetoRel;
	function createSVGPathSegLinetoAbs(x:Number, y:Number):SVGPathSegLinetoAbs;
	function createSVGPathSegLinetoRel(x:Number, y:Number):SVGPathSegLinetoRel;
	function createSVGPathSegCurvetoCubicAbs(x:Number, y:Number, x1:Number, y1:Number, x2:Number, y2:Number):SVGPathSegCurvetoCubicAbs;
	function createSVGPathSegCurvetoCubicRel(x:Number, y:Number, x1:Number, y1:Number, x2:Number, y2:Number):SVGPathSegCurvetoCubicRel;
	function createSVGPathSegCurvetoQuadraticAbs(x:Number, y:Number, x1:Number, y1:Number):SVGPathSegCurvetoQuadraticAbs;
	function createSVGPathSegCurvetoQuadraticRel(x:Number, y:Number, x1:Number, y1:Number):SVGPathSegCurvetoQuadraticRel;
	function createSVGPathSegArcAbs(x:Number, y:Number, r1:Number, r2:Number, angle:Number, largeArcFlag:Boolean, sweepFlag:Boolean):SVGPathSegArcAbs;
	function createSVGPathSegArcRel(x:Number, y:Number, r1:Number, r2:Number, angle:Number, largeArcFlag:Boolean, sweepFlag:Boolean):SVGPathSegArcRel;
	function createSVGPathSegLinetoHorizontalAbs(x:Number):SVGPathSegLinetoHorizontalAbs;
	function createSVGPathSegLinetoHorizontalRel(x:Number):SVGPathSegLinetoHorizontalRel;
	function createSVGPathSegLinetoVerticalAbs(y:Number):SVGPathSegLinetoVerticalAbs;
	function createSVGPathSegLinetoVerticalRel(y:Number):SVGPathSegLinetoVerticalRel;
	function createSVGPathSegCurvetoCubicSmoothAbs(x:Number, y:Number, x2:Number, y2:Number):SVGPathSegCurvetoCubicSmoothAbs;
	function createSVGPathSegCurvetoCubicSmoothRel(x:Number, y:Number, x2:Number, y2:Number):SVGPathSegCurvetoCubicSmoothRel;
	function createSVGPathSegCurvetoQuadraticSmoothAbs(x:Number, y:Number):SVGPathSegCurvetoQuadraticSmoothAbs;
	function createSVGPathSegCurvetoQuadraticSmoothRel(x:Number, y:Number):SVGPathSegCurvetoQuadraticSmoothRel;
}

interface SVGRectElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	const rx:SVGAnimatedLength;
	const ry:SVGAnimatedLength;
}

interface SVGCircleElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const cx:SVGAnimatedLength;
	const cy:SVGAnimatedLength;
	const r:SVGAnimatedLength;
}

interface SVGEllipseElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const cx:SVGAnimatedLength;
	const cy:SVGAnimatedLength;
	const rx:SVGAnimatedLength;
	const ry:SVGAnimatedLength;
}

interface SVGLineElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const x1:SVGAnimatedLength;
	const y1:SVGAnimatedLength;
	const x2:SVGAnimatedLength;
	const y2:SVGAnimatedLength;
}

interface SVGAnimatedPoints {
	const points:SVGPointList;
	const animatedPoints:SVGPointList;
}

interface SVGPolylineElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget, SVGAnimatedPoints {
}

interface SVGPolygonElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget, SVGAnimatedPoints {
}

interface SVGTextContentElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, EventTarget {
	static const LENGTHADJUST_UNKNOWN:Number=0;
	static const LENGTHADJUST_SPACING:Number=1;
	static const LENGTHADJUST_SPACINGANDGLYPHS:Number=2;
	const textLength:SVGAnimatedLength;
	const lengthAdjust:SVGAnimatedEnumeration;
	function getNumberOfChars():Number;
	function getComputedTextLength():Number;
	throws(DOMException) function getSubStringLength(charnum:Number, nchars:Number):Number;
	throws(DOMException) function getStartPositionOfChar(charnum:Number):SVGPoint;
	throws(DOMException) function getEndPositionOfChar(charnum:Number):SVGPoint;
	throws(DOMException) function getExtentOfChar(charnum:Number):SVGRect;
	throws(DOMException) function getRotationOfChar(charnum:Number):Number;
	function getCharNumAtPosition(point:SVGPoint):Number;
	throws(DOMException) function selectSubString(charnum:Number, nchars:Number):void;
}

interface SVGTextPositioningElement extends SVGTextContentElement {
	const x:SVGAnimatedLengthList;
	const y:SVGAnimatedLengthList;
	const dx:SVGAnimatedLengthList;
	const dy:SVGAnimatedLengthList;
	const rotate:SVGAnimatedNumberList;
}

interface SVGTextElement extends SVGTextPositioningElement, SVGTransformable {
}

interface SVGTSpanElement extends SVGTextPositioningElement {
}

interface SVGTRefElement extends SVGTextPositioningElement, SVGURIReference {
}

interface SVGTextPathElement extends SVGTextContentElement, SVGURIReference {
	static const TEXTPATH_METHODTYPE_UNKNOWN:Number=0;
	static const TEXTPATH_METHODTYPE_ALIGN:Number=1;
	static const TEXTPATH_METHODTYPE_STRETCH:Number=2;
	static const TEXTPATH_SPACINGTYPE_UNKNOWN:Number=0;
	static const TEXTPATH_SPACINGTYPE_AUTO:Number=1;
	static const TEXTPATH_SPACINGTYPE_EXACT:Number=2;
	const startOffset:SVGAnimatedLength;
	const method:SVGAnimatedEnumeration;
	const spacing:SVGAnimatedEnumeration;
}

interface SVGAltGlyphElement extends SVGTextPositioningElement, SVGURIReference {
	var glyphRef:String;
	var format:String;
}

interface SVGAltGlyphDefElement extends SVGElement {
}

interface SVGAltGlyphItemElement extends SVGElement {
}

interface SVGGlyphRefElement extends SVGElement, SVGURIReference, SVGStylable {
	var glyphRef:String;
	var format:String;
	var x:Number;
	var y:Number;
	var dx:Number;
	var dy:Number;
}

interface SVGPaint extends SVGColor {
	static const SVG_PAINTTYPE_UNKNOWN:Number=0;
	static const SVG_PAINTTYPE_RGBCOLOR:Number=1;
	static const SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR:Number=2;
	static const SVG_PAINTTYPE_NONE:Number=101;
	static const SVG_PAINTTYPE_CURRENTCOLOR:Number=102;
	static const SVG_PAINTTYPE_URI_NONE:Number=103;
	static const SVG_PAINTTYPE_URI_CURRENTCOLOR:Number=104;
	static const SVG_PAINTTYPE_URI_RGBCOLOR:Number=105;
	static const SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR:Number=106;
	static const SVG_PAINTTYPE_URI:Number=107;
	const paintType:Number;
	const uri:String;
	function setUri(uri:String):void;
	throws(SVGException) function setPaint(paintType:Number, uri:String, rgbColor:String, iccColor:String):void;
}

interface SVGMarkerElement extends SVGElement, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGFitToViewBox {
	static const SVG_MARKERUNITS_UNKNOWN:Number=0;
	static const SVG_MARKERUNITS_USERSPACEONUSE:Number=1;
	static const SVG_MARKERUNITS_STROKEWIDTH:Number=2;
	static const SVG_MARKER_ORIENT_UNKNOWN:Number=0;
	static const SVG_MARKER_ORIENT_AUTO:Number=1;
	static const SVG_MARKER_ORIENT_ANGLE:Number=2;
	const refX:SVGAnimatedLength;
	const refY:SVGAnimatedLength;
	const markerUnits:SVGAnimatedEnumeration;
	const markerWidth:SVGAnimatedLength;
	const markerHeight:SVGAnimatedLength;
	const orientType:SVGAnimatedEnumeration;
	const orientAngle:SVGAnimatedAngle;
	function setOrientToAuto():void;
	function setOrientToAngle(angle:SVGAngle):void;
}

interface SVGColorProfileElement extends SVGElement, SVGURIReference, SVGRenderingIntent {
	var local:String;
	var name:String;
	var renderingIntent:Number;
}

interface SVGColorProfileRule extends SVGCSSRule, SVGRenderingIntent {
	var src:String;
	var name:String;
	var renderingIntent:Number;
}

interface SVGGradientElement extends SVGElement, SVGURIReference, SVGExternalResourcesRequired, SVGStylable, SVGUnitTypes {
	static const SVG_SPREADMETHOD_UNKNOWN:Number=0;
	static const SVG_SPREADMETHOD_PAD:Number=1;
	static const SVG_SPREADMETHOD_REFLECT:Number=2;
	static const SVG_SPREADMETHOD_REPEAT:Number=3;
	const gradientUnits:SVGAnimatedEnumeration;
	const gradientTransform:SVGAnimatedTransformList;
	const spreadMethod:SVGAnimatedEnumeration;
}

interface SVGLinearGradientElement extends SVGGradientElement {
	const x1:SVGAnimatedLength;
	const y1:SVGAnimatedLength;
	const x2:SVGAnimatedLength;
	const y2:SVGAnimatedLength;
}

interface SVGRadialGradientElement extends SVGGradientElement {
	const cx:SVGAnimatedLength;
	const cy:SVGAnimatedLength;
	const r:SVGAnimatedLength;
	const fx:SVGAnimatedLength;
	const fy:SVGAnimatedLength;
}

interface SVGStopElement extends SVGElement, SVGStylable {
	const offset:SVGAnimatedNumber;
}

interface SVGPatternElement extends SVGElement, SVGURIReference, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGFitToViewBox, SVGUnitTypes {
	const patternUnits:SVGAnimatedEnumeration;
	const patternContentUnits:SVGAnimatedEnumeration;
	const patternTransform:SVGAnimatedTransformList;
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
}

interface SVGClipPathElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, SVGUnitTypes {
	const clipPathUnits:SVGAnimatedEnumeration;
}

interface SVGMaskElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGUnitTypes {
	const maskUnits:SVGAnimatedEnumeration;
	const maskContentUnits:SVGAnimatedEnumeration;
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
}

interface SVGFilterElement extends SVGElement, SVGURIReference, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGUnitTypes {
	const filterUnits:SVGAnimatedEnumeration;
	const primitiveUnits:SVGAnimatedEnumeration;
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	const filterResX:SVGAnimatedInteger;
	const filterResY:SVGAnimatedInteger;
	function setFilterRes(filterResX:Number, filterResY:Number):void;
}

interface SVGFilterPrimitiveStandardAttributes extends SVGStylable {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
	const result:SVGAnimatedString;
}

interface SVGFEBlendElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_FEBLEND_MODE_UNKNOWN:Number=0;
	static const SVG_FEBLEND_MODE_NORMAL:Number=1;
	static const SVG_FEBLEND_MODE_MULTIPLY:Number=2;
	static const SVG_FEBLEND_MODE_SCREEN:Number=3;
	static const SVG_FEBLEND_MODE_DARKEN:Number=4;
	static const SVG_FEBLEND_MODE_LIGHTEN:Number=5;
	const in1:SVGAnimatedString;
	const in2:SVGAnimatedString;
	const mode:SVGAnimatedEnumeration;
}

interface SVGFEColorMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_FECOLORMATRIX_TYPE_UNKNOWN:Number=0;
	static const SVG_FECOLORMATRIX_TYPE_MATRIX:Number=1;
	static const SVG_FECOLORMATRIX_TYPE_SATURATE:Number=2;
	static const SVG_FECOLORMATRIX_TYPE_HUEROTATE:Number=3;
	static const SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA:Number=4;
	const in1:SVGAnimatedString;
	const type:SVGAnimatedEnumeration;
	const values:SVGAnimatedNumberList;
}

interface SVGFEComponentTransferElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
}

interface SVGComponentTransferFunctionElement extends SVGElement {
	static const SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN:Number=0;
	static const SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY:Number=1;
	static const SVG_FECOMPONENTTRANSFER_TYPE_TABLE:Number=2;
	static const SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE:Number=3;
	static const SVG_FECOMPONENTTRANSFER_TYPE_LINEAR:Number=4;
	static const SVG_FECOMPONENTTRANSFER_TYPE_GAMMA:Number=5;
	const type:SVGAnimatedEnumeration;
	const tableValues:SVGAnimatedNumberList;
	const slope:SVGAnimatedNumber;
	const intercept:SVGAnimatedNumber;
	const amplitude:SVGAnimatedNumber;
	const exponent:SVGAnimatedNumber;
	const offset:SVGAnimatedNumber;
}

interface SVGFEFuncRElement extends SVGComponentTransferFunctionElement {
}

interface SVGFEFuncGElement extends SVGComponentTransferFunctionElement {
}

interface SVGFEFuncBElement extends SVGComponentTransferFunctionElement {
}

interface SVGFEFuncAElement extends SVGComponentTransferFunctionElement {
}

interface SVGFECompositeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_FECOMPOSITE_OPERATOR_UNKNOWN:Number=0;
	static const SVG_FECOMPOSITE_OPERATOR_OVER:Number=1;
	static const SVG_FECOMPOSITE_OPERATOR_IN:Number=2;
	static const SVG_FECOMPOSITE_OPERATOR_OUT:Number=3;
	static const SVG_FECOMPOSITE_OPERATOR_ATOP:Number=4;
	static const SVG_FECOMPOSITE_OPERATOR_XOR:Number=5;
	static const SVG_FECOMPOSITE_OPERATOR_ARITHMETIC:Number=6;
	const in1:SVGAnimatedString;
	const in2:SVGAnimatedString;
	const operator:SVGAnimatedEnumeration;
	const k1:SVGAnimatedNumber;
	const k2:SVGAnimatedNumber;
	const k3:SVGAnimatedNumber;
	const k4:SVGAnimatedNumber;
}

interface SVGFEConvolveMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_EDGEMODE_UNKNOWN:Number=0;
	static const SVG_EDGEMODE_DUPLICATE:Number=1;
	static const SVG_EDGEMODE_WRAP:Number=2;
	static const SVG_EDGEMODE_NONE:Number=3;
	const orderX:SVGAnimatedInteger;
	const orderY:SVGAnimatedInteger;
	const kernelMatrix:SVGAnimatedNumberList;
	const divisor:SVGAnimatedNumber;
	const bias:SVGAnimatedNumber;
	const targetX:SVGAnimatedInteger;
	const targetY:SVGAnimatedInteger;
	const edgeMode:SVGAnimatedEnumeration;
	const kernelUnitLengthX:SVGAnimatedNumber;
	const kernelUnitLengthY:SVGAnimatedNumber;
	const preserveAlpha:SVGAnimatedBoolean;
}

interface SVGFEDiffuseLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
	const surfaceScale:SVGAnimatedNumber;
	const diffuseConstant:SVGAnimatedNumber;
	const kernelUnitLengthX:SVGAnimatedNumber;
	const kernelUnitLengthY:SVGAnimatedNumber;
}

interface SVGFEDistantLightElement extends SVGElement {
	const azimuth:SVGAnimatedNumber;
	const elevation:SVGAnimatedNumber;
}

interface SVGFEPointLightElement extends SVGElement {
	const x:SVGAnimatedNumber;
	const y:SVGAnimatedNumber;
	const z:SVGAnimatedNumber;
}

interface SVGFESpotLightElement extends SVGElement {
	const x:SVGAnimatedNumber;
	const y:SVGAnimatedNumber;
	const z:SVGAnimatedNumber;
	const pointsAtX:SVGAnimatedNumber;
	const pointsAtY:SVGAnimatedNumber;
	const pointsAtZ:SVGAnimatedNumber;
	const specularExponent:SVGAnimatedNumber;
	const limitingConeAngle:SVGAnimatedNumber;
}

interface SVGFEDisplacementMapElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_CHANNEL_UNKNOWN:Number=0;
	static const SVG_CHANNEL_R:Number=1;
	static const SVG_CHANNEL_G:Number=2;
	static const SVG_CHANNEL_B:Number=3;
	static const SVG_CHANNEL_A:Number=4;
	const in1:SVGAnimatedString;
	const in2:SVGAnimatedString;
	const scale:SVGAnimatedNumber;
	const xChannelSelector:SVGAnimatedEnumeration;
	const yChannelSelector:SVGAnimatedEnumeration;
}

interface SVGFEFloodElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
}

interface SVGFEGaussianBlurElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
	const stdDeviationX:SVGAnimatedNumber;
	const stdDeviationY:SVGAnimatedNumber;
	function setStdDeviation(stdDeviationX:Number, stdDeviationY:Number):void;
}

interface SVGFEImageElement extends SVGElement, SVGURIReference, SVGLangSpace, SVGExternalResourcesRequired, SVGFilterPrimitiveStandardAttributes {
	const preserveAspectRatio:SVGAnimatedPreserveAspectRatio;
}

interface SVGFEMergeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
}

interface SVGFEMergeNodeElement extends SVGElement {
	const in1:SVGAnimatedString;
}

interface SVGFEMorphologyElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_MORPHOLOGY_OPERATOR_UNKNOWN:Number=0;
	static const SVG_MORPHOLOGY_OPERATOR_ERODE:Number=1;
	static const SVG_MORPHOLOGY_OPERATOR_DILATE:Number=2;
	const in1:SVGAnimatedString;
	const operator:SVGAnimatedEnumeration;
	const radiusX:SVGAnimatedNumber;
	const radiusY:SVGAnimatedNumber;
}

interface SVGFEOffsetElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
	const dx:SVGAnimatedNumber;
	const dy:SVGAnimatedNumber;
}

interface SVGFESpecularLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
	const surfaceScale:SVGAnimatedNumber;
	const specularConstant:SVGAnimatedNumber;
	const specularExponent:SVGAnimatedNumber;
}

interface SVGFETileElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	const in1:SVGAnimatedString;
}

interface SVGFETurbulenceElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {
	static const SVG_TURBULENCE_TYPE_UNKNOWN:Number=0;
	static const SVG_TURBULENCE_TYPE_FRACTALNOISE:Number=1;
	static const SVG_TURBULENCE_TYPE_TURBULENCE:Number=2;
	static const SVG_STITCHTYPE_UNKNOWN:Number=0;
	static const SVG_STITCHTYPE_STITCH:Number=1;
	static const SVG_STITCHTYPE_NOSTITCH:Number=2;
	const baseFrequencyX:SVGAnimatedNumber;
	const baseFrequencyY:SVGAnimatedNumber;
	const numOctaves:SVGAnimatedInteger;
	const seed:SVGAnimatedNumber;
	const stitchTiles:SVGAnimatedEnumeration;
	const type:SVGAnimatedEnumeration;
}

interface SVGCursorElement extends SVGElement, SVGURIReference, SVGTests, SVGExternalResourcesRequired {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
}

interface SVGAElement extends SVGElement, SVGURIReference, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const target:SVGAnimatedString;
}

interface SVGViewElement extends SVGElement, SVGExternalResourcesRequired, SVGFitToViewBox, SVGZoomAndPan {
	const viewTarget:SVGStringList;
}

interface SVGScriptElement extends SVGElement, SVGURIReference, SVGExternalResourcesRequired {
	var type:String;
}

interface SVGEvent extends Event {
}

interface SVGZoomEvent extends UIEvent {
	const zoomRectScreen:SVGRect;
	const previousScale:Number;
	const previousTranslate:SVGPoint;
	const newScale:Number;
	const newTranslate:SVGPoint;
}

interface SVGAnimationElement extends SVGElement, SVGTests, SVGExternalResourcesRequired, ElementTimeControl, EventTarget {
	const targetElement:SVGElement;
	function getStartTime():Number;
	function getCurrentTime():Number;
	throws(DOMException) function getSimpleDuration():Number;
}

interface SVGAnimateElement extends SVGAnimationElement {
}

interface SVGSetElement extends SVGAnimationElement {
}

interface SVGAnimateMotionElement extends SVGAnimationElement {
}

interface SVGMPathElement extends SVGElement, SVGURIReference, SVGExternalResourcesRequired {
}

interface SVGAnimateColorElement extends SVGAnimationElement {
}

interface SVGAnimateTransformElement extends SVGAnimationElement {
}

interface SVGFontElement extends SVGElement, SVGExternalResourcesRequired, SVGStylable {
}

interface SVGGlyphElement extends SVGElement, SVGStylable {
}

interface SVGMissingGlyphElement extends SVGElement, SVGStylable {
}

interface SVGHKernElement extends SVGElement {
}

interface SVGVKernElement extends SVGElement {
}

interface SVGFontFaceElement extends SVGElement {
}

interface SVGFontFaceSrcElement extends SVGElement {
}

interface SVGFontFaceUriElement extends SVGElement {
}

interface SVGFontFaceFormatElement extends SVGElement {
}

interface SVGFontFaceNameElement extends SVGElement {
}

interface SVGDefinitionSrcElement extends SVGElement {
}

interface SVGMetadataElement extends SVGElement {
}

interface SVGForeignObjectElement extends SVGElement, SVGTests, SVGLangSpace, SVGExternalResourcesRequired, SVGStylable, SVGTransformable, EventTarget {
	const x:SVGAnimatedLength;
	const y:SVGAnimatedLength;
	const width:SVGAnimatedLength;
	const height:SVGAnimatedLength;
}

