//events
class EventException {
	static const UNSPECIFIED_EVENT_TYPE_ERR:Number=0;
	
	var code:Number;
}

interface EventTarget {
	function addEventListener(type:String, listener:EventListener, useCapture:Boolean):void;
	function removeEventListener(type:String, listener:EventListener, useCapture:Boolean):void;
	throws(EventException) function dispatchEvent(evt:Event):Boolean;
}

interface EventListener {
	function handleEvent(evt:Event):void;
}

interface Event {
	static const CAPTURING_PHASE:Number=1;
	static const AT_TARGET:Number=2;
	static const BUBBLING_PHASE:Number=3;
	const type:String;
	const target:EventTarget;
	const currentTarget:EventTarget;
	const eventPhase:Number;
	const bubbles:Boolean;
	const cancelable:Boolean;
	const timeStamp:DOMTimeStamp;
	function stopPropagation():void;
	function preventDefault():void;
	function initEvent(eventTypeArg:String, canBubbleArg:Boolean, cancelableArg:Boolean):void;
}

interface DocumentEvent {
	throws(DOMException) function createEvent(eventType:String):Event;
}

interface UIEvent extends Event {
	const view:AbstractView;
	const detail:Number;
	function initUIEvent(typeArg:String, canBubbleArg:Boolean, cancelableArg:Boolean, viewArg:AbstractView, detailArg:Number):void;
}

interface MouseEvent extends UIEvent {
	const screenX:Number;
	const screenY:Number;
	const clientX:Number;
	const clientY:Number;
	const ctrlKey:Boolean;
	const shiftKey:Boolean;
	const altKey:Boolean;
	const metaKey:Boolean;
	const button:Number;
	const relatedTarget:EventTarget;
	function initMouseEvent(typeArg:String, canBubbleArg:Boolean, cancelableArg:Boolean, viewArg:AbstractView, detailArg:Number, screenXArg:Number, screenYArg:Number, clientXArg:Number, clientYArg:Number, ctrlKeyArg:Boolean, altKeyArg:Boolean, shiftKeyArg:Boolean, metaKeyArg:Boolean, buttonArg:Number, relatedTargetArg:EventTarget):void;
}

interface MutationEvent extends Event {
	static const MODIFICATION:Number=1;
	static const ADDITION:Number=2;
	static const REMOVAL:Number=3;
	const relatedNode:Node;
	const prevValue:String;
	const newValue:String;
	const attrName:String;
	const attrChange:Number;
	function initMutationEvent(typeArg:String, canBubbleArg:Boolean, cancelableArg:Boolean, relatedNodeArg:Node, prevValueArg:String, newValueArg:String, attrNameArg:String, attrChangeArg:Number):void;
}

