//css
interface CSSRuleList {
	const length:Number;
	function item(index:Number):CSSRule;
}

interface CSSRule {
	static const UNKNOWN_RULE:Number=0;
	static const STYLE_RULE:Number=1;
	static const CHARSET_RULE:Number=2;
	static const IMPORT_RULE:Number=3;
	static const MEDIA_RULE:Number=4;
	static const FONT_FACE_RULE:Number=5;
	static const PAGE_RULE:Number=6;
	const type:Number;
	var cssText:String;
	const parentStyleSheet:CSSStyleSheet;
	const parentRule:CSSRule;
}

interface CSSStyleRule extends CSSRule {
	var selectorText:String;
	const style:CSSStyleDeclaration;
}

interface CSSMediaRule extends CSSRule {
	const media:MediaList;
	const cssRules:CSSRuleList;
	throws(DOMException) function insertRule(rule:String, index:Number):Number;
	throws(DOMException) function deleteRule(index:Number):void;
}

interface CSSFontFaceRule extends CSSRule {
	const style:CSSStyleDeclaration;
}

interface CSSPageRule extends CSSRule {
	var selectorText:String;
	const style:CSSStyleDeclaration;
}

interface CSSImportRule extends CSSRule {
	const href:String;
	const media:MediaList;
	const styleSheet:CSSStyleSheet;
}

interface CSSCharsetRule extends CSSRule {
	var encoding:String;
}

interface CSSUnknownRule extends CSSRule {
}

interface CSSStyleDeclaration {
	var cssText:String;
	function getPropertyValue(propertyName:String):String;
	function getPropertyCSSValue(propertyName:String):CSSValue;
	throws(DOMException) function removeProperty(propertyName:String):String;
	function getPropertyPriority(propertyName:String):String;
	throws(DOMException) function setProperty(propertyName:String, value:String, priority:String):void;
	const length:Number;
	function item(index:Number):String;
	const parentRule:CSSRule;
}

interface CSSValue {
	static const CSS_INHERIT:Number=0;
	static const CSS_PRIMITIVE_VALUE:Number=1;
	static const CSS_VALUE_LIST:Number=2;
	static const CSS_CUSTOM:Number=3;
	var cssText:String;
	const cssValueType:Number;
}

interface CSSPrimitiveValue extends CSSValue {
	static const CSS_UNKNOWN:Number=0;
	static const CSS_NUMBER:Number=1;
	static const CSS_PERCENTAGE:Number=2;
	static const CSS_EMS:Number=3;
	static const CSS_EXS:Number=4;
	static const CSS_PX:Number=5;
	static const CSS_CM:Number=6;
	static const CSS_MM:Number=7;
	static const CSS_IN:Number=8;
	static const CSS_PT:Number=9;
	static const CSS_PC:Number=10;
	static const CSS_DEG:Number=11;
	static const CSS_RAD:Number=12;
	static const CSS_GRAD:Number=13;
	static const CSS_MS:Number=14;
	static const CSS_S:Number=15;
	static const CSS_HZ:Number=16;
	static const CSS_KHZ:Number=17;
	static const CSS_DIMENSION:Number=18;
	static const CSS_STRING:Number=19;
	static const CSS_URI:Number=20;
	static const CSS_IDENT:Number=21;
	static const CSS_ATTR:Number=22;
	static const CSS_COUNTER:Number=23;
	static const CSS_RECT:Number=24;
	static const CSS_RGBCOLOR:Number=25;
	const primitiveType:Number;
	throws(DOMException) function setFloatValue(unitType:Number, floatValue:Number):void;
	throws(DOMException) function getFloatValue(unitType:Number):Number;
	throws(DOMException) function setStringValue(stringType:Number, stringValue:String):void;
	throws(DOMException) function getStringValue():String;
	throws(DOMException) function getCounterValue():Counter;
	throws(DOMException) function getRectValue():Rect;
	throws(DOMException) function getRGBColorValue():RGBColor;
}

interface CSSValueList extends CSSValue {
	const length:Number;
	function item(index:Number):CSSValue;
}

interface RGBColor {
	const red:CSSPrimitiveValue;
	const green:CSSPrimitiveValue;
	const blue:CSSPrimitiveValue;
}

interface Rect {
	const top:CSSPrimitiveValue;
	const right:CSSPrimitiveValue;
	const bottom:CSSPrimitiveValue;
	const left:CSSPrimitiveValue;
}

interface Counter {
	const identifier:String;
	const listStyle:String;
	const separator:String;
}

interface ElementCSSInlineStyle {
	const style:CSSStyleDeclaration;
}

interface CSS2Properties {
	var azimuth:String;
	var background:String;
	var backgroundAttachment:String;
	var backgroundColor:String;
	var backgroundImage:String;
	var backgroundPosition:String;
	var backgroundRepeat:String;
	var border:String;
	var borderCollapse:String;
	var borderColor:String;
	var borderSpacing:String;
	var borderStyle:String;
	var borderTop:String;
	var borderRight:String;
	var borderBottom:String;
	var borderLeft:String;
	var borderTopColor:String;
	var borderRightColor:String;
	var borderBottomColor:String;
	var borderLeftColor:String;
	var borderTopStyle:String;
	var borderRightStyle:String;
	var borderBottomStyle:String;
	var borderLeftStyle:String;
	var borderTopWidth:String;
	var borderRightWidth:String;
	var borderBottomWidth:String;
	var borderLeftWidth:String;
	var borderWidth:String;
	var bottom:String;
	var captionSide:String;
	var clear:String;
	var clip:String;
	var color:String;
	var content:String;
	var counterIncrement:String;
	var counterReset:String;
	var cue:String;
	var cueAfter:String;
	var cueBefore:String;
	var cursor:String;
	var direction:String;
	var display:String;
	var elevation:String;
	var emptyCells:String;
	var cssFloat:String;
	var font:String;
	var fontFamily:String;
	var fontSize:String;
	var fontSizeAdjust:String;
	var fontStretch:String;
	var fontStyle:String;
	var fontVariant:String;
	var fontWeight:String;
	var height:String;
	var left:String;
	var letterSpacing:String;
	var lineHeight:String;
	var listStyle:String;
	var listStyleImage:String;
	var listStylePosition:String;
	var listStyleType:String;
	var margin:String;
	var marginTop:String;
	var marginRight:String;
	var marginBottom:String;
	var marginLeft:String;
	var markerOffset:String;
	var marks:String;
	var maxHeight:String;
	var maxWidth:String;
	var minHeight:String;
	var minWidth:String;
	var orphans:String;
	var outline:String;
	var outlineColor:String;
	var outlineStyle:String;
	var outlineWidth:String;
	var overflow:String;
	var padding:String;
	var paddingTop:String;
	var paddingRight:String;
	var paddingBottom:String;
	var paddingLeft:String;
	var page:String;
	var pageBreakAfter:String;
	var pageBreakBefore:String;
	var pageBreakInside:String;
	var pause:String;
	var pauseAfter:String;
	var pauseBefore:String;
	var pitch:String;
	var pitchRange:String;
	var playDuring:String;
	var position:String;
	var quotes:String;
	var richness:String;
	var right:String;
	var size:String;
	var speak:String;
	var speakHeader:String;
	var speakNumeral:String;
	var speakPunctuation:String;
	var speechRate:String;
	var stress:String;
	var tableLayout:String;
	var textAlign:String;
	var textDecoration:String;
	var textIndent:String;
	var textShadow:String;
	var textTransform:String;
	var top:String;
	var unicodeBidi:String;
	var verticalAlign:String;
	var visibility:String;
	var voiceFamily:String;
	var volume:String;
	var whiteSpace:String;
	var widows:String;
	var width:String;
	var wordSpacing:String;
	var zIndex:String;
}

interface CSSStyleSheet extends StyleSheet {
	const ownerRule:CSSRule;
	const cssRules:CSSRuleList;
	throws(DOMException) function insertRule(rule:String, index:Number):Number;
	throws(DOMException) function deleteRule(index:Number):void;
}

interface ViewCSS extends AbstractView {
	function getComputedStyle(elt:Element, pseudoElt:String):CSSStyleDeclaration;
}

interface DocumentCSS extends DocumentStyle {
	function getOverrideStyle(elt:Element, pseudoElt:String):CSSStyleDeclaration;
}

interface DOMImplementationCSS extends DOMImplementation {
	throws(DOMException) function createCSSStyleSheet(title:String, media:String):CSSStyleSheet;
}

