class Object {
	var prototype:Object;
	var constructor:Object;

	function toString():String;
	function toLocaleString():String;
	function valueOf():Object;
	function toSource(object:Object):String;
	function isPrototypeOf(object:Object):Boolean;
	function hasOwnProperty(name:String):Boolean;
	function propertyIsEnumerable(name:String):Boolean;
}

class Arguments {
	var caller:Object;
	var callee:Object;
	var length:Number;
}

class Function {
	var name:String;
	var arity:Number;
	var length:Number;
	var arguments:Arguments;
	
	function apply(thisObj:Object, args:Array):Object;
	function call(thisObj:Object, ... args):Object;
}

class Math {
	static var E:Number;
	static var LN2:Number;
	static var LOG2E:Number;
	static var PI:Number;
	static var SQRT1_2:Number;
	static var SQRT2:Number;

	static function abs(x:Number):Number;
	static function acos(x:Number):Number;
	static function asin(x:Number):Number;
	static function atan(x:Number):Number;
	static function atan2(y:Number,x:Number):Number;
	static function ceil(x:Number):Number;
	static function cos(x:Number):Number;
	static function exp(x:Number):Number;
	static function floor(x:Number):Number;
	static function log(x:Number):Number;
	static function max(... values):Number;
	static function min(... values):Number;
	static function pow(x:Number,y:Number):Number;
	static function random():Number;
	static function round(x:Number):Number;
	static function sin(x:Number):Number;
	static function sqrt(x:Number):Number;
	static function tan(x:Number):Number;
}

class Array {
	var length:Number;

	function concat(... items):Array;
	function join(delimiter:String):String;
	function pop():Object;
	function push(... items):Number;
	function reverse();
	function shift():Object;
	function slice(startIndex:Number, endIndex:Number):Array;
	function sort(compare:Object, options:Number):Array;
	function splice(startIndex:Number, deleteCount:Number, ... items):Array;
	function unshift(... items):Number;
}

class Boolean {
	function Boolean(value:Object);
}

class Date {
	function Date(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number);
	function getDate():Number;
	function getDay():Number;
	function getFullYear():Number;
	function getHours():Number;
	function getMilliseconds():Number;
	function getMinutes():Number;
	function getMonth():Number;
	function getSeconds():Number;
	function getTime():Number;
	function getTimezoneOffset():Number;
	function getYear():Number;
	function getUTCDate():Number;
	function getUTCDay():Number;
	function getUTCFullYear():Number;
	function getUTCHours():Number;
	function getUTCMilliseconds():Number;
	function getUTCMinutes():Number;
	function getUTCMonth():Number;
	function getUTCSeconds():Number;
	function setDate(value:Number);
	function setFullYear(value:Number);
	function setHours(value:Number);
	function setMilliseconds(value:Number);
	function setMinutes(value:Number);
	function setMonth(value:Number);
	function setSeconds(value:Number);
	function setTime(value:Number);
	function setYear(value:Number);
	function setUTCDate(value:Number);
	function setUTCFullYear(value:Number);
	function setUTCHours(value:Number);
	function setUTCMilliseconds(value:Number);
	function setUTCMinutes(value:Number);
	function setUTCMonth(value:Number);
	function setUTCSeconds(value:Number);
	static function UTC(year:Number,month:Number,date:Number,hour:Number,min:Number,sec:Number,ms:Number):Number;
}

class Number {
	static var MAX_VALUE:Number;
	static var MIN_VALUE:Number;
	static var NaN:Number;
	static var NEGATIVE_INFINITY:Number;
	static var POSITIVE_INFINITY:Number;

	function Number(num:Object);
	
	function toPrecision(precision:Number):String;
	function toFixed(fractionDigits:Number):String;
	function toExponential(fractionDigits:Number):String;
}

class String {
	var length:Number;

	static function fromCharCode(... chars):String;

	function String(string:String);
	function charAt(index:Number):String;
	function charCodeAt(index:Number):Number;
	function concat(... strings):String;
	function indexOf(value:String, startIndex:Number):Number;
	function lastIndexOf(value:String, startIndex:Number):Number;
	function slice(index1:Number,index2:Number):String;
	function split(delimiter:String):Array;
	function substring(index1:Number,index2:Number):String;
	function toUpperCase():String;
	function toLowerCase():String;
}

class RegExp {
	function RegExp(pattern:String, flags:String);
	
	var source:String;
	var global:Boolean;
	var ignoreCase:Boolean;
	var multiline:Boolean;
	var lastIndex:Number;
	
	function exec(string:String):Array;
	function test(string:String):Boolean;
}

class Error {
	function Error(message:String);
	
	var name:String;
	var message:String;
}

class EvalError extends Error {
}

class RangeError extends Error {
}

class ReferenceError extends Error {
}

class SyntaxError extends Error {
}

class TypeError extends Error {
}

class URIError extends Error {
}

class NativeError extends Error {
}

class Global {
	var NaN;
	var Infinity;
	var undefined;
	
	throws(SyntaxError) function eval(x:Object):Object;
	function parseInt(str:String, radix:Number=0):Number;
	function parseFloat(str:String):Number;
	function isNaN(number:Object):Boolean;
	function isFinite(number:Object):Boolean;
	function decodeURI(encodedURI:String):String;
	function decodeURIComponent(encodedURIComponent:String):String;
	function encodeURI(uri:String):String;
	function encodeURIComponent(uriComponent:String):String;
}
