class DOMException {
	static const INDEX_SIZE_ERR = 1;
	static const DOMSTRING_SIZE_ERR = 2;
	static const HIERARCHY_REQUEST_ERR = 3;
	static const WRONG_DOCUMENT_ERR = 4;
	static const INVALID_CHARACTER_ERR = 5;
	static const NO_DATA_ALLOWED_ERR = 6;
	static const NO_MODIFICATION_ALLOWED_ERR = 7;
	static const NOT_FOUND_ERR = 8;
	static const NOT_SUPPORTED_ERR = 9;
	static const IN_USE_ATTRIBUTE_ERR = 10;

	var code:Number;
}

class DOMNodeList {
	var length:Number;

	function item(n:Number):DOMNode;
}

class DOMNamedNodeMap {
	var length:Number;

	function getNamedItem(name:String):DOMNode;
	function setNamedItem(node:String):DOMNode;
	function removeNamedItem(name:String):DOMNode;
	function item(n:Number):DOMNode;
}

class DOMNode {
	var nodeName:String;
	var nodeType:Number;
	var parentNode:DOMNode;
	var childNodes:DOMNodeList;
	var firstChild:DOMNode;
	var lastChild:DOMNode;
	var previousSibling:DOMNode;
	var nextSibling:DOMNode;
	var attributes:DOMNamedNodeMap;
	var ownerDocument:DOMDocument;

	function insertBefore(newChild:DOMNode, refChild:DOMNode):DOMNode;
	function replaceChild(newChild:DOMNode, oldChild:DOMNode):DOMNode;
	function removeChild(oldChild:DOMNode):DOMNode;
	function appendChild(newChild:DOMNode):DOMNode;
	function hasChildNodes():Boolean;
	function cloneNode(deep:Boolean):DOMNode;
	function evaluate(xpath:String);
	function toXML():String;
}

class DOMDocumentType extends DOMNode {
	var name:String;
}

class DOMCharacterData extends DOMNode {
	var data:String;
	var length:Number;

	function substringData(offset:Number, count:Number):String;
	function appendData(data:String):void;
	function insertData(offset:Number, data:String):void;
	function deleteData(offset:Number, count:Number):void;
	function replaceData(offset:Number, count:Number, data:String):void;
}

class DOMText extends DOMCharacterData {
	function splitText(offset:Number):DOMText;
}

class DOMComment extends DOMCharacterData {
}

class DOMCDATASection extends DOMCharacterData {
}

class DOMAttribute extends DOMNode {
	var name:String;
	var value:String;
}

class DOMElement extends DOMNode {
	var tagName:String;
	
	function getAttribute(name:String):String;
	function setAttribute(name:String, value:String):void;
	function removeAttribute(name:String):void;
	function getAttributeNode(name:String):DOMAttribute;
	function setAttributeNode(attr:DOMAttributes):DOMAttribute;
	function removeAttributeNode(attr:DOMAttributes):DOMAttribute;
	function getElementsByTagName(name:String):DOMNodeList;
	function normalize():void;
}

class DOMDocument extends DOMNode {
	var doctype:DOMDocumentType;
	var documentElement:DOMElement;

	function createElement(tagName:String):DOMElement;
	function createTextNode(data:String):DOMText;
	function createComment(data:String):DOMComment;
	function createCDATASection(data:String):DOMCDATASection;
	function createProcessingInstruction(target:String, data:String):DOMProcessingInstruction;
	function createAttribute(name:String):DOMAttribute;
	function getElementsByName(name:String):DOMNodeList;
	function importNode(node:DOMNode, deep:Boolean):DOMNode;
}

class DOMNotation extends DOMNode {
}

class DOMEntity extends DOMNode {
}

class DOMEntityReference extends DOMNode {
}

class DOMProcessingInstruction extends DOMNode {
	var target:String;
	var data:String;
}

@prototype class XMLDOM {
	function createDocument():DOMDocument;
	function parse(xml:String):DOMDocument;
}

class XMLHttpRequest {
	var onreadystatechange:Function;
	var readyState:Number;
	var responseText:String;
	var responseXML:DOMDocument; //FIXME
	var status:Number;
	var statusText:Number;
	
	function abort():void;
	function getAllResponseHeaders():String[];
	function getResponseHeader(name:String):String||String[];
	function open(method:String, url:String, async:Boolean):void;
	function send(body:String=null):void;
	function setRequestHeader(name:String, value:String):void;
}
