/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.wpfe.model.render.UIElement;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class XShape
extends UIElement {
    protected static final BasicStroke STRETCH_STROKE = new BasicStroke(1.0f, 0, 1);
    protected Shape shape;
    protected Shape transformedShape;
    protected Stroke stroke;
    protected Paint foreground;
    protected Paint background;
    protected short stretch;

    public XShape(short s) {
        this.stretch = s;
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
    }

    public Paint getForeground() {
        return this.foreground;
    }

    public void setForeground(Paint paint) {
        this.foreground = paint;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.transform = null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.transform = null;
    }

    public short getStretch() {
        return this.stretch;
    }

    public void setStretch(short s) {
        this.stretch = s;
    }

    public Rectangle2D getOriginBounds() {
        if (this.shape == null) {
            return EMPTY_RECT;
        }
        if (this.width <= 0.0 && this.width != Double.NEGATIVE_INFINITY) {
            return EMPTY_RECT;
        }
        if (this.height <= 0.0 && this.height != Double.NEGATIVE_INFINITY) {
            return EMPTY_RECT;
        }
        if (this.shape instanceof Rectangle2D || this.shape instanceof Ellipse2D) {
            if (this.width == Double.NEGATIVE_INFINITY) {
                if (this.height == Double.NEGATIVE_INFINITY) {
                    return EMPTY_RECT;
                }
                return new Rectangle2D.Double(0.0, 0.0, 0.0, this.height);
            }
            if (this.height == Double.NEGATIVE_INFINITY) {
                return new Rectangle2D.Double(0.0, 0.0, this.width, 0.0);
            }
            return new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        }
        double d = this.width;
        double d2 = this.height;
        double d3 = this.getLineWidth();
        Rectangle2D rectangle2D = null;
        if (this.width == Double.NEGATIVE_INFINITY) {
            rectangle2D = this.shape.getBounds2D();
            d = 0 == this.stretch ? rectangle2D.getMaxX() : rectangle2D.getWidth();
            if (d > 0.0) {
                d += d3;
            }
        }
        if (this.height == Double.NEGATIVE_INFINITY) {
            if (rectangle2D == null) {
                rectangle2D = this.shape.getBounds2D();
            }
            if ((d2 = 0 == this.stretch ? rectangle2D.getMaxY() : rectangle2D.getHeight()) > 0.0) {
                d2 += d3;
            }
        }
        if (d > 0.0 && d2 > 0.0) {
            return new Rectangle2D.Double(0.0, 0.0, d, d2);
        }
        return EMPTY_RECT;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.shape != null) {
            if (this.width <= 0.0 && this.width != Double.NEGATIVE_INFINITY) {
                return null;
            }
            if (this.height <= 0.0 && this.height != Double.NEGATIVE_INFINITY) {
                return null;
            }
            if (this.stretch == 0) {
                Rectangle2D rectangle2D = this.stroke == null ? this.shape.getBounds2D() : this.stroke.createStrokedShape(this.shape).getBounds2D();
                return rectangle2D;
            }
            Shape shape = this.getTransformedShape();
            if (this.stroke != null) {
                this.stroke.createStrokedShape(shape).getBounds2D();
            }
            return shape.getBounds2D();
        }
        return null;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.shape == null) {
            return;
        }
        if (this.background == null && this.foreground == null) {
            return;
        }
        super.paint(graphics2D);
    }

    public void primitivePaint(Graphics2D graphics2D) {
        Paint paint = null;
        Graphics2D graphics2D2 = null;
        Shape shape = this.getTransformedShape();
        if (shape == null || shape == EMPTY_RECT) {
            return;
        }
        if (!(this.stretch != 0 && this.stretch != 3 || this.isOffscreenBufferNeeded() || this.width == Double.NEGATIVE_INFINITY && this.height == Double.NEGATIVE_INFINITY)) {
            graphics2D2 = graphics2D;
            graphics2D = (Graphics2D)graphics2D2.create();
            graphics2D.clip(this.getOriginBounds());
        }
        if (this.background != null) {
            paint = graphics2D.getPaint();
            graphics2D.setPaint(this.background);
            graphics2D.fill(shape);
        }
        if (this.foreground != null) {
            Stroke stroke = null;
            if (this.stroke != null) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.stroke);
            }
            if (paint == null) {
                paint = graphics2D.getPaint();
            }
            graphics2D.setPaint(this.foreground);
            graphics2D.draw(shape);
            if (stroke != null) {
                graphics2D.setStroke(stroke);
            }
        }
        if (graphics2D2 == null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
        } else {
            graphics2D.dispose();
        }
    }

    protected Shape getTransformedShape() {
        if (this.transformedShape == null) {
            this.transformedShape = this.shape;
            if (this.shape instanceof Rectangle2D) {
                if (this.width > 0.0 && this.height > 0.0 && this.stretch != 0) {
                    float f = this.getLineWidth();
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = this.width;
                    double d4 = this.height;
                    if (f > 1.0f) {
                        d = f / 2.0f;
                        d2 = f / 2.0f;
                        d3 = d3 < (double)f ? 0.0 : (d3 -= (double)f);
                        d4 = d4 < (double)f ? 0.0 : (d4 -= (double)f);
                    }
                    switch (this.stretch) {
                        case 2: {
                            if (this.width < this.height) {
                                this.transformedShape = new Rectangle2D.Double(d, d2, d3, d3);
                                break;
                            }
                            this.transformedShape = new Rectangle2D.Double(d, d2, d4, d4);
                            break;
                        }
                        case 3: {
                            if (this.width < this.height) {
                                this.transformedShape = new Rectangle2D.Double(d, d2, d4, d4);
                                break;
                            }
                            this.transformedShape = new Rectangle2D.Double(d, d2, d3, d3);
                            break;
                        }
                        default: {
                            this.transformedShape = new Rectangle2D.Double(d, d2, d3, d4);
                            break;
                        }
                    }
                } else {
                    this.transformedShape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                }
            } else if (this.shape instanceof Ellipse2D) {
                if (this.width > 0.0 && this.height > 0.0 && this.stretch != 0) {
                    float f = this.getLineWidth();
                    double d = 0.0;
                    double d5 = 0.0;
                    double d6 = this.width;
                    double d7 = this.height;
                    if (f > 1.0f) {
                        d = f / 2.0f;
                        d5 = f / 2.0f;
                        d6 = d6 < (double)f ? 0.0 : (d6 -= (double)f);
                        d7 = d7 < (double)f ? 0.0 : (d7 -= (double)f);
                    }
                    switch (this.stretch) {
                        case 2: {
                            if (d6 < d7) {
                                this.transformedShape = new Ellipse2D.Double(d, d5, d6, d6);
                                break;
                            }
                            this.transformedShape = new Ellipse2D.Double(d, d5, d7, d7);
                            break;
                        }
                        case 3: {
                            if (d6 < d7) {
                                this.transformedShape = new Ellipse2D.Double(d, d5, d7, d7);
                                break;
                            }
                            this.transformedShape = new Ellipse2D.Double(d, d5, d6, d6);
                            break;
                        }
                        default: {
                            this.transformedShape = new Ellipse2D.Double(d, d5, d6, d7);
                            break;
                        }
                    }
                } else {
                    this.transformedShape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
                }
            } else if (0 != this.stretch) {
                double d;
                double d8;
                double d9 = 1.0;
                double d10 = 1.0;
                float f = this.getLineWidth();
                Rectangle2D rectangle2D = STRETCH_STROKE.createStrokedShape(this.shape).getBounds2D();
                if (f > 1.0f) {
                    if (this.width > 0.0) {
                        d9 = (this.width - (double)f) / rectangle2D.getWidth();
                    }
                    if (this.height > 0.0) {
                        d10 = (this.height - (double)f) / rectangle2D.getHeight();
                    }
                } else {
                    if (this.width > 0.0) {
                        d9 = this.width / rectangle2D.getWidth();
                    }
                    if (this.height > 0.0) {
                        d10 = this.height / rectangle2D.getHeight();
                    }
                }
                if (this.width > 0.0) {
                    d8 = this.width / 2.0;
                } else {
                    d8 = rectangle2D.getWidth() / 2.0;
                    if (f > 1.0f) {
                        d8 += (double)(f / 2.0f);
                    }
                }
                if (this.height > 0.0) {
                    d = this.height / 2.0;
                } else {
                    d = rectangle2D.getHeight() / 2.0;
                    if (f > 1.0f) {
                        d += (double)(f / 2.0f);
                    }
                }
                if (d9 <= 0.001 || d10 <= 0.001) {
                    this.transformedShape = EMPTY_RECT;
                } else {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(d8, d);
                    if (d9 != 1.0 || d10 != 1.0) {
                        switch (this.stretch) {
                            case 2: {
                                if (d9 > d10) {
                                    d9 = d10;
                                    break;
                                }
                                if (!(d9 < d10)) break;
                                d10 = d9;
                                break;
                            }
                            case 3: {
                                if (d9 < d10) {
                                    d9 = d10;
                                    break;
                                }
                                if (!(d9 > d10)) break;
                                d10 = d9;
                            }
                        }
                        affineTransform.scale(d9, d10);
                    }
                    affineTransform.translate(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
                    if (!affineTransform.isIdentity()) {
                        this.transformedShape = affineTransform.createTransformedShape(this.shape);
                    }
                }
            }
        }
        return this.transformedShape;
    }

    protected float getLineWidth() {
        if (this.stroke instanceof BasicStroke) {
            return ((BasicStroke)this.stroke).getLineWidth();
        }
        return 0.0f;
    }
}

