/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model;

import com.spket.wpfe.model.WPFEConstants;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.SymbolTable;

public class WPFEHelper
implements WPFEConstants {
    private static final String[] tags;
    private static final String[] attrs;
    private static Map tagMap;
    private static Map attrMap;

    public static Integer getTagID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)tagMap.get(string);
    }

    public static int getTagId(String string) {
        Integer n = WPFEHelper.getTagID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getTagName(int n) {
        if (n > 0 && n <= tags.length) {
            return tags[n - 1];
        }
        return null;
    }

    public static Integer getAttrID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)attrMap.get(string);
    }

    public static int getAttrId(String string) {
        Integer n = WPFEHelper.getAttrID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getAttrName(int n) {
        if (n > 0 && n <= attrs.length) {
            return attrs[n - 1];
        }
        return null;
    }

    public static void initSymbolTable(SymbolTable symbolTable) {
        int n;
        symbolTable.addSymbol("http://schemas.microsoft.com/winfx/2006/xaml");
        symbolTable.addSymbol("http://schemas.microsoft.com/client/2007");
        symbolTable.addSymbol("x");
        symbolTable.addSymbol("x:Name");
        for (n = 0; n < tags.length; ++n) {
            symbolTable.addSymbol(tags[n]);
        }
        for (n = 0; n < attrs.length; ++n) {
            symbolTable.addSymbol(attrs[n]);
        }
    }

    static {
        int n;
        tags = new String[]{"ArcSegment", "BeginStoryboard", "BeginStoryboard.Storyboard", "BezierSegment", "Canvas", "Canvas.Background", "Canvas.Children", "Canvas.Clip", "Canvas.OpacityMask", "Canvas.RenderTransform", "Canvas.Resources", "Canvas.Triggers", "ColorAnimation", "ColorAnimationUsingKeyFrames", "ColorAnimationUsingKeyFrames.KeyFrames", "DiscreteColorKeyFrame", "DiscreteDoubleKeyFrame", "DiscretePointKeyFrame", "DoubleAnimation", "DoubleAnimationUsingKeyFrames", "DoubleAnimationUsingKeyFrames.KeyFrames", "Downloader", "DrawingAttributes", "Ellipse", "Ellipse.Clip", "Ellipse.Fill", "Ellipse.OpacityMask", "Ellipse.RenderTransform", "Ellipse.Resources", "Ellipse.Stroke", "Ellipse.Triggers", "EllipseGeometry", "EllipseGeometry.Transform", "ErrorEventArgs", "EventArgs", "EventTrigger", "EventTrigger.Actions", "FontFamily", "GeometryCollection", "GeometryGroup", "GeometryGroup.Children", "GeometryGroup.Transform", "Glyphs", "Glyphs.Clip", "Glyphs.Fill", "Glyphs.OpacityMask", "Glyphs.RenderTransform", "Glyphs.Resources", "Glyphs.Triggers", "GradientStop", "GradientStopCollection", "Image", "Image.Clip", "Image.OpacityMask", "Image.RenderTransform", "Image.Resources", "Image.Triggers", "ImageBrush", "ImageBrush.RelativeTransform", "ImageBrush.Transform", "InkPresenter", "InkPresenter.Background", "InkPresenter.Children", "InkPresenter.Clip", "InkPresenter.OpacityMask", "InkPresenter.RenderTransform", "InkPresenter.Resources", "InkPresenter.Strokes", "InkPresenter.Triggers", "Inlines", "KeyFrameCollection", "KeySpline", "KeyTime", "KeyboardEventArgs", "Line", "Line.Clip", "Line.Fill", "Line.OpacityMask", "Line.RenderTransform", "Line.Resources", "Line.Stroke", "Line.Triggers", "LineBreak", "LineBreak.FontFamily", "LineBreak.Foreground", "LineGeometry", "LineGeometry.Transform", "LineSegment", "LinearColorKeyFrame", "LinearDoubleKeyFrame", "LinearGradientBrush", "LinearGradientBrush.GradientStops", "LinearGradientBrush.RelativeTransform", "LinearGradientBrush.Transform", "LinearPointKeyFrame", "Matrix", "MatrixTransform", "MatrixTransform.Matrix", "MediaElement", "MediaElement.Attributes", "MediaElement.Clip", "MediaElement.Markers", "MediaElement.OpacityMask", "MediaElement.RenderTransform", "MediaElement.Resources", "MediaElement.Triggers", "MouseEventArgs", "ParserErrorEventArgs", "Path", "Path.Clip", "Path.Data", "Path.Fill", "Path.OpacityMask", "Path.RenderTransform", "Path.Resources", "Path.Stroke", "Path.Triggers", "PathFigure", "PathFigure.Segments", "PathFigureCollection", "PathGeometry", "PathGeometry.Figures", "PathGeometry.Transform", "PathSegmentCollection", "PointAnimation", "PointAnimationUsingKeyFrames", "PointAnimationUsingKeyFrames.KeyFrames", "PolyBezierSegment", "PolyLineSegment", "PolyQuadraticBezierSegment", "Polygon", "Polygon.Clip", "Polygon.Fill", "Polygon.OpacityMask", "Polygon.RenderTransform", "Polygon.Resources", "Polygon.Stroke", "Polygon.Triggers", "Polyline", "Polyline.Clip", "Polyline.Fill", "Polyline.OpacityMask", "Polyline.RenderTransform", "Polyline.Resources", "Polyline.Stroke", "Polyline.Triggers", "QuadraticBezierSegment", "RadialGradientBrush", "RadialGradientBrush.GradientStops", "RadialGradientBrush.RelativeTransform", "RadialGradientBrush.Transform", "Rectangle", "Rectangle.Clip", "Rectangle.Fill", "Rectangle.OpacityMask", "Rectangle.RenderTransform", "Rectangle.Resources", "Rectangle.Stroke", "Rectangle.Triggers", "RectangleGeometry", "RectangleGeometry.Transform", "ResourceCollection", "RotateTransform", "Run", "Run.FontFamily", "Run.Foreground", "RuntimeErrorEventArgs", "ScaleTransform", "SkewTransform", "SolidColorBrush", "SolidColorBrush.RelativeTransform", "SolidColorBrush.Transform", "SplineColorKeyFrame", "SplineColorKeyFrame.KeySpline", "SplineDoubleKeyFrame", "SplineDoubleKeyFrame.KeySpline", "SplinePointKeyFrame", "SplinePointKeyFrame.KeySpline", "Storyboard", "Storyboard.Children", "Stroke", "Stroke.DrawingAttributes", "Stroke.StylusPoints", "StrokeCollection", "StylusInfo", "StylusPoint", "StylusPointCollection", "TextBlock", "TextBlock.Clip", "TextBlock.FontFamily", "TextBlock.Foreground", "TextBlock.Inlines", "TextBlock.OpacityMask", "TextBlock.RenderTransform", "TextBlock.Resources", "TextBlock.Triggers", "TimelineCollection", "TimelineMarker", "TimelineMarkerCollection", "TimelineMarkerEventArgs", "TimelineMarkerEventArgs.Marker", "TransformCollection", "TransformGroup", "TransformGroup.Children", "TranslateTransform", "TriggerActionCollection", "TriggerCollection", "VideoBrush", "VideoBrush.RelativeTransform", "VideoBrush.Transform", "VisualCollection"};
        attrs = new String[]{"Actions", "AlignmentX", "AlignmentY", "Angle", "AngleX", "AngleY", "Attributes", "AutoPlay", "AutoReverse", "Background", "Balance", "BeginTime", "BufferingProgressChanged", "BufferingTime", "By", "Canvas.Left", "Canvas.Top", "Canvas.ZIndex", "Center", "CenterX", "CenterY", "CharPosition", "Children", "Clip", "Color", "ColorInterpolationMode", "Completed", "Count", "Ctrl", "CurrentStateChanged", "Cursor", "Data", "DeviceType", "DownloadFailed", "DownloadProgress", "DownloadProgressChanged", "DrawingAttributes", "Duration", "EndPoint", "ErrorCode", "ErrorMessage", "ErrorType", "Figures", "Fill", "FillBehavior", "FillRule", "FontFamily", "FontRenderingEmSize", "FontSize", "FontStretch", "FontStyle", "FontUri", "FontWeight", "Foreground", "From", "GotFocus", "GradientOrigin", "GradientStops", "Height", "ImageFailed", "ImageSource", "Indices", "Inlines", "IsClosed", "IsFilled", "IsHitTestable", "IsInverted", "IsLargeArc", "IsMuted", "Key", "KeyDown", "KeyFrames", "KeySpline", "KeyTime", "KeyUp", "LineNumber", "Loaded", "LostFocus", "M11", "M12", "M21", "M22", "MappingMode", "Marker", "MarkerReached", "Markers", "Matrix", "MediaEnded", "MediaFailed", "MediaOpened", "MethodName", "MouseEnter", "MouseLeave", "MouseLeftButtonDown", "MouseLeftButtonUp", "MouseMove", "Name", "Offset", "OffsetX", "OffsetY", "Opacity", "OpacityMask", "OriginX", "OriginY", "OutlineColor", "PlatformKeyCode", "Point", "Point1", "Point2", "Point3", "Points", "Position", "PressureFactor", "RadiusX", "RadiusY", "Rect", "RelativeTransform", "RenderTransform", "RenderTransformOrigin", "RepeatBehavior", "Resources", "ResponseText", "RotationAngle", "RoutedEvent", "ScaleX", "ScaleY", "Seconds", "Segments", "Shift", "Size", "Source", "SourceName", "SpeedRatio", "SpreadMethod", "StartPoint", "Status", "StatusText", "Storyboard", "Storyboard.TargetName", "Storyboard.TargetProperty", "Stretch", "Stroke", "StrokeDashArray", "StrokeDashCap", "StrokeDashOffset", "StrokeEndLineCap", "StrokeLineJoin", "StrokeMiterLimit", "StrokeStartLineCap", "StrokeThickness", "Strokes", "StyleSimulations", "StylusPoints", "SweepDirection", "Text", "TextDecorations", "TextWrapping", "Time", "To", "Transform", "Triggers", "Type", "URI", "UnicodeString", "Value", "Visibility", "Volume", "Width", "X", "X1", "X2", "XamlFile", "XmlAttribute", "XmlElement", "Y", "Y1", "Y2"};
        tagMap = new HashMap(tags.length);
        attrMap = new HashMap(attrs.length);
        for (n = 0; n < tags.length; ++n) {
            tagMap.put(tags[n], new Integer(n + 1));
        }
        for (n = 0; n < attrs.length; ++n) {
            attrMap.put(attrs[n], new Integer(n + 1));
        }
    }
}

