/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public final class UIUtils {
    public static final int DRAG_THRESHOLD = 5;
    public static final String STRING_EXTENT = "gM";
    public static final String FONT_SYMBOL = "font.symbol";
    public static final String ICON_PLUS = "plus.gif";
    public static final String ICON_MINUS = "minus.gif";
    public static final String COLOR_BORDER = "color.border";
    public static final String COLOR_MOUSE_OVER = "color.over";
    public static final String COLOR_SELECTION = "color.selection";
    public static final String COLOR_SELECTION_HOVER = "color.selection.hover";
    private static final String ELLIPSIS = "...";

    static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    static int getDarkColor(int n, double d) {
        return (int)((double)n * d);
    }

    public static RGB getLighterColor(Color color, double d) {
        return UIUtils.getLighterColor(color.getRGB(), d);
    }

    public static RGB getLighterColor(RGB rGB, double d) {
        int n = UIUtils.getLightColor(rGB.red, d);
        int n2 = UIUtils.getLightColor(rGB.green, d) + 1;
        int n3 = UIUtils.getLightColor(rGB.blue, d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new RGB(n, n2, n3);
    }

    public static void expand(Rectangle rectangle, int n, int n2) {
        UIUtils.shrink(rectangle, -n, -n2);
    }

    public static void shrink(Rectangle rectangle, int n, int n2) {
        if (rectangle != null) {
            rectangle.x += n;
            rectangle.width -= n + n;
            rectangle.y += n2;
            rectangle.height -= n2 + n2;
        }
    }

    public static Rectangle union(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle2.x < rectangle.x ? rectangle2.x : rectangle.x;
        int n2 = rectangle2.y < rectangle.y ? rectangle2.y : rectangle.y;
        int n3 = rectangle2.x + rectangle2.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 > n4 ? n3 : n4;
        n3 = rectangle2.y + rectangle2.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 > n4 ? n3 : n4;
        rectangle2.x = n;
        rectangle2.y = n2;
        rectangle2.width = n5 - n;
        rectangle2.height = n6 - n2;
        return rectangle2;
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static boolean isLeftMouseButton(Event event) {
        return event.button == 1;
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return mouseEvent.button == 1;
    }

    public static boolean isRightMouseButton(Event event) {
        return event.button == 3;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return mouseEvent.button == 3;
    }

    public static boolean isMouseButtonDown(Event event) {
        return (event.stateMask & SWT.BUTTON_MASK) != 0;
    }

    public static boolean isControlDown(int n) {
        return (n & 0x40000) != 0;
    }

    public static boolean isShiftDown(int n) {
        return (n & 0x20000) != 0;
    }

    public static boolean isAltDown(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isModKeyDown(int n, int n2) {
        return (n & n2) != 0;
    }

    public static String shortenText(GC gC, String string, int n) {
        if (n < 5) {
            return "";
        }
        if (gC.stringExtent((String)string).x <= n) {
            return string;
        }
        int n2 = gC.stringExtent((String)ELLIPSIS).x;
        int n3 = string.length();
        for (int i = n3 - 1; i > 0; --i) {
            string = string.substring(0, i);
            int n4 = gC.stringExtent((String)string).x;
            if (n4 + n2 > n) continue;
            return string + ELLIPSIS;
        }
        return string + ELLIPSIS;
    }

    public static void drawBorder(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (n3 > 0 && n4 > 0) {
            int n5 = n + n3;
            int n6 = n2 + n4;
            Color color3 = gC.getForeground();
            gC.setForeground(color);
            gC.drawLine(n, n2, n5, n2);
            gC.drawLine(n, n2, n, n6);
            gC.setForeground(color2);
            gC.drawLine(n5, n2, n5, n6);
            gC.drawLine(n, n6, n5, n6);
            gC.setForeground(color3);
        }
    }
}

