/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.theme;

import com.spket.ui.theme.TabbedPane;
import com.spket.ui.theme.TabbedPaneEvent;
import com.spket.ui.theme.TabbedPaneListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.presentations.util.ISystemMenu;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;
import org.eclipse.ui.presentations.StackPresentation;

public abstract class BasicStackPresentation
extends StackPresentation {
    protected static final Control[] EMPTY_TABS = new Control[0];
    private TabbedPane tabs;
    private ISystemMenu systemMenu;
    private Menu partListMenu;
    private Listener partListListener = new Listener(){

        public void handleEvent(Event event) {
            BasicStackPresentation.this.handlePartListEvent(event);
        }
    };

    public BasicStackPresentation(IStackPresentationSite iStackPresentationSite, Composite composite) {
        super(iStackPresentationSite);
        this.tabs = this.createTabbedPane(composite);
        this.systemMenu = this.createSystemMenu();
        this.addListeners();
    }

    public int computePreferredSize(boolean bl, int n, int n2, int n3) {
        if (this.getSite().getState() == 0) {
            Point point = this.tabs.computeSize(-1, -1);
            return bl ? point.x : point.y;
        }
        return n3;
    }

    protected void addListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12) {
                    BasicStackPresentation.this.onDispose();
                }
            }
        };
        this.tabs.addListener(12, listener);
        this.tabs.addListener(new TabbedPaneListener(){

            public void handleEvent(TabbedPaneEvent tabbedPaneEvent) {
                BasicStackPresentation.this.handleTabbedPaneEvent(tabbedPaneEvent);
            }
        });
    }

    protected abstract TabbedPane createTabbedPane(Composite var1);

    protected abstract ISystemMenu createSystemMenu();

    public Control getControl() {
        return this.tabs;
    }

    public void addPart(IPresentablePart iPresentablePart, Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n < 0) {
                n = 0;
            }
            this.tabs.insert(iPresentablePart, n);
        } else {
            this.tabs.add(iPresentablePart);
        }
    }

    public void dispose() {
        if (this.tabs != null) {
            this.tabs.dispose();
            this.tabs = null;
        }
    }

    protected void onDispose() {
        this.tabs = null;
        this.systemMenu = null;
        this.partListListener = null;
    }

    protected void handlePartListEvent(Event event) {
        IPresentablePart iPresentablePart;
        Object object;
        if (event.type == 13 && (object = event.widget.getData()) instanceof Integer && (iPresentablePart = this.tabs.getPart((Integer)object)) != null) {
            this.getSite().selectPart(iPresentablePart);
        }
    }

    protected void handleTabbedPaneEvent(TabbedPaneEvent tabbedPaneEvent) {
        switch (tabbedPaneEvent.type) {
            case 6: {
                if (tabbedPaneEvent.part == null) break;
                this.getSite().close(new IPresentablePart[]{tabbedPaneEvent.part});
                break;
            }
            case 4: {
                if (this.getSite().getState() == 1) {
                    this.getSite().setState(2);
                    break;
                }
                this.getSite().setState(1);
                break;
            }
            case 9: {
                IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
                if (iPresentablePart == null) break;
                iPresentablePart.setFocus();
                break;
            }
            case 12: {
                IPresentablePart iPresentablePart = tabbedPaneEvent.part;
                if (iPresentablePart == null) {
                    iPresentablePart = this.getSite().getSelectedPart();
                }
                if (iPresentablePart == null) break;
                this.showSystemMenu(iPresentablePart, new Point(tabbedPaneEvent.x, tabbedPaneEvent.y));
                break;
            }
            case 8: {
                if (tabbedPaneEvent.part == null) break;
                this.getSite().selectPart(tabbedPaneEvent.part);
                break;
            }
            case 1: {
                this.showPaneMenu(tabbedPaneEvent.part, new Point(tabbedPaneEvent.x, tabbedPaneEvent.y));
                break;
            }
            case 11: {
                this.showPartList();
                break;
            }
            case 10: {
                IPresentablePart iPresentablePart = tabbedPaneEvent.part;
                Point point = new Point(tabbedPaneEvent.x, tabbedPaneEvent.y);
                if (iPresentablePart == null) {
                    this.getSite().dragStart(point, false);
                    break;
                }
                this.getSite().dragStart(iPresentablePart, point, false);
            }
        }
    }

    public StackDropResult dragOver(Control control, Point point) {
        if (this.tabs.isTabVisible()) {
            Point point2 = this.tabs.toControl(point);
            int n = this.tabs.getTabIndex(point2.x, point2.y);
            Rectangle rectangle = this.tabs.getTabBounds(n);
            if (rectangle != null) {
                point2 = this.tabs.toDisplay(rectangle.x, rectangle.y);
                rectangle.x = point2.x;
                rectangle.y = point2.y;
                return new StackDropResult(rectangle, (Object)new Integer(n));
            }
        }
        return null;
    }

    public Control[] getTabList(IPresentablePart iPresentablePart) {
        if (iPresentablePart.getControl() != null) {
            return new Control[]{iPresentablePart.getControl()};
        }
        return EMPTY_TABS;
    }

    public void removePart(IPresentablePart iPresentablePart) {
        this.tabs.remove(iPresentablePart);
    }

    public void selectPart(IPresentablePart iPresentablePart) {
        this.tabs.select(iPresentablePart);
    }

    public void setActive(int n) {
        this.tabs.setActive(n);
    }

    public void setBounds(Rectangle rectangle) {
        this.tabs.setBounds(rectangle);
    }

    public void setState(int n) {
        this.tabs.setState(n);
    }

    public void setVisible(boolean bl) {
        this.tabs.setVisible(bl);
        IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
        if (iPresentablePart != null) {
            iPresentablePart.setVisible(bl);
        }
        if (bl) {
            this.tabs.layout(true);
        }
    }

    public void showPartList() {
        if (this.partListMenu != null) {
            this.partListMenu.dispose();
            this.partListMenu = null;
        }
        if (this.tabs.size() > 0) {
            this.partListMenu = new Menu((Control)this.tabs);
            IPresentablePart[] iPresentablePartArray = this.tabs.getPartList();
            IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
            for (int i = 0; i < iPresentablePartArray.length; ++i) {
                IPresentablePart iPresentablePart2 = iPresentablePartArray[i];
                MenuItem menuItem = new MenuItem(this.partListMenu, 32);
                menuItem.setData((Object)new Integer(i));
                menuItem.setText(iPresentablePart2.getName());
                if (iPresentablePart2.getTitleImage() != null) {
                    menuItem.setImage(iPresentablePart2.getTitleImage());
                }
                if (iPresentablePart2 == iPresentablePart) {
                    menuItem.setSelection(true);
                }
                menuItem.addListener(13, this.partListListener);
            }
            this.partListMenu.setLocation(this.tabs.getPaneMenuLocation());
            this.partListMenu.setVisible(true);
        }
    }

    public void showPaneMenu() {
        IPresentablePart iPresentablePart = this.getSite().getSelectedPart();
        if (iPresentablePart != null) {
            this.showPaneMenu(iPresentablePart, this.tabs.getPaneMenuLocation());
        }
    }

    protected void showPaneMenu(IPresentablePart iPresentablePart, Point point) {
        IPartMenu iPartMenu = iPresentablePart.getMenu();
        if (iPartMenu != null) {
            iPartMenu.showMenu(point);
        }
    }

    public void showSystemMenu() {
        this.showSystemMenu(this.getSite().getSelectedPart(), this.tabs.getSystemMenuLocation());
    }

    protected void showSystemMenu(IPresentablePart iPresentablePart, Point point) {
        if (iPresentablePart != this.getSite().getSelectedPart()) {
            this.getSite().selectPart(iPresentablePart);
        }
        this.systemMenu.show(this.getControl(), point, iPresentablePart);
    }
}

