/*
 * Decompiled with CFR 0.152.
 */
package com.spket.mime.text;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.buffer.IBuffer;
import com.spket.js.model.Context;
import com.spket.js.model.ILexerProvider;
import com.spket.js.parser.ScriptManager;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLCDATA;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Point;

public abstract class LexerProvider
implements ILexerProvider {
    private int fStart = -1;
    private int fEnd;
    private PositionInfo fPosition;
    private BufferedScanner fLexer;
    protected int fOffset;
    protected XMLModel fModel;

    public static Point getSourceRange(int n, XMLNode xMLNode, IBuffer iBuffer) {
        int n2 = -1;
        int n3 = 0;
        switch (n) {
            case 3: {
                XMLElement xMLElement;
                INodeRegion iNodeRegion;
                if (1 != xMLNode.getNodeType() || xMLNode.getChildrenCount() != 0 || (iNodeRegion = (xMLElement = (XMLElement)xMLNode).getStartTagRegion()) == null) break;
                n2 = iNodeRegion.getEnd();
                iNodeRegion = xMLElement.getEndTagRegion();
                if (iNodeRegion == null) break;
                n3 = iNodeRegion.getStart() - n2;
                break;
            }
            case 4: {
                INodeRegion iNodeRegion = xMLNode.getRegion();
                n2 = iNodeRegion.getStart() + 9;
                n3 = iNodeRegion.getEnd() - n2;
                if (!((XMLCDATA)xMLNode).isClosed()) break;
                n3 -= 3;
                break;
            }
            case 5: {
                INodeRegion iNodeRegion = xMLNode.getRegion();
                n2 = iNodeRegion.getStart() + 4;
                n3 = iNodeRegion.getEnd() - n2 - 3;
                break;
            }
            case 100: {
                XMLAttr xMLAttr;
                INodeRegion iNodeRegion;
                if (2 != xMLNode.getNodeType() || (iNodeRegion = (xMLAttr = (XMLAttr)xMLNode).getValueRegion()) == null) break;
                n3 = iNodeRegion.getLength() - 1;
                n2 = iNodeRegion.getStart() + ((XMLElement)xMLAttr.getParent()).getStartTagRegion().getStart();
            }
        }
        if (n2 != -1) {
            if (n3 > 0 && iBuffer != null) {
                if (2 == xMLNode.getNodeType()) {
                    if (iBuffer.get(n2) == iBuffer.get(n2 + n3)) {
                        --n3;
                    }
                    ++n2;
                }
                if (n3 > 0) {
                    return new Point(n2, n3);
                }
            }
            if (n3 >= 0) {
                return new Point(n2, n3);
            }
        }
        return null;
    }

    public LexerProvider(XMLModel xMLModel, int n) {
        this.fModel = xMLModel;
        this.fOffset = n;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public BufferedScanner getLexer() {
        if (this.fLexer == null) {
            PositionInfo positionInfo = this.getPosition();
            XMLNode xMLNode = positionInfo.node;
            if (xMLNode != null && this.isScript()) {
                if (positionInfo.nodeType == 100) {
                    XMLElement xMLElement = (XMLElement)xMLNode;
                    int n = xMLElement.getAttrCount();
                    XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
                    int n2 = this.fOffset - xMLElement.getStartTagRegion().getStart();
                    for (int i = 0; i < n; ++i) {
                        XMLAttr xMLAttr = xMLAttrArray[i];
                        INodeRegion iNodeRegion = xMLAttr.getValueRegion();
                        if (iNodeRegion == null) continue;
                        if (iNodeRegion.getStart() > n2) {
                            return null;
                        }
                        if (iNodeRegion.getEnd() <= n2) continue;
                        xMLNode = xMLAttr;
                        break;
                    }
                }
                this.fLexer = this.getLexer(positionInfo.nodeType, xMLNode);
                if (this.fLexer != null) {
                    this.fStart = this.fLexer.getSourceOffset();
                    this.fEnd = this.fStart + this.fLexer.eofPosition;
                }
            }
        }
        return this.fLexer;
    }

    protected BufferedScanner getLexer(int n, XMLNode xMLNode) {
        int n2 = 0;
        int n3 = Context.JS_1_6;
        IBuffer iBuffer = this.fModel.getBuffer();
        Point point = LexerProvider.getSourceRange(n, xMLNode, iBuffer);
        if (point != null) {
            String string = null;
            switch (n) {
                case 3: 
                case 100: {
                    n2 = 4;
                }
            }
            if (point.y > 0) {
                string = this.getSource(iBuffer, point);
            }
            if (string == null && point.y == 0) {
                string = "";
            }
            if (string != null) {
                BufferedScanner bufferedScanner = new BufferedScanner(n3);
                bufferedScanner.setSourceOffset(point.x);
                bufferedScanner.setSource(string.toCharArray());
                if (n2 != 0) {
                    bufferedScanner.flags |= n2;
                }
                bufferedScanner.prepare();
                return bufferedScanner;
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fModel.getPath();
    }

    public ScriptManager getManager() {
        Context context = this.getContext();
        return ScriptManager.getManager((int)(context == null ? Context.JS_1_6 : context.getSourceLevel()));
    }

    protected String getSource(IBuffer iBuffer, Point point) {
        if (point.y == 0) {
            return "";
        }
        return iBuffer.get(point.x, point.y);
    }

    protected PositionInfo getPosition() {
        if (this.fPosition == null) {
            this.fPosition = new PositionInfo();
            XMLUtils.findNode((XMLModel)this.fModel, (int)this.fOffset, (PositionInfo)this.fPosition);
        }
        return this.fPosition;
    }

    protected abstract boolean isScript();
}

