/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.util;

import com.spket.ui.internal.UIMessages;
import com.spket.ui.util.Message;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class CoreUtility {
    protected static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Job getBuildJob(IProject iProject) {
        BuildJob buildJob = new BuildJob(UIMessages.CoreUtility_job_title, iProject);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    private static final class BuildJob
    extends Job {
        private final IProject fProject;

        private BuildJob(String string, IProject iProject) {
            super(string);
            this.fProject = iProject;
        }

        public boolean isCoveredBy(BuildJob buildJob) {
            if (buildJob.fProject == null) {
                return true;
            }
            return this.fProject != null && this.fProject.equals(buildJob.fProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IStatus iStatus;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                iStatus = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                for (int i = 0; i < ((Job[])iStatus).length; ++i) {
                    BuildJob buildJob;
                    Job job = iStatus[i];
                    if (job == this || !(job instanceof BuildJob) || !(buildJob = (BuildJob)job).isCoveredBy(this)) continue;
                    job.cancel();
                }
            }
            try {
                if (this.fProject != null) {
                    iProgressMonitor.beginTask(Message.format(UIMessages.CoreUtility_buildproject_taskname, this.fProject.getName()), 2);
                    this.fProject.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    CoreUtility.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                } else {
                    iProgressMonitor.beginTask(UIMessages.CoreUtility_buildall_taskname, 2);
                    CoreUtility.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                }
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
                return iStatus;
            }
            catch (OperationCanceledException operationCanceledException) {
                iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            finally {
                iProgressMonitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
        }
    }
}

