/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.text.IConfigurable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;

public class SourcePreviewerUpdater {
    public SourcePreviewerUpdater(final SourceViewer sourceViewer, final IConfigurable iConfigurable, final IPreferenceStore iPreferenceStore) {
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.eclipse.jface.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
                    sourceViewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener iPropertyChangeListener2 = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (iConfigurable.affectsTextPresentation(propertyChangeEvent)) {
                    iConfigurable.changeConfiguration(propertyChangeEvent);
                    sourceViewer.invalidateTextPresentation();
                }
            }
        };
        sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                iPreferenceStore.removePropertyChangeListener(iPropertyChangeListener2);
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener2);
    }
}

