/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.text.IProblem;
import com.spket.ui.text.IProblemRequestor;
import com.spket.ui.text.ProblemAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ProblemAnnotationModel
extends ResourceMarkerAnnotationModel
implements IProblemRequestor {
    private List fCollectedProblems = new ArrayList();
    private List fGeneratedAnnotations = new ArrayList();

    public ProblemAnnotationModel(IResource iResource) {
        super(iResource);
    }

    public boolean isActive() {
        return true;
    }

    public void beginReporting() {
        if (this.fCollectedProblems.size() > 0) {
            this.fCollectedProblems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReporting(boolean bl) {
        if (bl) {
            if (this.fCollectedProblems.size() > 0) {
                this.fCollectedProblems.clear();
            }
            return;
        }
        boolean bl2 = false;
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.fGeneratedAnnotations.size() > 0) {
                bl2 = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                Iterator iterator = this.fCollectedProblems.iterator();
                while (iterator.hasNext()) {
                    IProblem iProblem = (IProblem)iterator.next();
                    if (iProblem.getOffset() < 0 || iProblem.getLength() < 0) continue;
                    Position position = new Position(iProblem.getOffset(), iProblem.getLength());
                    ProblemAnnotation problemAnnotation = new ProblemAnnotation(iProblem);
                    this.fGeneratedAnnotations.add(problemAnnotation);
                    try {
                        this.addAnnotation(problemAnnotation, position, false);
                    }
                    catch (BadLocationException badLocationException) {
                        UIPlugin.log(badLocationException);
                    }
                    bl2 = true;
                }
                this.fCollectedProblems.clear();
            }
        }
        if (bl2) {
            this.fireModelChanged();
        }
    }

    public void acceptProblem(IProblem iProblem) {
        this.fCollectedProblems.add(iProblem);
    }
}

