/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import com.spket.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CombinedWordRule
implements IRule {
    private static final int UNDEFINED = -1;
    private IWordDetector fDetector;
    private IToken fDefaultToken;
    private int fColumn = -1;
    private CharacterBuffer fBuffer = new CharacterBuffer(16);
    private List fMatchers = new ArrayList();

    public CombinedWordRule(IWordDetector iWordDetector) {
        this(iWordDetector, null, Token.UNDEFINED);
    }

    public CombinedWordRule(IWordDetector iWordDetector, IToken iToken) {
        this(iWordDetector, null, iToken);
    }

    public CombinedWordRule(IWordDetector iWordDetector, WordMatcher wordMatcher) {
        this(iWordDetector, wordMatcher, Token.UNDEFINED);
    }

    public CombinedWordRule(IWordDetector iWordDetector, WordMatcher wordMatcher, IToken iToken) {
        Assert.isNotNull((Object)iWordDetector);
        Assert.isNotNull((Object)iToken);
        this.fDetector = iWordDetector;
        this.fDefaultToken = iToken;
        if (wordMatcher != null) {
            this.addWordMatcher(wordMatcher);
        }
    }

    public void addWordMatcher(WordMatcher wordMatcher) {
        this.fMatchers.add(wordMatcher);
    }

    public void setColumnConstraint(int n) {
        if (n < 0) {
            n = -1;
        }
        this.fColumn = n;
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        int n = iCharacterScanner.read();
        if (this.fDetector.isWordStart((char)n) && (this.fColumn == -1 || this.fColumn == iCharacterScanner.getColumn() - 1)) {
            this.fBuffer.clear();
            do {
                this.fBuffer.append((char)n);
            } while ((n = iCharacterScanner.read()) != -1 && this.fDetector.isWordPart((char)n));
            iCharacterScanner.unread();
            int n2 = this.fMatchers.size();
            for (int i = 0; i < n2; ++i) {
                IToken iToken = ((WordMatcher)this.fMatchers.get(i)).evaluate(iCharacterScanner, this.fBuffer);
                if (iToken.isUndefined()) continue;
                return iToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }

    private void unreadBuffer(ICharacterScanner iCharacterScanner) {
        for (int i = this.fBuffer.length() - 1; i >= 0; --i) {
            iCharacterScanner.unread();
        }
    }

    public static class CharacterBuffer {
        private char[] fContent;
        private int fLength = 0;
        private boolean fIsHashCached = false;
        private int fHashCode;

        public CharacterBuffer(int n) {
            this.fContent = new char[n];
        }

        public CharacterBuffer(String string) {
            this.fContent = string.toCharArray();
            this.fLength = string.length();
        }

        public void clear() {
            this.fIsHashCached = false;
            this.fLength = 0;
        }

        public void append(char c) {
            this.fIsHashCached = false;
            if (this.fLength == this.fContent.length) {
                char[] cArray = this.fContent;
                this.fContent = new char[cArray.length << 1];
                System.arraycopy(cArray, 0, this.fContent, 0, cArray.length);
            }
            this.fContent[this.fLength++] = c;
        }

        public int length() {
            return this.fLength;
        }

        public String toString() {
            return new String(this.fContent, 0, this.fLength);
        }

        public char charAt(int n) {
            return this.fContent[n];
        }

        public int hashCode() {
            if (this.fIsHashCached) {
                return this.fHashCode;
            }
            int n = 0;
            int n2 = this.fLength;
            for (int i = 0; i < n2; ++i) {
                n = 29 * n + this.fContent[i];
            }
            this.fHashCode = n;
            this.fIsHashCached = true;
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CharacterBuffer)) {
                return false;
            }
            CharacterBuffer characterBuffer = (CharacterBuffer)object;
            int n = characterBuffer.length();
            if (n != this.fLength) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (characterBuffer.charAt(i) == this.fContent[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(String string) {
            int n = string.length();
            if (n != this.fLength) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) == this.fContent[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class WordMatcher {
        private Map fWords = new HashMap();

        public void addWord(String string, IToken iToken) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)iToken);
            this.fWords.put(new CharacterBuffer(string), iToken);
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner, CharacterBuffer characterBuffer) {
            IToken iToken = (IToken)this.fWords.get(characterBuffer);
            if (iToken != null) {
                return iToken;
            }
            return Token.UNDEFINED;
        }

        public void clearWords() {
            this.fWords.clear();
        }
    }
}

