/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;

public final class BufferedDocumentScanner
implements ICharacterScanner {
    private IDocument fDocument;
    private int fRangeOffset;
    private int fRangeLength;
    private char[][] fDelimiters;
    private final char[] fBuffer;
    private int fBufferOffset;
    private int fBufferLength;
    private int fOffset;

    public BufferedDocumentScanner(int n) {
        Assert.isTrue((n >= 1 ? 1 : 0) != 0);
        this.fBuffer = new char[n];
    }

    private final void updateBuffer(int n) {
        this.fBufferOffset = n;
        this.fBufferLength = this.fBufferOffset + this.fBuffer.length > this.fRangeOffset + this.fRangeLength ? this.fRangeLength - (this.fBufferOffset - this.fRangeOffset) : this.fBuffer.length;
        try {
            String string = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
            string.getChars(0, this.fBufferLength, this.fBuffer, 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public final void setRange(IDocument iDocument, int n, int n2) {
        this.fDocument = iDocument;
        this.fRangeOffset = n;
        this.fRangeLength = n2;
        String[] stringArray = iDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fDelimiters[i] = stringArray[i].toCharArray();
        }
        this.updateBuffer(n);
        this.fOffset = 0;
    }

    public final int read() {
        if (this.fOffset == this.fBufferLength) {
            int n = this.fBufferOffset + this.fBufferLength;
            if (n == this.fDocument.getLength() || n == this.fRangeOffset + this.fRangeLength) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        return this.fBuffer[this.fOffset++];
    }

    public final void unread() {
        if (this.fOffset == 0) {
            if (this.fBufferOffset != this.fRangeOffset) {
                this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                this.fOffset = this.fBuffer.length - 1;
            }
        } else {
            --this.fOffset;
        }
    }

    public final int getColumn() {
        try {
            int n = this.fBufferOffset + this.fOffset;
            int n2 = this.fDocument.getLineOfOffset(n);
            int n3 = this.fDocument.getLineOffset(n2);
            return n - n3;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public final char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }

    public int getOffset() {
        return this.fBufferOffset + this.fOffset;
    }

    public int peekChar() {
        if (this.fOffset == this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength == this.fDocument.getLength()) {
                return -1;
            }
            try {
                return this.fDocument.getChar(this.fBufferOffset + this.fBufferLength);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return this.fBuffer[this.fOffset];
    }

    public int scanChar() {
        if (this.fOffset == this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength == this.fDocument.getLength()) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        return this.fBuffer[this.fOffset++];
    }

    public int getChar(int n) {
        if (n >= this.fBufferOffset && n < this.fBufferOffset + this.fBufferLength) {
            char c = this.fBuffer[n - this.fBufferOffset];
            return c;
        }
        if (n >= 0 && n < this.fDocument.getLength()) {
            try {
                return this.fDocument.getChar(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean skipChar(char c) {
        int n = this.peekChar();
        if (n == c) {
            this.read();
            return true;
        }
        return false;
    }

    public boolean skipString(String string) {
        int n = string.length();
        if (this.fOffset + n >= this.fBufferLength) {
            if (this.fBufferOffset + this.fOffset + n < this.fDocument.getLength()) {
                this.updateBuffer(this.fBufferOffset + this.fOffset);
                this.fOffset = 0;
            } else {
                return false;
            }
        }
        if (this.fOffset + n < this.fBufferLength) {
            int n2 = this.fOffset;
            for (int i = 0; i < n; ++i) {
                if (this.fBuffer[n2++] == string.charAt(i)) continue;
                return false;
            }
            this.fOffset += n;
        }
        return true;
    }

    public boolean startsWith(int n, String string) {
        int n2 = string.length();
        if (n < 0 || n2 == 0 || n + n2 > this.fDocument.getLength()) {
            return false;
        }
        if (n >= this.fBufferOffset && n + n2 < this.fBufferOffset + this.fBufferLength) {
            n -= this.fBufferOffset;
            for (int i = 0; i < n2; ++i) {
                if (this.fBuffer[n++] == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        try {
            String string2 = this.fDocument.get(n, n2);
            return string.equals(string2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public String get(int n, int n2) {
        if (n < 0 || n2 == 0 || n + n2 > this.fDocument.getLength()) {
            return null;
        }
        if (n >= this.fBufferOffset && n + n2 < this.fBufferOffset + this.fBufferLength) {
            return new String(this.fBuffer, n - this.fBufferOffset, n2);
        }
        try {
            return this.fDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

