/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.tasks;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.tasks.ITaskScanner;
import com.spket.ui.tasks.Options;
import com.spket.ui.tasks.Task;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class TaskJob
extends Job {
    private static final String SCANNER_EXTENSIONS = "com.spket.ui.taskScanner";
    private static final String A_class = "class";
    private static final String A_contentType = "contentType";
    private static final String A_extensions = "extensions";
    private static Map gScanners;
    private List fResources;
    protected final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];

    private static Map loadScanners() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(SCANNER_EXTENSIONS);
        if (iConfigurationElementArray.length > 0) {
            HashMap<Key, ITaskScanner> hashMap = new HashMap<Key, ITaskScanner>();
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                ITaskScanner iTaskScanner = null;
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                try {
                    iTaskScanner = (ITaskScanner)iConfigurationElement.createExecutableExtension(A_class);
                }
                catch (CoreException coreException) {
                    UIPlugin.log(coreException.getStatus());
                }
                catch (ClassCastException classCastException) {
                    UIPlugin.log(classCastException);
                }
                if (iTaskScanner == null) continue;
                String string = StringUtils.makeNullIfEmpty((String)iConfigurationElement.getAttribute(A_contentType));
                String[] stringArray = StringUtils.split((String)iConfigurationElement.getAttribute(A_extensions), (char)',', (boolean)false);
                if (string == null && stringArray.length == 0) {
                    UIPlugin.logErrorMessage(iTaskScanner.getClass().getName());
                    continue;
                }
                if (stringArray.length == 0) {
                    hashMap.put(new Key(string, null), iTaskScanner);
                    continue;
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    hashMap.put(new Key(string, stringArray[j]), iTaskScanner);
                }
            }
            return hashMap;
        }
        return Collections.EMPTY_MAP;
    }

    private static IProgressMonitor subMonitorFor(IProgressMonitor iProgressMonitor, int n, int n2) {
        if (iProgressMonitor == null) {
            return new NullProgressMonitor();
        }
        if (iProgressMonitor instanceof NullProgressMonitor) {
            return iProgressMonitor;
        }
        return new SubProgressMonitor(iProgressMonitor, n, n2);
    }

    private static void removeTasksFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("com.spket.ui.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public TaskJob() {
        this(null);
    }

    public TaskJob(List list) {
        super("Task Scanner");
        this.setSystem(true);
        this.setPriority(50);
        this.fResources = list == null || list.size() == 0 ? new ArrayList() : new ArrayList(list);
        this.preferencesLookup[0] = new InstanceScope().getNode("com.spket.ui");
        this.preferencesLookup[1] = new DefaultScope().getNode("com.spket.ui");
        if (gScanners == null && ((gScanners = TaskJob.loadScanners()) == null || gScanners.isEmpty())) {
            gScanners = Collections.EMPTY_MAP;
        }
    }

    public synchronized void scan(Collection collection) {
        if (gScanners.isEmpty()) {
            return;
        }
        if (collection != null && collection.size() > 0) {
            this.fResources.addAll(collection);
            this.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        Object object;
        IResource[] iResourceArray = null;
        if (this.fResources != null) {
            object = this.fResources;
            synchronized (object) {
                if (this.fResources.size() > 0) {
                    iResourceArray = new IResource[this.fResources.size()];
                    this.fResources.toArray(iResourceArray);
                }
                this.fResources.clear();
            }
        }
        if (iResourceArray == null || iResourceArray.length == 0) {
            return Status.OK_STATUS;
        }
        object = null;
        if (iResourceArray.length > 1 && (iResourceArray = this.filter(iResourceArray)).length > 1) {
            object = new HashMap();
        }
        iProgressMonitor.beginTask("", iResourceArray.length);
        try {
            for (int i = 0; i < iResourceArray.length; ++i) {
                IStatus iStatus;
                if (iProgressMonitor.isCanceled()) {
                    iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                iStatus = iResourceArray[i];
                Options options = this.getOptions((Map)object, (IResource)iStatus);
                try {
                    this.process((IResource)iStatus, options, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    Debug.debug((Throwable)coreException);
                }
                iProgressMonitor.worked(1);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return Status.OK_STATUS;
    }

    protected IResource[] filter(IResource[] iResourceArray) {
        LinkedHashSet<IResource> linkedHashSet = new LinkedHashSet<IResource>();
        for (int i = 0; i < iResourceArray.length; ++i) {
            linkedHashSet.add(iResourceArray[i]);
        }
        if (linkedHashSet.size() > 1) {
            ArrayList<IResource> arrayList = new ArrayList<IResource>(linkedHashSet.size());
            for (int i = 0; i < iResourceArray.length; ++i) {
                boolean bl = true;
                for (IContainer iContainer = iResourceArray[i].getParent(); iContainer != null && 8 != iContainer.getType(); iContainer = iContainer.getParent()) {
                    if (!linkedHashSet.contains(iContainer)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(iResourceArray[i]);
            }
            iResourceArray = new IResource[arrayList.size()];
            arrayList.toArray(iResourceArray);
            return iResourceArray;
        }
        if (linkedHashSet.size() != iResourceArray.length) {
            iResourceArray = new IResource[linkedHashSet.size()];
            linkedHashSet.toArray(iResourceArray);
            return iResourceArray;
        }
        return iResourceArray;
    }

    protected Options getOptions(Map map, IResource iResource) {
        Boolean bl = null;
        Options options = null;
        IProject iProject = iResource.getProject();
        if (map != null) {
            bl = iProject == null ? Boolean.TRUE : iProject;
            options = (Options)map.get(bl);
        }
        if (options == null) {
            options = new Options();
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            String string = iPreferencesService.get("spket.taskTags", null, (Preferences[])this.preferencesLookup);
            if (string != null) {
                options.taskTags = StringUtils.splitAndTrimOn((char)',', (char[])string.toCharArray());
            }
            if ((string = iPreferencesService.get("spket.taskPriorities", null, (Preferences[])this.preferencesLookup)) != null) {
                options.taskPriorities = StringUtils.splitAndTrimOn((char)',', (char[])string.toCharArray());
            }
            if ("disabled".equals(string = iPreferencesService.get("spket.taskCaseSensitive", null, (Preferences[])this.preferencesLookup))) {
                options.isTaskCaseSensitive = false;
            }
            if (iProject != null) {
                IEclipsePreferences iEclipsePreferences = new ProjectScope(iProject).getNode("com.spket.ui");
                string = iEclipsePreferences.get("spket.taskTags", null);
                if (string != null) {
                    options.taskTags = StringUtils.splitAndTrimOn((char)',', (char[])string.toCharArray());
                }
                if ((string = iEclipsePreferences.get("spket.taskPriorities", null)) != null) {
                    options.taskPriorities = StringUtils.splitAndTrimOn((char)',', (char[])string.toCharArray());
                }
                if ("disabled".equals(string = iEclipsePreferences.get("spket.taskCaseSensitive", null))) {
                    options.isTaskCaseSensitive = false;
                }
            }
            if (map != null) {
                map.put(bl, options);
            }
        }
        return options;
    }

    protected void process(IFile iFile, Options options) throws CoreException {
        ITaskScanner iTaskScanner = this.getTaskScanner(iFile);
        if (iTaskScanner != null) {
            TaskJob.removeTasksFor((IResource)iFile);
            if (options.taskTags == null || options.taskTags.length == 0) {
                return;
            }
            Task[] taskArray = iTaskScanner.scan(iFile, options);
            if (taskArray != null) {
                for (int i = 0; i < taskArray.length; ++i) {
                    int n = 0;
                    Task task = taskArray[i];
                    Object[] objectArray = new Object[Task.TASK_MARKER_ATTRS.length];
                    objectArray[n++] = task.getMessage();
                    objectArray[n++] = task.getPriority();
                    objectArray[n++] = new Integer(task.getID());
                    objectArray[n++] = new Integer(task.getSourceStart());
                    objectArray[n++] = new Integer(task.getSourceEnd() + 1);
                    objectArray[n++] = new Integer(task.getSourceLineNumber());
                    objectArray[n++] = Boolean.FALSE;
                    objectArray[n++] = "spket";
                    try {
                        IMarker iMarker = iFile.createMarker("com.spket.ui.task");
                        iMarker.setAttributes(Task.TASK_MARKER_ATTRS, objectArray);
                        continue;
                    }
                    catch (CoreException coreException) {
                        Debug.debug((Throwable)coreException);
                    }
                }
            }
        }
    }

    protected void process(IResource iResource, Options options, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iResource.isAccessible()) {
            if (iResource.getType() == 1) {
                this.process((IFile)iResource, options);
            } else {
                IResource[] iResourceArray;
                if (iResource.getType() == 2 && (iResourceArray = iResource.getName()).length() > 0 && iResourceArray.charAt(0) == '.') {
                    return;
                }
                iResourceArray = ((IContainer)iResource).members();
                if (iResourceArray != null && iResourceArray.length > 0) {
                    iProgressMonitor = TaskJob.subMonitorFor(iProgressMonitor, iResourceArray.length, 4);
                    iProgressMonitor.beginTask(iResource.getName(), iResourceArray.length);
                    for (int i = 0; i < iResourceArray.length && !iProgressMonitor.isCanceled(); ++i) {
                        this.process(iResourceArray[i], options, iProgressMonitor);
                        iProgressMonitor.worked(1);
                    }
                    iProgressMonitor.done();
                }
            }
        }
    }

    protected ITaskScanner getTaskScanner(IFile iFile) {
        Object object;
        String string = iFile.getFileExtension();
        IContentType[] iContentTypeArray = this.getContentTypes(iFile);
        if (iContentTypeArray != null && iContentTypeArray.length > 0) {
            for (int i = 0; i < iContentTypeArray.length; ++i) {
                object = new Key(iContentTypeArray[i].getId(), string);
                ITaskScanner iTaskScanner = (ITaskScanner)gScanners.get(object);
                if (iTaskScanner == null) continue;
                return iTaskScanner;
            }
        }
        if (string != null) {
            Key key = new Key(null, string);
            object = (ITaskScanner)gScanners.get(key);
            if (object == null && iContentTypeArray != null && iContentTypeArray.length > 0) {
                for (int i = 0; i < iContentTypeArray.length && (object = (ITaskScanner)gScanners.get(key = new Key(iContentTypeArray[i].getId(), null))) == null; ++i) {
                }
            }
            return object;
        }
        return null;
    }

    protected IContentType[] getContentTypes(IFile iFile) {
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(iFile.getName());
        if (iContentTypeArray == null || iContentTypeArray.length == 0) {
            IContentDescription iContentDescription = null;
            try {
                IContentType iContentType;
                iContentDescription = iFile.getContentDescription();
                if (iContentDescription != null && (iContentType = iContentDescription.getContentType()) != null) {
                    iContentTypeArray = new IContentType[]{iContentType};
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return iContentTypeArray;
    }

    private static final class Key {
        private String contentType;
        private String extension;

        public Key(String string, String string2) {
            this.contentType = string;
            this.extension = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key = (Key)object;
                return StringUtils.equals((Object)this.contentType, (Object)key.contentType) && StringUtils.equals((Object)this.extension, (Object)key.extension);
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            if (this.contentType != null) {
                n = this.contentType.hashCode() << 16;
            }
            if (this.extension != null) {
                n |= this.extension.hashCode();
            }
            return n;
        }
    }
}

