/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.properties;

import com.spket.ui.internal.UIImages;
import com.spket.ui.properties.CategoriesAction;
import com.spket.ui.properties.IPropertyListener;
import com.spket.ui.properties.PropertySheetViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.PropertiesMessages;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class PropertySheetPage
extends Page
implements IPropertySheetPage {
    private Control fControl;
    private CategoriesAction categoriesAction;
    protected PropertySheetViewer fViewer = new PropertySheetViewer(0);

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        if (this.fViewer != null) {
            this.fViewer.addPropertyListener(iPropertyListener);
        }
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        if (this.fViewer != null) {
            this.fViewer.removePropertyListener(iPropertyListener);
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (this.fViewer == null) {
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            this.fViewer.setInputs(((IStructuredSelection)iSelection).toArray());
        }
    }

    public void createControl(Composite composite) {
        this.fViewer.setSort(3);
        this.fControl = this.fViewer.createControl(composite);
        this.makeActions();
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fViewer != null) {
            this.fViewer.dispose();
            this.fViewer = null;
        }
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
        iToolBarManager.add((IAction)this.categoriesAction);
        iMenuManager.add((IAction)this.categoriesAction);
    }

    protected void makeActions() {
        this.categoriesAction = new CategoriesAction(this.fViewer, "categories");
        this.categoriesAction.setText(PropertiesMessages.Categories_text);
        this.categoriesAction.setToolTipText(PropertiesMessages.Categories_toolTip);
        this.categoriesAction.setImageDescriptor(UIImages.getImageDescriptor("com.spket.ui", 2, "tree_mode.gif"));
        this.categoriesAction.setChecked(this.fViewer.isShowCategories());
    }
}

