/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.preferences;

import com.spket.ui.internal.UIPlugin;
import com.spket.ui.preferences.PrefMessages;
import com.spket.ui.util.StatusInfo;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer fTableViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public ProjectSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(PrefMessages.ProjectSelectionDialog_title);
        this.setMessage(PrefMessages.ProjectSelectionDialog_desciption);
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Font font = composite.getFont();
        composite2.setFont(font);
        this.createMessageArea(composite2);
        this.fTableViewer = new TableViewer(composite2, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)selectionChangedEvent.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), UIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return ((IWorkspace)object).getRoot().getProjects();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.fTableViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        this.fTableViewer.getControl().setFont(font);
        this.fTableViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void doSelectionChanged(Object[] objectArray) {
        if (objectArray.length != 1) {
            this.updateStatus(new StatusInfo(4, "com.spket.ui", ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objectArray);
        }
    }

    protected void computeResult() {
    }
}

