/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.part;

import com.spket.ui.part.IPart;
import com.spket.ui.part.PartForm;
import com.spket.widget.UIUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PartPane {
    protected static final IPart[] EMPTY_CHILDREN = new IPart[0];
    protected static final int DEFAULT_WIDTH = 64;
    protected static final int DEFAULT_HEIGHT = 64;
    protected static final int MIN_TAB_WIDTH = 3;
    protected static final int IMAGE_SIZE = 16;
    protected PartForm fSite;
    protected int fX;
    protected int fY;
    protected int fWidth;
    protected int fHeight;
    protected IPart[] fChildren = EMPTY_CHILDREN;
    protected Rectangle[] fTabSizes;
    protected int fChildrenCount;
    protected boolean fActived;
    protected boolean fShowTitle;
    protected boolean fVisible;
    protected int fTabPosition;
    protected int fSelectedIndex = -1;
    protected TraceListener fTraceListener = new TraceListener();

    public PartPane(PartForm partForm, boolean bl) {
        this.fSite = partForm;
        this.fShowTitle = bl;
        this.fTabPosition = 1024;
    }

    public void add(IPart iPart, IPart iPart2, int n) {
        this.fTabSizes = null;
        if (n == 5 || n == 6) {
            for (int i = 0; i < this.fChildrenCount; ++i) {
                if (this.fChildren[i] != iPart2) continue;
                if (n == 5) {
                    ++i;
                }
                this.add(iPart, i);
                break;
            }
        } else {
            this.add(iPart);
        }
    }

    public void add(IPart iPart) {
        this.add(iPart, this.fChildrenCount);
    }

    protected void add(IPart iPart, int n) {
        if (n < 0 || n > this.fChildrenCount) {
            return;
        }
        this.fTabSizes = null;
        this.ensureSize(this.fChildrenCount + 1);
        if (n < this.fChildrenCount) {
            System.arraycopy(this.fChildren, n, this.fChildren, n + 1, this.fChildrenCount - n);
        }
        this.fChildren[n] = iPart;
        ++this.fChildrenCount;
        Control control = iPart.getControl();
        if (UIUtils.okToUse((Widget)control)) {
            control.setVisible(false);
        }
        this.startTracePart(iPart);
        this.layout();
    }

    public void removeAll() {
        for (int i = 0; i < this.fChildrenCount; ++i) {
            IPart iPart = this.fChildren[i];
            this.stopTracePart(iPart);
            this.fChildren[i] = null;
        }
        this.fTabSizes = null;
        this.fSelectedIndex = -1;
        this.fChildrenCount = 0;
        this.fChildren = EMPTY_CHILDREN;
    }

    public IPart remove(int n) {
        if (n < 0 || n >= this.fChildrenCount) {
            return null;
        }
        IPart iPart = this.fChildren[n];
        this.stopTracePart(iPart);
        int n2 = this.fChildrenCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.fChildren, n + 1, this.fChildren, n, n2);
        }
        this.fChildren[--this.fChildrenCount] = null;
        boolean bl = true;
        if (this.fSelectedIndex == n) {
            Control control = iPart.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            int n3 = this.fSelectedIndex;
            this.fSelectedIndex = -1;
            if (n3 >= this.fChildrenCount) {
                n3 = this.fChildrenCount - 1;
            }
            if (n3 != -1) {
                this.fTabSizes = null;
                this.setSelection(n3, true);
                bl = false;
            } else {
                this.layout();
            }
        } else if (this.fSelectedIndex > n) {
            --this.fSelectedIndex;
        }
        if (bl) {
            this.fTabSizes = null;
            this.redraw();
        }
        return iPart;
    }

    public IPart remove(IPart iPart) {
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i] != iPart) continue;
            return this.remove(i);
        }
        return null;
    }

    public boolean contains(IPart iPart) {
        boolean bl = false;
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (this.fChildren[i] != iPart) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = 64;
        int n4 = 64;
        for (int i = 0; i < this.fChildrenCount; ++i) {
            Control control = this.fChildren[i].getControl();
            if (!UIUtils.okToUse((Widget)control)) continue;
            Point point = control.computeSize(n, n2, bl);
            if (n3 < point.x) {
                n3 = point.x;
            }
            if (n4 >= point.y) continue;
            n4 = point.y;
        }
        n4 += this.getTitleHeight() + this.getTabHeight();
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    protected void redraw() {
        this.fSite.redraw(this.fX, this.fY, this.fWidth, this.fHeight, false);
    }

    protected void redrawTabs() {
        if (this.showTab()) {
            int n = this.fY;
            int n2 = this.getTabHeight();
            if (this.fTabPosition != 128) {
                n = this.fY + this.fHeight - n2 - 2;
                ++n2;
            }
            this.fSite.redraw(this.fX, n, this.fWidth, n2, false);
        } else {
            this.redraw();
        }
    }

    protected void redrawTitle() {
        if (this.fShowTitle) {
            int n = this.fY;
            int n2 = this.getTitleHeight();
            if (this.fTabPosition == 128) {
                n = this.fY + this.fHeight - n2 - 2;
                ++n2;
            }
            this.fSite.redraw(this.fX, n, this.fWidth, n2, false);
        }
    }

    public void layout() {
        this.fTabSizes = null;
        if (this.fChildrenCount == 0) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        for (int i = 0; i < this.fChildrenCount; ++i) {
            Control control = this.fChildren[i].getControl();
            if (!UIUtils.okToUse((Widget)control)) continue;
            control.setBounds(rectangle);
        }
    }

    public String getTitle() {
        String string = null;
        if (this.fSelectedIndex >= 0 && this.fSelectedIndex < this.fChildrenCount) {
            string = this.fChildren[this.fSelectedIndex].getTitle();
        }
        return string;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.fX, this.fY, this.fWidth, this.fHeight);
    }

    public IPart getSelection() {
        return this.fSelectedIndex >= 0 && this.fSelectedIndex < this.fChildrenCount ? this.fChildren[this.fSelectedIndex] : null;
    }

    public void showPart(IPart iPart, boolean bl) {
        if (iPart == null) {
            return;
        }
        for (int i = 0; i < this.fChildrenCount; ++i) {
            if (iPart != this.fChildren[i]) continue;
            this.setSelection(i, bl);
            if (!bl) break;
            this.fChildren[i].setFocus();
            break;
        }
    }

    public void setShowTitle(boolean bl) {
        if (this.fShowTitle != bl) {
            this.fShowTitle = bl;
            this.layout();
        }
    }

    public Rectangle getClientArea() {
        int n = this.fX;
        int n2 = this.fY + 1;
        int n3 = this.fWidth;
        int n4 = this.fHeight - 2;
        if (this.fTabPosition != 128 && this.fShowTitle) {
            n2 += this.getTitleHeight();
        }
        if (this.fShowTitle) {
            n4 -= this.getTitleHeight();
        }
        if (this.showTab()) {
            if (this.fTabPosition == 128) {
                n2 += this.getTabHeight();
            }
            n4 -= this.getTabHeight();
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n != this.fX || n2 != this.fY || n3 != this.fWidth || n4 != this.fHeight) {
            this.fX = n;
            this.fY = n2;
            this.fWidth = n3;
            this.fHeight = n4;
            this.layout();
        }
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setVisible(boolean bl) {
        if (this.fVisible != bl) {
            this.fVisible = bl;
            if (UIUtils.okToUse((Widget)this.fSite)) {
                this.fSite.layout();
            }
        }
    }

    public boolean isFocused() {
        return this.fActived;
    }

    public void setFocused(boolean bl) {
        if (this.fActived == bl) {
            return;
        }
        this.fActived = bl;
        this.redrawTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelection(int n, boolean bl) {
        Shell shell;
        if (this.fSelectedIndex == n) {
            return;
        }
        if (n < 0 || n > this.fChildrenCount) {
            return;
        }
        int n2 = this.fSelectedIndex;
        this.fSelectedIndex = n;
        Control control = this.fChildren[n].getControl();
        if (control == null) {
            shell = this.fSite.getShell();
            Display display = this.fSite.getDisplay();
            shell.setCursor(display.getSystemCursor(1));
            try {
                this.fChildren[n].createPartControl(this.fSite);
                control = this.fChildren[n].getControl();
                if (UIUtils.okToUse((Widget)control)) {
                    this.traceActivation(control);
                    if (control instanceof Composite) {
                        ((Composite)control).layout(true);
                    }
                }
            }
            finally {
                shell.setCursor(null);
            }
        }
        if (UIUtils.okToUse((Widget)control)) {
            shell = this.getClientArea();
            control.setBounds((Rectangle)shell);
            control.setVisible(true);
        }
        if (n2 != -1 && UIUtils.okToUse((Widget)(control = this.fChildren[n2].getControl()))) {
            control.setVisible(false);
        }
        if (bl) {
            this.onActivateChanged(new Event());
        }
        this.redraw();
    }

    protected void ensureSize(int n) {
        if (n > this.fChildren.length) {
            IPart[] iPartArray = new IPart[this.fChildrenCount + 2];
            System.arraycopy(this.fChildren, 0, iPartArray, 0, this.fChildrenCount);
            this.fChildren = iPartArray;
        }
    }

    protected int getTabIndexAt(int n, int n2) {
        if (this.showTab() && this.fTabSizes != null) {
            int n3 = this.fY + this.fHeight;
            int n4 = n3 - this.getTabHeight();
            if (this.fTabPosition == 128) {
                n4 = this.fY;
                n3 = n4 + this.getTabHeight();
            }
            if (n2 < n4 || n2 > n3) {
                return -1;
            }
            for (int i = 0; i < this.fChildrenCount; ++i) {
                Rectangle rectangle = this.fTabSizes[i];
                if (rectangle == null || rectangle.y == 0 || n <= rectangle.x || n >= rectangle.x + rectangle.y) continue;
                return i;
            }
        }
        return -1;
    }

    protected boolean onMouseDown(Event event) {
        int n = this.getTabIndexAt(event.x, event.y);
        if (n != -1 && this.fSelectedIndex != n) {
            this.setSelection(n, true);
            return true;
        }
        return false;
    }

    protected String getToolTipAt(int n, int n2) {
        int n3 = this.getTabIndexAt(n, n2);
        if (n3 >= 0 && n3 < this.fChildrenCount) {
            String string = this.fChildren[n3].getTitleToolTip();
            if (string == null && this.fTabSizes != null && this.fTabSizes[n3].width == -1) {
                string = this.fChildren[n3].getTitle();
            }
            return string;
        }
        return null;
    }

    protected void startTracePart(IPart iPart) {
        if (this.fTraceListener != null) {
            iPart.addPropertyChangeListener(this.fTraceListener);
            this.traceActivation(iPart.getControl());
        }
    }

    protected void traceActivation(Control control) {
        if (control != null && !control.isDisposed()) {
            control.addListener(26, (Listener)this.fTraceListener);
        }
    }

    protected void stopTracePart(IPart iPart) {
        if (this.fTraceListener != null) {
            iPart.removePropertyChangeListener(this.fTraceListener);
            Control control = iPart.getControl();
            if (control != null && !control.isDisposed()) {
                control.removeListener(26, (Listener)this.fTraceListener);
            }
        }
    }

    protected void onActivateChanged(Event event) {
        if (this.fSite != null) {
            IPart iPart = null;
            if (this.fSelectedIndex >= 0 && this.fSelectedIndex < this.fChildrenCount) {
                iPart = this.fChildren[this.fSelectedIndex];
            }
            this.fSite.requestActivation(this, iPart);
        }
    }

    protected void onPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fTabSizes = null;
        this.redrawTabs();
    }

    protected boolean showTab() {
        return this.fChildrenCount > 0 && (this.alwaysShowTab() || this.fChildrenCount > 1);
    }

    protected boolean alwaysShowTab() {
        return false;
    }

    protected int getTabHeight() {
        return this.fSite.tabHeight;
    }

    protected int getTitleHeight() {
        return this.fSite.titleHeight;
    }

    protected void paint(GC gC) {
        int n = this.fX;
        int n2 = this.fY;
        int n3 = this.fWidth;
        int n4 = this.fHeight;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Color color = gC.getForeground();
        if (this.fChildrenCount > 0) {
            Color color2 = gC.getBackground();
            if (this.fShowTitle) {
                if (this.fTabPosition == 128) {
                    n2 = n2 + n4 - this.getTitleHeight();
                }
                this.paintTitle(gC, n, n2, n3, this.getTitleHeight(), color);
            }
            if (this.showTab()) {
                n2 = this.fTabPosition == 128 ? this.fY : this.fY + n4 - this.getTabHeight();
                this.paintTabs(gC, n, n2, n3, this.getTabHeight(), color2, color);
            }
            gC.setBackground(color2);
        } else if (n3 > 2 && n4 > 2) {
            gC.setForeground(this.fSite.borderColor);
            gC.drawRectangle(n + 1, n2 + 1, n3 - 2, n4 - 2);
        }
        gC.setForeground(color);
    }

    protected void paintTitle(GC gC, int n, int n2, int n3, int n4, Color color) {
        if (n3 > 2) {
            if (this.isFocused()) {
                gC.setBackground(this.fSite.titleBgColor);
                gC.fillRectangle(n, n2, n3, n4);
            } else {
                gC.setForeground(this.fSite.borderColor);
                int n5 = n + n3 - 2;
                int n6 = ++n2 + n4 - 3;
                gC.drawLine(n + 1, n2, n5, n2);
                gC.drawLine(n + 1, n6 + 1, n5, n6 + 1);
                gC.drawLine(n, n2 + 1, n, n6);
                gC.drawLine(n5 + 1, n2 + 1, n5 + 1, n6);
            }
            String string = this.getTitle();
            if (string != null) {
                string = UIUtils.shortenText((GC)gC, (String)string, (int)(n3 - 6));
                gC.setForeground(this.isFocused() ? this.fSite.titleColor : color);
                gC.drawString(string, n + 5, n2 + 2);
            }
        }
    }

    protected void calcItemBounds() {
        if (this.fTabSizes != null || !this.showTab()) {
            return;
        }
        GC gC = new GC((Drawable)this.fSite);
        this.calcItemBounds(gC);
        gC.dispose();
    }

    protected void calcItemBounds(GC gC) {
        int n;
        int n2;
        int n3;
        if (this.fTabSizes != null || !this.showTab()) {
            return;
        }
        this.fTabSizes = new Rectangle[this.fChildrenCount];
        for (n3 = 0; n3 < this.fChildrenCount; ++n3) {
            Rectangle rectangle;
            this.fTabSizes[n3] = rectangle = new Rectangle(0, 0, 0, 0);
            String string = this.fChildren[n3].getTitle();
            if (string != null) {
                rectangle.y = gC.stringExtent((String)string).x;
            }
            if (this.fChildren[n3].getImage() != null) {
                rectangle.y += 18;
            }
            rectangle.y += 6;
        }
        n3 = 0;
        int n4 = this.fWidth - 4 - 4;
        int n5 = n4 / this.fChildrenCount;
        while (n5 > n3) {
            n2 = this.fChildrenCount;
            n4 = this.fWidth - 4 - 4;
            for (n = 0; n < this.fChildrenCount; ++n) {
                if (this.fTabSizes[n].y >= n5) continue;
                n4 -= this.fTabSizes[n].y;
                --n2;
            }
            n3 = n5;
            if (n2 <= 0) continue;
            n5 = n4 / n2;
        }
        n2 = this.fX + 4;
        if (n5 < 3) {
            n5 = 0;
        }
        for (n = 0; n < this.fChildrenCount; ++n) {
            this.fTabSizes[n].x = n2;
            if (this.fTabSizes[n].y > n5) {
                this.fTabSizes[n].y = n5;
            }
            n2 += this.fTabSizes[n].y;
        }
    }

    protected void paintTabs(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setBackground(this.fSite.tabBackgroundColor);
        gC.fillRectangle(n, n2, n3, n4);
        if (this.fTabPosition == 128) {
            gC.setForeground(color);
            gC.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        } else {
            gC.setForeground(this.fSite.borderDarkColor);
            gC.drawLine(n, n2, n + n3, n2);
        }
        this.calcItemBounds(gC);
        Rectangle rectangle = gC.getClipping();
        for (int i = 0; i < this.fChildrenCount; ++i) {
            Rectangle rectangle2 = this.fTabSizes[i];
            if (rectangle2 == null || rectangle2.y == 0) continue;
            gC.setClipping(rectangle2.x, n2, rectangle2.y + 1, n4);
            boolean bl = this.paintTab(gC, rectangle2.x, n2, rectangle2.y, n4, i, color, color2);
            if (!bl) continue;
            rectangle2.width = -1;
        }
        gC.setClipping(rectangle);
    }

    protected boolean paintTab(GC gC, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6;
        boolean bl = true;
        int n7 = n4 - 2;
        if (this.fTabPosition == 128) {
            ++n2;
        }
        if (n5 == this.fSelectedIndex) {
            int n8 = n;
            gC.setBackground(color);
            gC.fillRectangle(n8, n2, n3, n7);
            gC.setForeground(this.fSite.borderDarkColor);
            int n9 = n2 + n7;
            n6 = n8 + n3;
            if (this.fTabPosition != 128) {
                gC.drawLine(n8, n9, n6, n9);
            }
            gC.drawLine(n6, n2, n6, n9);
            gC.setForeground(this.fSite.borderLightColor);
            gC.drawLine(n8, n2, n8, n9);
            if (this.fTabPosition == 128) {
                gC.drawLine(n8, n2, n6, n2);
            }
        } else {
            gC.setForeground(this.fSite.borderDarkColor);
            gC.drawLine(n + n3, n2 + 3, n + n3, n2 + n7 - 2);
        }
        n += 2;
        n2 += 2;
        String string = this.fChildren[n5].getTitle();
        Image image = this.fChildren[n5].getImage();
        int n10 = n6 = image != null ? 16 : 2;
        if (n3 > n6) {
            if (image != null) {
                Rectangle rectangle = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n, n2 + 1, 16, 16);
                n += 16;
            }
            n += 2;
            if (string != null) {
                String string2;
                int n11 = 4;
                if (image != null) {
                    n11 += 2;
                }
                bl = (string2 = UIUtils.shortenText((GC)gC, (String)string, (int)(n3 - n6 - n11))) != string;
                gC.setForeground(n5 == this.fSelectedIndex ? color2 : this.fSite.borderDarkColor);
                gC.drawString(string2, n, n2 + 2, true);
            }
        }
        return bl;
    }

    private final class TraceListener
    implements Listener,
    IPropertyChangeListener {
        private TraceListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    PartPane.this.onActivateChanged(event);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PartPane.this.onPropertyChange(propertyChangeEvent);
        }
    }
}

