/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.internal.dialogfields;

import com.spket.ui.internal.dialogfields.DialogField;
import com.spket.ui.internal.dialogfields.ITreeListAdapter;
import com.spket.ui.util.PixelConverter;
import com.spket.ui.util.SWTUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class TreeListDialogField
extends DialogField {
    protected TreeViewer fTree;
    protected ILabelProvider fLabelProvider;
    protected TreeViewerAdapter fTreeViewerAdapter;
    protected List fElements;
    protected ViewerComparator fViewerComparator;
    protected String[] fButtonLabels;
    private Button[] fButtonControls;
    private boolean[] fButtonsEnabled;
    private int fRemoveButtonIndex;
    private int fUpButtonIndex;
    private int fDownButtonIndex;
    private Label fLastSeparator;
    private Tree fTreeControl;
    private Composite fButtonsControl;
    private ISelection fSelectionWhenEnabled;
    private ITreeListAdapter fTreeAdapter;
    private Object fParentElement;
    private int fTreeExpandLevel;

    public TreeListDialogField(ITreeListAdapter iTreeListAdapter, String[] stringArray, ILabelProvider iLabelProvider) {
        this.fTreeAdapter = iTreeListAdapter;
        this.fLabelProvider = iLabelProvider;
        this.fTreeViewerAdapter = new TreeViewerAdapter();
        this.fParentElement = this;
        this.fElements = new ArrayList(10);
        this.fButtonLabels = stringArray;
        if (this.fButtonLabels != null) {
            int n = this.fButtonLabels.length;
            this.fButtonsEnabled = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.fButtonsEnabled[i] = true;
            }
        }
        this.fTree = null;
        this.fTreeControl = null;
        this.fButtonsControl = null;
        this.fRemoveButtonIndex = -1;
        this.fUpButtonIndex = -1;
        this.fDownButtonIndex = -1;
        this.fTreeExpandLevel = 0;
    }

    public void setRemoveButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fRemoveButtonIndex = n;
    }

    public void setUpButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUpButtonIndex = n;
    }

    public void setDownButtonIndex(int n) {
        Assert.isTrue((n < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fDownButtonIndex = n;
    }

    public void setViewerComparator(ViewerComparator viewerComparator) {
        this.fViewerComparator = viewerComparator;
    }

    public void setTreeExpansionLevel(int n) {
        this.fTreeExpandLevel = n;
        if (this.isOkToUse((Control)this.fTreeControl) && this.fTreeExpandLevel > 0) {
            this.fTree.expandToLevel(n);
        }
    }

    private void buttonPressed(int n) {
        if (!this.managedButtonPressed(n) && this.fTreeAdapter != null) {
            this.fTreeAdapter.customButtonPressed(this, n);
        }
    }

    protected boolean managedButtonPressed(int n) {
        if (n == this.fRemoveButtonIndex) {
            this.remove();
        } else if (n == this.fUpButtonIndex) {
            this.up();
        } else if (n == this.fDownButtonIndex) {
            this.down();
        } else {
            return false;
        }
        return true;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.assertEnoughColumns(n);
        Label label = this.getLabelControl(composite);
        GridData gridData = TreeListDialogField.gridDataForLabel(1);
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Control control = this.getTreeControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = n - 2;
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(6);
        control.setLayoutData((Object)gridData);
        Composite composite2 = this.getButtonBox(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        return new Control[]{label, control, composite2};
    }

    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonsMinWidth(int n) {
        if (this.fLastSeparator != null) {
            ((GridData)this.fLastSeparator.getLayoutData()).widthHint = n;
        }
    }

    public Control getTreeControl(Composite composite) {
        if (this.fTreeControl == null) {
            this.assertCompositeNotNull(composite);
            this.fTree = this.createTreeViewer(composite);
            this.fTreeControl = (Tree)this.fTree.getControl();
            this.fTreeControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    TreeListDialogField.this.handleKeyPressed(keyEvent);
                }
            });
            this.fTree.setContentProvider((IContentProvider)this.fTreeViewerAdapter);
            this.fTree.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTree.addSelectionChangedListener((ISelectionChangedListener)this.fTreeViewerAdapter);
            this.fTree.addDoubleClickListener((IDoubleClickListener)this.fTreeViewerAdapter);
            this.fTree.setInput(this.fParentElement);
            this.fTree.expandToLevel(this.fTreeExpandLevel);
            if (this.fViewerComparator != null) {
                this.fTree.setComparator(this.fViewerComparator);
            }
            this.fTreeControl.setEnabled(this.isEnabled());
            if (this.fSelectionWhenEnabled != null) {
                this.postSetSelection(this.fSelectionWhenEnabled);
            }
        }
        return this.fTreeControl;
    }

    public TreeViewer getTreeViewer() {
        return this.fTree;
    }

    protected int getTreeStyle() {
        int n = 2818;
        return n;
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, this.getTreeStyle());
        tree.setFont(composite.getFont());
        return new TreeViewer(tree);
    }

    protected Button createButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        button.addSelectionListener(selectionListener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 1;
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Label createSeparator(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public Composite getButtonBox(Composite composite) {
        if (this.fButtonsControl == null) {
            this.assertCompositeNotNull(composite);
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TreeListDialogField.this.doButtonSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TreeListDialogField.this.doButtonSelected(selectionEvent);
                }
            };
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            if (this.fButtonLabels != null) {
                this.fButtonControls = new Button[this.fButtonLabels.length];
                for (int i = 0; i < this.fButtonLabels.length; ++i) {
                    String string = this.fButtonLabels[i];
                    if (string != null) {
                        this.fButtonControls[i] = this.createButton(composite2, string, selectionListener);
                        this.fButtonControls[i].setEnabled(this.isEnabled() && this.fButtonsEnabled[i]);
                        continue;
                    }
                    this.fButtonControls[i] = null;
                    this.createSeparator(composite2);
                }
            }
            this.fLastSeparator = this.createSeparator(composite2);
            this.updateButtonState();
            this.fButtonsControl = composite2;
        }
        return this.fButtonsControl;
    }

    private void doButtonSelected(SelectionEvent selectionEvent) {
        if (this.fButtonControls != null) {
            for (int i = 0; i < this.fButtonControls.length; ++i) {
                if (selectionEvent.widget != this.fButtonControls[i]) continue;
                this.buttonPressed(i);
                return;
            }
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.fRemoveButtonIndex != -1 && this.isButtonEnabled(this.fTree.getSelection(), this.fRemoveButtonIndex)) {
            this.managedButtonPressed(this.fRemoveButtonIndex);
            return;
        }
        this.fTreeAdapter.keyPressed(this, keyEvent);
    }

    public void dialogFieldChanged() {
        super.dialogFieldChanged();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.fButtonControls != null && this.isOkToUse((Control)this.fTreeControl) && this.fTreeControl.isEnabled()) {
            ISelection iSelection = this.fTree.getSelection();
            for (int i = 0; i < this.fButtonControls.length; ++i) {
                Button button = this.fButtonControls[i];
                if (!this.isOkToUse((Control)button)) continue;
                button.setEnabled(this.isButtonEnabled(iSelection, i));
            }
        }
    }

    protected boolean containsAttributes(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (this.fElements.contains(list.get(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean getManagedButtonState(ISelection iSelection, int n) {
        List list = this.getSelectedElements();
        boolean bl = this.containsAttributes(list);
        if (n == this.fRemoveButtonIndex) {
            return !list.isEmpty() && !bl;
        }
        if (n == this.fUpButtonIndex) {
            return !iSelection.isEmpty() && !bl && this.canMoveUp(list);
        }
        if (n == this.fDownButtonIndex) {
            return !iSelection.isEmpty() && !bl && this.canMoveDown(list);
        }
        return true;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean bl = this.isEnabled();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            if (!bl) {
                if (this.fSelectionWhenEnabled == null) {
                    this.fSelectionWhenEnabled = this.fTree.getSelection();
                    this.selectElements(null);
                }
            } else if (this.fSelectionWhenEnabled != null) {
                this.selectElements(this.fSelectionWhenEnabled);
            }
            this.fTreeControl.setEnabled(bl);
        }
        this.updateButtonState();
    }

    public void enableButton(int n, boolean bl) {
        if (this.fButtonsEnabled != null && n < this.fButtonsEnabled.length) {
            this.fButtonsEnabled[n] = bl;
            this.updateButtonState();
        }
    }

    private boolean isButtonEnabled(ISelection iSelection, int n) {
        boolean bl = this.getManagedButtonState(iSelection, n);
        return this.isEnabled() && bl && this.fButtonsEnabled[n];
    }

    public void setElements(List list) {
        this.fElements = new ArrayList(list);
        this.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
    }

    public List getElements() {
        return new ArrayList(this.fElements);
    }

    public Object getElement(int n) {
        return this.fElements.get(n);
    }

    public int getIndexOfElement(Object object) {
        return this.fElements.indexOf(object);
    }

    public void replaceElement(Object object, Object object2) throws IllegalArgumentException {
        int n = this.fElements.indexOf(object);
        if (n != -1) {
            this.fElements.set(n, object2);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                List list = this.getSelectedElements();
                if (list.remove(object)) {
                    list.add(object2);
                }
                boolean bl = this.fTree.getExpandedState(object);
                this.fTree.remove(object);
                this.fTree.add(this.fParentElement, object2);
                if (bl) {
                    this.fTree.expandToLevel(object2, this.fTreeExpandLevel);
                }
                this.selectElements((ISelection)new StructuredSelection(list));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public boolean addElement(Object object) {
        if (this.fElements.contains(object)) {
            return false;
        }
        this.fElements.add(object);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, object);
            this.fTree.expandToLevel(object, this.fTreeExpandLevel);
        }
        this.dialogFieldChanged();
        return true;
    }

    public boolean addElements(List list) {
        int n = list.size();
        if (n > 0) {
            int n2;
            ArrayList arrayList = new ArrayList(n);
            for (n2 = 0; n2 < n; ++n2) {
                Object e = list.get(n2);
                if (this.fElements.contains(e)) continue;
                arrayList.add(e);
            }
            if (!arrayList.isEmpty()) {
                this.fElements.addAll(arrayList);
                if (this.isOkToUse((Control)this.fTreeControl)) {
                    this.fTree.add(this.fParentElement, arrayList.toArray());
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        this.fTree.expandToLevel(arrayList.get(n2), this.fTreeExpandLevel);
                    }
                }
                this.dialogFieldChanged();
                return true;
            }
        }
        return false;
    }

    public void insertElementAt(Object object, int n) {
        if (this.fElements.contains(object)) {
            return;
        }
        this.fElements.add(n, object);
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.add(this.fParentElement, object);
            if (this.fTreeExpandLevel != -1) {
                this.fTree.expandToLevel(object, this.fTreeExpandLevel);
            }
        }
        this.dialogFieldChanged();
    }

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            this.refresh();
            this.dialogFieldChanged();
        }
    }

    public void removeElement(Object object) throws IllegalArgumentException {
        if (this.fElements.remove(object)) {
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(object);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.dialogFieldChanged();
    }

    public void removeElements(List list) {
        if (list.size() > 0) {
            this.fElements.removeAll(list);
            if (this.isOkToUse((Control)this.fTreeControl)) {
                this.fTree.remove(list.toArray());
            }
            this.dialogFieldChanged();
        }
    }

    public int getSize() {
        return this.fElements.size();
    }

    public void selectElements(ISelection iSelection) {
        this.fSelectionWhenEnabled = iSelection;
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.setSelection(iSelection, true);
        }
    }

    public void selectFirstElement() {
        Object object = null;
        if (this.fViewerComparator != null) {
            Object[] objectArray = this.fElements.toArray();
            this.fViewerComparator.sort((Viewer)this.fTree, objectArray);
            if (objectArray.length > 0) {
                object = objectArray[0];
            }
        } else if (this.fElements.size() > 0) {
            object = this.fElements.get(0);
        }
        if (object != null) {
            this.selectElements((ISelection)new StructuredSelection(object));
        }
    }

    public void postSetSelection(final ISelection iSelection) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            Display display = this.fTreeControl.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (TreeListDialogField.this.isOkToUse((Control)TreeListDialogField.this.fTreeControl)) {
                        TreeListDialogField.this.selectElements(iSelection);
                    }
                }
            });
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh();
        }
    }

    public void refresh(Object object) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.refresh(object);
        }
    }

    public void update(Object object) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.update(object, null);
        }
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        for (int i = 0; i < n; ++i) {
            Object e2 = list.get(i);
            if (list2.contains(e2)) {
                arrayList.add(e2);
                continue;
            }
            if (e != null) {
                arrayList.add(e);
            }
            e = e2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    private void moveUp(List list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTree.reveal(list.get(0));
        }
    }

    private void moveDown(List list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTree.reveal(list.get(list.size() - 1));
        }
    }

    private List reverse(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    private void remove() {
        this.removeElements(this.getSelectedElements());
    }

    private void up() {
        this.moveUp(this.getSelectedElements());
    }

    private void down() {
        this.moveDown(this.getSelectedElements());
    }

    private boolean canMoveUp(List list) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int n = list.size();
            int n2 = this.fElements.size();
            for (int i = 0; i < n2 && n > 0; --n, ++i) {
                if (list.contains(this.fElements.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canMoveDown(List list) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            int n = list.size();
            for (int i = this.fElements.size() - 1; i >= 0 && n > 0; --n, --i) {
                if (list.contains(this.fElements.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public List getSelectedElements() {
        ISelection iSelection;
        ArrayList arrayList = new ArrayList();
        if (this.isOkToUse((Control)this.fTreeControl) && (iSelection = this.fTree.getSelection()) instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public void expandElement(Object object, int n) {
        if (this.isOkToUse((Control)this.fTreeControl)) {
            this.fTree.expandToLevel(object, n);
        }
    }

    protected void doListSelected(SelectionChangedEvent selectionChangedEvent) {
        this.updateButtonState();
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.selectionChanged(this);
        }
    }

    protected void doDoubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.fTreeAdapter != null) {
            this.fTreeAdapter.doubleClicked(this);
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return TreeListDialogField.this.fElements.toArray();
        }

        public Object[] getChildren(Object object) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getChildren(TreeListDialogField.this, object);
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object object) {
            if (!TreeListDialogField.this.fElements.contains(object) && TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.getParent(TreeListDialogField.this, object);
            }
            return TreeListDialogField.this.fParentElement;
        }

        public boolean hasChildren(Object object) {
            if (TreeListDialogField.this.fTreeAdapter != null) {
                return TreeListDialogField.this.fTreeAdapter.hasChildren(TreeListDialogField.this, object);
            }
            return false;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            TreeListDialogField.this.doListSelected(selectionChangedEvent);
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            TreeListDialogField.this.doDoubleClick(doubleClickEvent);
        }
    }
}

