/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.internal.dialogfields;

import com.spket.ui.internal.dialogfields.DialogField;
import com.spket.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectionButtonDialogField
extends DialogField {
    private Button fButton;
    private boolean fIsSelected = false;
    private DialogField[] fAttachedDialogFields = null;
    private int fButtonStyle;

    public SelectionButtonDialogField(int n) {
        this.fButtonStyle = n;
    }

    public void attachDialogField(DialogField dialogField) {
        this.attachDialogFields(new DialogField[]{dialogField});
    }

    public void attachDialogFields(DialogField[] dialogFieldArray) {
        this.fAttachedDialogFields = dialogFieldArray;
        for (int i = 0; i < dialogFieldArray.length; ++i) {
            dialogFieldArray[i].setEnabled(this.fIsSelected);
        }
    }

    public boolean isAttached(DialogField dialogField) {
        if (this.fAttachedDialogFields != null) {
            for (int i = 0; i < this.fAttachedDialogFields.length; ++i) {
                if (this.fAttachedDialogFields[i] != dialogField) continue;
                return true;
            }
        }
        return false;
    }

    public Control[] doFillIntoGrid(Composite composite, int n) {
        this.assertEnoughColumns(n);
        Button button = this.getSelectionButton(composite);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        gridData.horizontalAlignment = 4;
        if (this.fButtonStyle == 8) {
            gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        }
        button.setLayoutData((Object)gridData);
        return new Control[]{button};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Button getSelectionButton(Composite composite) {
        if (this.fButton == null) {
            this.assertCompositeNotNull(composite);
            this.fButton = new Button(composite, this.fButtonStyle);
            this.fButton.setFont(composite.getFont());
            this.fButton.setText(this.fLabelText);
            this.fButton.setEnabled(this.isEnabled());
            this.fButton.setSelection(this.fIsSelected);
            this.fButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    SelectionButtonDialogField.this.doWidgetSelected(selectionEvent);
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectionButtonDialogField.this.doWidgetSelected(selectionEvent);
                }
            });
        }
        return this.fButton;
    }

    private void doWidgetSelected(SelectionEvent selectionEvent) {
        if (this.isOkToUse((Control)this.fButton)) {
            this.changeValue(this.fButton.getSelection());
        }
    }

    private void changeValue(boolean bl) {
        if (this.fIsSelected != bl) {
            this.fIsSelected = bl;
            if (this.fAttachedDialogFields != null) {
                boolean bl2 = false;
                for (int i = 0; i < this.fAttachedDialogFields.length; ++i) {
                    this.fAttachedDialogFields[i].setEnabled(this.fIsSelected);
                    if (!this.fIsSelected || bl2) continue;
                    bl2 = this.fAttachedDialogFields[i].setFocus();
                }
            }
            this.dialogFieldChanged();
        } else if (this.fButtonStyle == 8) {
            this.dialogFieldChanged();
        }
    }

    public void setLabelText(String string) {
        this.fLabelText = string;
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setText(string);
        }
    }

    public boolean isSelected() {
        return this.fIsSelected;
    }

    public void setSelection(boolean bl) {
        this.changeValue(bl);
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(bl);
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setEnabled(this.isEnabled());
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fButton)) {
            this.fButton.setSelection(this.fIsSelected);
        }
    }
}

