/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.internal;

import com.spket.buffer.BufferManager;
import com.spket.ui.internal.License;
import com.spket.ui.tasks.TaskBuilder;
import com.spket.ui.text.TextDocumentProvider;
import com.spket.widget.UIUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.spket.ui";
    private static UIPlugin plugin;
    private Map registry;
    private License license;
    private FormToolkit fDialogsFormToolkit;
    private IDocumentProvider fDocumentProvider;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return UIPlugin.getDefault().internalGetActivePage();
    }

    public static void log(IStatus iStatus) {
        plugin.getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        UIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, "Internal", throwable));
    }

    public static void logErrorMessage(String string) {
        UIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, string, null));
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        return UIPlugin.getDefault().get(imageDescriptor);
    }

    public UIPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        BufferManager.getDefault();
        TaskBuilder.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        try {
            TaskBuilder.shutdown();
            if (this.fDialogsFormToolkit != null) {
                this.fDialogsFormToolkit.dispose();
                this.fDialogsFormToolkit = null;
            }
        }
        finally {
            super.stop(bundleContext);
        }
    }

    public synchronized IDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new TextDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public FormToolkit getDialogsFormToolkit() {
        if (this.fDialogsFormToolkit == null) {
            FormColors formColors = new FormColors(Display.getCurrent());
            formColors.setBackground(null);
            formColors.setForeground(null);
            this.fDialogsFormToolkit = new FormToolkit(formColors);
        }
        return this.fDialogsFormToolkit;
    }

    public License getLicense() {
        if (this.license == null) {
            this.license = new License();
        }
        return this.license;
    }

    protected Image get(ImageDescriptor imageDescriptor) {
        Image image;
        if (this.registry == null) {
            this.registry = new HashMap();
            UIUtils.disposeAfterShutdown((Runnable)new Runnable(){

                public void run() {
                    if (UIPlugin.this.registry != null) {
                        Iterator iterator = UIPlugin.this.registry.values().iterator();
                        while (iterator.hasNext()) {
                            ((Image)iterator.next()).dispose();
                        }
                        UIPlugin.this.registry.clear();
                        UIPlugin.this.registry = null;
                    }
                }
            });
        }
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((image = (Image)this.registry.get(imageDescriptor)) == null && (image = imageDescriptor.createImage()) != null) {
            this.registry.put(imageDescriptor, image);
        }
        return image;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }
}

