/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.editors;

import com.spket.ui.actions.ChangeCaseAction;
import com.spket.ui.actions.TabsAction;
import com.spket.ui.editors.DNDSupport;
import com.spket.ui.editors.DropAction;
import com.spket.ui.editors.HoverControlCreator;
import com.spket.ui.editors.IDropAction;
import com.spket.ui.editors.IDropHandler;
import com.spket.ui.editors.InformationDispatchAction;
import com.spket.ui.editors.TabConverter;
import com.spket.ui.internal.License;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.text.CorrectionCommandInstaller;
import com.spket.ui.text.IConfigurable;
import com.spket.ui.text.IFoldingSupport;
import com.spket.ui.text.IReconcilingParticipant;
import com.spket.ui.text.TextTools;
import com.spket.ui.util.Compatibility;
import com.spket.util.IDragSource;
import com.spket.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.CaseAction;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class PlainTextEditor
extends TextEditor
implements IReconcilingParticipant,
IDropHandler {
    protected static final int SHOW_OUTLINE = 1;
    protected static final int SHOW_HIERARCHY = 2;
    private static boolean gCheckLicense = true;
    private IPath fPath;
    private DNDSupport fDNDSupport;
    private TabConverter fTabConverter;
    private IFoldingSupport foldingSupport;
    private ToggleFoldingRunner fFoldingRunner;
    private ProjectionSupport fProjectionSupport;
    private AbstractSelectionChangedListener fOutlineListener;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    protected IContentOutlinePage fContentOutlinePage;
    private CorrectionCommandInstaller fCorrectionCommands;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$editors$text$ILocationProvider;

    public Object getAdapter(Class clazz) {
        Object object;
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = PlainTextEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(clazz)) {
            return this.getContentOutlinePage();
        }
        if (this.fProjectionSupport != null && (object = this.fProjectionSupport.getAdapter(this.getSourceViewer(), clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    public PlainTextEditor() {
        this.setDocumentProvider(UIPlugin.getDefault().getDocumentProvider());
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void dispose() {
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fCorrectionCommands != null) {
            this.fCorrectionCommands.deregisterCommands();
            this.fCorrectionCommands = null;
        }
        if (this.fContentOutlinePage != null) {
            if (this.fOutlineListener != null) {
                this.fOutlineListener.uninstall((ISelectionProvider)this.fContentOutlinePage);
                this.fOutlineListener = null;
            }
            this.fContentOutlinePage.dispose();
            this.fContentOutlinePage = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        this.fDNDSupport = null;
        super.dispose();
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        if (this.isFoldingEnabled() && projectionViewer.canDoOperation(19)) {
            projectionViewer.doOperation(19);
        }
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        if (gCheckLicense) {
            this.checkLicense();
        }
    }

    private final boolean showLicenseDialog() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore != null) {
            int n;
            int n2 = 1;
            int n3 = 6;
            int n4 = 1;
            long l = iPreferenceStore.getLong("spket.ver");
            long l2 = n2 << 16 | n3 << 8 | n4;
            if (l != 0L && (l >> (n = (int)(l >> 48) & 0xFFFFFF) & 0xFFFFFFL) == l2) {
                return false;
            }
            n = (int)(Math.random() * 15.0 + 1.0);
            l2 = (long)n << 48 | l2 << n;
            iPreferenceStore.setValue("spket.ver", l2);
        }
        return true;
    }

    protected void checkLicense() {
        License license = UIPlugin.getDefault().getLicense();
        if (license.isValid()) {
            return;
        }
        if (this.showLicenseDialog()) {
            gCheckLicense = false;
            Shell shell = this.getSite().getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = PlainTextEditor.this.getSite().getShell();
                    if (shell != null && !shell.isDisposed()) {
                        License license = UIPlugin.getDefault().getLicense();
                        license.promptForLicense(shell);
                    }
                }
            });
        }
    }

    public void reconcile() {
        if (this.foldingSupport != null) {
            this.foldingSupport.reconcile();
        }
        if (this.fContentOutlinePage instanceof IReconcilingParticipant) {
            ((IReconcilingParticipant)this.fContentOutlinePage).reconcile();
        }
    }

    protected void createActions() {
        super.createActions();
        Object object = new ContentAssistAction(UIMessages.getResourceBundle(), "ContentAssistProposal_", (ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)object);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        object = new TextOperationAction(UIMessages.getResourceBundle(), "ShowInfo_", (ITextEditor)this, 16, true);
        object = new InformationDispatchAction(UIMessages.getResourceBundle(), "ShowInfo_", this, (TextOperationAction)object);
        object.setActionDefinitionId("com.spket.ui.edit.show_info");
        object.setEnabled(true);
        this.setAction("com.spket.ui.edit.show_info", (IAction)object);
        object = new TextOperationAction(UIMessages.getResourceBundle(), "Format_", (ITextEditor)this, 15);
        object.setActionDefinitionId("com.spket.ui.edit.text.format");
        this.setAction("com.spket.ui.edit.text.format", (IAction)object);
        this.markAsStateDependentAction("com.spket.ui.edit.text.format", true);
        object = new ChangeCaseAction(this, 2);
        object.setText(UIMessages.UpperCase_text);
        object.setToolTipText(UIMessages.UpperCase_text);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.upperCase");
        this.setAction("UpperCase", (IAction)object);
        object = new ChangeCaseAction(this, 1);
        object.setText(UIMessages.LowerCase_text);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.lowerCase");
        this.setAction("LowerCase", (IAction)object);
        object = new ChangeCaseAction(this, 0);
        object.setText(UIMessages.InvertCase_text);
        object.setActionDefinitionId("com.spket.ui.edit.text.invertCase");
        this.setAction("com.spket.ui.edit.text.invertCase", (IAction)object);
        object = new ChangeCaseAction(this, 3);
        object.setText(UIMessages.Capitalize_text);
        object.setActionDefinitionId("com.spket.ui.edit.text.capitalize");
        this.setAction("com.spket.ui.edit.text.capitalize", (IAction)object);
        object = new TabsAction(this);
        object.setText(UIMessages.Tabs2Spaces_text);
        object.setActionDefinitionId("com.spket.ui.edit.text.tab2space");
        this.setAction("com.spket.ui.edit.text.tab2space", (IAction)object);
        object = new OperationAction(1);
        object.setText(UIMessages.ShowOutline_text);
        object.setToolTipText(UIMessages.ShowOutline_tooltip);
        object.setDescription(UIMessages.ShowOutline_description);
        object.setActionDefinitionId("com.spket.ui.edit.show_outline");
        this.setAction("com.spket.ui.edit.show_outline", (IAction)object);
        object = new OperationAction(2);
        object.setText(UIMessages.OpenHierarchy_text);
        object.setToolTipText(UIMessages.OpenHierarchy_tooltip);
        object.setDescription(UIMessages.OpenHierarchy_description);
        object.setActionDefinitionId("com.spket.ui.edit.open_hierarchy");
        this.setAction("com.spket.ui.edit.open_hierarchy", (IAction)object);
        this.setAction("com.spket.ui.edit.open_editor", (IAction)new OpenAction());
        this.markAsStateDependentAction("UpperCase", true);
        this.markAsSelectionDependentAction("UpperCase", true);
        this.markAsStateDependentAction("LowerCase", true);
        this.markAsSelectionDependentAction("LowerCase", true);
        this.markAsStateDependentAction("com.spket.ui.edit.text.capitalize", true);
        this.markAsSelectionDependentAction("com.spket.ui.edit.text.capitalize", true);
        this.markAsStateDependentAction("com.spket.ui.edit.text.invertCase", true);
        this.markAsSelectionDependentAction("com.spket.ui.edit.text.invertCase", true);
        this.markAsStateDependentAction("com.spket.ui.edit.text.tab2space", true);
        this.fCorrectionCommands = new CorrectionCommandInstaller();
        this.fCorrectionCommands.registerCommands(this);
    }

    public void setAction(String string, IAction iAction) {
        if (("UpperCase".equals(string) || "LowerCase".equals(string)) && iAction instanceof CaseAction) {
            return;
        }
        super.setAction(string, iAction);
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText styledText = this.getSourceViewer().getTextWidget();
        SmartLineStartAction smartLineStartAction = new SmartLineStartAction(styledText, false);
        smartLineStartAction.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)smartLineStartAction);
        smartLineStartAction = new SmartLineStartAction(styledText, true);
        smartLineStartAction.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)smartLineStartAction);
    }

    public void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        iMenuManager.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        this.addAction(iMenuManager, "group.open", "com.spket.ui.edit.open_editor");
        if (this.canDoOperation(2)) {
            this.addAction(iMenuManager, "group.open", "com.spket.ui.edit.open_hierarchy");
        }
        if (this.canDoOperation(1)) {
            this.addAction(iMenuManager, "group.open", "com.spket.ui.edit.show_outline");
        }
        MenuManager menuManager = new MenuManager(UIMessages.FormatMenu_Text, "format");
        menuManager.add(this.getAction("com.spket.ui.edit.text.format"));
        menuManager.add(this.getAction("com.spket.ui.edit.text.tab2space"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getAction("UpperCase"));
        menuManager.add(this.getAction("LowerCase"));
        menuManager.add(this.getAction("com.spket.ui.edit.text.capitalize"));
        menuManager.add(this.getAction("com.spket.ui.edit.text.invertCase"));
        iMenuManager.insertAfter("group.edit", (IContributionItem)menuManager);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"com.spket.ui.textEditScope"});
    }

    protected void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        super.setPreferenceStore(iPreferenceStore);
        if (this.getSourceViewerConfiguration() != null) {
            this.setSourceViewerConfiguration(this.createSourceViewerConfiguration(iPreferenceStore));
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration instanceof IConfigurable && ((IConfigurable)sourceViewerConfiguration).affectsTextPresentation(propertyChangeEvent)) {
            return true;
        }
        return super.affectsTextPresentation(propertyChangeEvent);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        String string;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        String string2 = propertyChangeEvent.getProperty();
        if ("tab.char".equals(string2)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        if (this.foldingSupport != null) {
            int n = this.foldingSupport.affects(string2);
            if (1 == n) {
                if (iSourceViewer instanceof ProjectionViewer) {
                    if (this.fFoldingRunner == null) {
                        ToggleFoldingRunner toggleFoldingRunner = new ToggleFoldingRunner();
                        toggleFoldingRunner.switchMode = true;
                        toggleFoldingRunner.runWhenNextVisible();
                    } else {
                        this.fFoldingRunner.switchMode = !this.fFoldingRunner.switchMode;
                    }
                }
                return;
            }
            if (2 == n) {
                if (this.fFoldingRunner == null) {
                    ToggleFoldingRunner toggleFoldingRunner = new ToggleFoldingRunner();
                    toggleFoldingRunner.changeOption = true;
                    toggleFoldingRunner.runWhenNextVisible();
                } else {
                    this.fFoldingRunner.changeOption = true;
                }
                return;
            }
        }
        if (this.fDNDSupport != null && (string = Compatibility.getTextDragAndDropId()) != null && string.equals(string2)) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (iPreferenceStore != null && iPreferenceStore.getBoolean(string)) {
                this.fDNDSupport.setTextDragSupport(true);
            } else {
                this.fDNDSupport.setTextDragSupport(false);
            }
            return;
        }
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration instanceof IConfigurable) {
            ((IConfigurable)sourceViewerConfiguration).changeConfiguration(propertyChangeEvent);
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected void setupPartitioner(IDocument iDocument) {
        this.getTextTools().setupDocumentPartitioner(iDocument, this.getDocumentPartitioning());
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        ILocationProvider iLocationProvider;
        super.doSetInput(iEditorInput);
        IPath iPath = null;
        if (iEditorInput instanceof IStorageEditorInput) {
            iPath = ((IStorageEditorInput)iEditorInput).getStorage().getFullPath();
        } else if (iEditorInput instanceof IPathEditorInput) {
            iPath = ((IPathEditorInput)iEditorInput).getPath();
        } else if (iEditorInput instanceof ILocationProvider) {
            iPath = ((ILocationProvider)iEditorInput).getPath((Object)iEditorInput);
        } else {
            iLocationProvider = (ILocationProvider)iEditorInput.getAdapter(class$org$eclipse$ui$editors$text$ILocationProvider == null ? (class$org$eclipse$ui$editors$text$ILocationProvider = PlainTextEditor.class$("org.eclipse.ui.editors.text.ILocationProvider")) : class$org$eclipse$ui$editors$text$ILocationProvider);
            if (iLocationProvider != null) {
                iPath = iLocationProvider.getPath((Object)iEditorInput);
            }
        }
        this.fPath = iPath;
        iLocationProvider = this.getDocumentProvider().getDocument((Object)iEditorInput);
        this.setupPartitioner((IDocument)iLocationProvider);
    }

    protected IContentOutlinePage getContentOutlinePage() {
        if (this.fContentOutlinePage == null) {
            this.fContentOutlinePage = this.createContentOutlinePage();
            if (this.fContentOutlinePage != null) {
                if (this.fOutlineListener == null) {
                    this.fOutlineListener = new OutlineSelectionChangedListener();
                }
                this.fOutlineListener.install((ISelectionProvider)this.fContentOutlinePage);
            }
        }
        return this.fContentOutlinePage;
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        PlainSourceViewer plainSourceViewer = new PlainSourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.fProjectionSupport = new ProjectionSupport((ProjectionViewer)plainSourceViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.setHoverControlCreator((IInformationControlCreator)new HoverControlCreator(this));
        this.fProjectionSupport.install();
        this.foldingSupport = this.createFoldingSupport();
        if (this.foldingSupport != null) {
            this.foldingSupport.configure(this.getPreferenceStore(), false);
            this.foldingSupport.install(plainSourceViewer);
        }
        this.getSourceViewerDecorationSupport((ISourceViewer)plainSourceViewer);
        return plainSourceViewer;
    }

    protected int getTabSize() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore == null) {
            return 4;
        }
        int n = -1;
        boolean bl = iPreferenceStore.getBoolean("tab.default");
        if (!bl) {
            n = StringUtils.toInt((String)iPreferenceStore.getString("tab.size"), (int)-1);
        }
        if (n < 0) {
            n = iPreferenceStore.getInt("tabWidth");
        }
        return n;
    }

    protected void configureTabConverter() {
        if (this.fTabConverter != null) {
            this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
        }
    }

    protected boolean isTabConversionEnabled() {
        return this.getPreferenceStore().getBoolean("tab.char");
    }

    protected void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof PlainSourceViewer) {
                ((PlainSourceViewer)iSourceViewer).updateIndentationPrefixes();
            }
        }
    }

    protected void stopTabConversion() {
        if (this.fTabConverter != null) {
            this.fTabConverter = null;
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof PlainSourceViewer) {
                ((PlainSourceViewer)iSourceViewer).updateIndentationPrefixes();
            }
        }
    }

    protected void initializeDragAndDrop(ISourceViewer iSourceViewer) {
        IPreferenceStore iPreferenceStore;
        this.fDNDSupport = new DNDSupport(this);
        boolean bl = false;
        String string = Compatibility.getTextDragAndDropId();
        if (string != null && (iPreferenceStore = this.getPreferenceStore()) != null) {
            bl = iPreferenceStore.getBoolean(string);
        }
        this.fDNDSupport.install(bl);
    }

    public IDropAction getDropAction(ITextViewer iTextViewer, DropTargetEvent dropTargetEvent) {
        String string;
        int n;
        if (dropTargetEvent.detail == 0) {
            return null;
        }
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument != null && (n = this.getDropOffset(iTextViewer, dropTargetEvent.x, dropTargetEvent.y)) >= 0 && (string = this.getDropData(iDocument, n, dropTargetEvent)) != null) {
            return new DropAction(string, n);
        }
        return null;
    }

    protected void onOutlineSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    protected void onSourceSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    protected int getDropOffset(ITextViewer iTextViewer, int n, int n2) {
        int n3 = -1;
        StyledText styledText = iTextViewer.getTextWidget();
        Point point = styledText.getDisplay().map(null, (Control)styledText, n, n2);
        try {
            n3 = styledText.getOffsetAtLocation(point);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StyledTextContent styledTextContent = styledText.getContent();
            int n4 = styledTextContent.getCharCount();
            Point point2 = styledText.getLocationAtOffset(n4);
            if (point.y >= point2.y) {
                try {
                    n3 = styledText.getOffsetAtLocation(new Point(point.x, point2.y));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    n3 = n4;
                }
            }
            try {
                String string;
                int n5 = styledText.getOffsetAtLocation(new Point(0, point.y));
                n3 = n4;
                int n6 = styledTextContent.getLineAtOffset(n5);
                int n7 = styledTextContent.getLineCount();
                if (n6 < n7 && (string = styledTextContent.getLine(n6)) != null) {
                    n3 = n5 + string.length();
                }
            }
            catch (IllegalArgumentException illegalArgumentException3) {
                n3 = -1;
            }
        }
        return n3;
    }

    protected String getDropData(IDocument iDocument, int n, DropTargetEvent dropTargetEvent) {
        Object object;
        Collection collection = null;
        TransferData transferData = dropTargetEvent.currentDataType;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData)) {
            object = LocalSelectionTransfer.getTransfer().getSelection();
            if (!object.isEmpty() && object instanceof IStructuredSelection) {
                collection = ((IStructuredSelection)object).toList();
            }
        } else if (com.spket.util.LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            collection = com.spket.util.LocalSelectionTransfer.getInstance().getSelection();
        }
        if (collection != null && collection.size() > 0) {
            object = null;
            Iterator iterator = collection.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 2;
            switch (dropTargetEvent.detail) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 4: {
                    n2 = 1;
                }
            }
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = null;
                if (e instanceof IDragSource) {
                    string = ((IDragSource)e).toSource(n2);
                }
                if (string == null || string.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    if (object == null) {
                        object = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                    }
                    stringBuffer.append((String)object);
                }
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected boolean canDoOperation(int n) {
        return false;
    }

    protected void doOperation(int n) {
    }

    protected int determineLineStartPosition(IDocument iDocument, String string, int n, int n2) {
        return -1;
    }

    public ICompletionProposal findCorrection(String string) {
        return null;
    }

    public abstract TextTools getTextTools();

    protected abstract boolean isFoldingEnabled();

    protected abstract IFoldingSupport createFoldingSupport();

    protected abstract void openDeclaration(int var1);

    protected abstract String getDocumentPartitioning();

    protected abstract IContentOutlinePage createContentOutlinePage();

    protected abstract SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PlainSourceViewer
    extends ProjectionViewer {
        public PlainSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
            super(composite, iVerticalRuler, iOverviewRuler, bl, n);
        }

        protected void customizeDocumentCommand(DocumentCommand documentCommand) {
            super.customizeDocumentCommand(documentCommand);
            if (this.isIgnoringAutoEditStrategies()) {
                return;
            }
            if (PlainTextEditor.this.fTabConverter != null) {
                PlainTextEditor.this.fTabConverter.customizeDocumentCommand(this.getDocument(), documentCommand);
            }
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration sourceViewerConfiguration = PlainTextEditor.this.getSourceViewerConfiguration();
            String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes((ISourceViewer)this);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = sourceViewerConfiguration.getIndentPrefixes((ISourceViewer)this, stringArray[i]);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                this.setIndentPrefixes(stringArray2, stringArray[i]);
            }
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PlainTextEditor.this.onSourceSelectionChanged(selectionChangedEvent);
        }
    }

    private class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PlainTextEditor.this.onOutlineSelectionChanged(selectionChangedEvent);
        }
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider == null) {
                return;
            }
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                iPostSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider iSelectionProvider) {
            if (iSelectionProvider == null) {
                return;
            }
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                iPostSelectionProvider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private boolean switchMode;
        private boolean changeOption;
        private IWorkbenchPage fPage;

        private ToggleFoldingRunner() {
        }

        private void run() {
            ISourceViewer iSourceViewer = PlainTextEditor.this.getSourceViewer();
            if (iSourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer;
                if (this.changeOption && PlainTextEditor.this.foldingSupport != null) {
                    PlainTextEditor.this.foldingSupport.configure(PlainTextEditor.this.getPreferenceStore(), !this.switchMode);
                }
                if (this.switchMode && (projectionViewer = (ProjectionViewer)iSourceViewer).isProjectionMode() != PlainTextEditor.this.isFoldingEnabled()) {
                    if (projectionViewer.canDoOperation(19)) {
                        projectionViewer.doOperation(19);
                    }
                    return;
                }
            }
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (PlainTextEditor.this.fFoldingRunner == this) {
                PlainTextEditor.this.fFoldingRunner = null;
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage iWorkbenchPage;
            if (PlainTextEditor.this.fFoldingRunner != null) {
                PlainTextEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite iWorkbenchPartSite = PlainTextEditor.this.getSite();
            if (iWorkbenchPartSite != null && !(iWorkbenchPage = iWorkbenchPartSite.getPage()).isPartVisible((IWorkbenchPart)PlainTextEditor.this)) {
                this.fPage = iWorkbenchPage;
                PlainTextEditor.this.fFoldingRunner = this;
                iWorkbenchPage.addPartListener((IPartListener2)this);
                return;
            }
            this.run();
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            if (PlainTextEditor.this.equals(iWorkbenchPartReference.getPart(false))) {
                this.cancel();
            }
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (PlainTextEditor.this.equals(iWorkbenchPartReference.getPart(false))) {
                this.cancel();
                this.run();
            }
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        public SmartLineStartAction(StyledText styledText, boolean bl) {
            super((AbstractTextEditor)PlainTextEditor.this, styledText, bl);
        }

        protected int getLineStartPosition(IDocument iDocument, String string, int n, int n2) {
            int n3 = -1;
            LinkedModeModel linkedModeModel = LinkedModeModel.getModel((IDocument)iDocument, (int)n2);
            if (linkedModeModel == null) {
                n3 = PlainTextEditor.this.determineLineStartPosition(iDocument, string, n, n2);
            }
            if (n3 == -1) {
                n3 = super.getLineStartPosition(iDocument, string, n, n2);
            }
            return n3;
        }
    }

    private final class OperationAction
    extends Action {
        private int fOperation;

        public OperationAction(int n) {
            this.fOperation = n;
        }

        public void run() {
            if (PlainTextEditor.this.canDoOperation(this.fOperation)) {
                PlainTextEditor.this.doOperation(this.fOperation);
            }
        }
    }

    private final class OpenAction
    extends Action {
        public OpenAction() {
            this.setText(UIMessages.OpenAction_text);
            this.setActionDefinitionId("com.spket.ui.edit.open_editor");
        }

        public void run() {
            int n = -1;
            ISelection iSelection = PlainTextEditor.this.getSelectionProvider().getSelection();
            if (iSelection instanceof ITextSelection) {
                n = ((ITextSelection)iSelection).getOffset();
            }
            if (n != -1) {
                PlainTextEditor.this.openDeclaration(n);
            }
        }
    }
}

