/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.editors;

import com.spket.ui.editors.PlainTextEditor;
import com.spket.ui.text.DefaultInformationControlCreator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class InformationDispatchAction
extends TextEditorAction {
    private PlainTextEditor fEditor;
    private InformationPresenter fInformationPresenter;
    private final TextOperationAction fTextOperationAction;

    public InformationDispatchAction(ResourceBundle resourceBundle, String string, PlainTextEditor plainTextEditor, TextOperationAction textOperationAction) {
        super(resourceBundle, string, (ITextEditor)plainTextEditor);
        this.fTextOperationAction = textOperationAction;
    }

    public void run() {
        ITextViewerExtension4 iTextViewerExtension4;
        ISourceViewer iSourceViewer = ((PlainTextEditor)this.getTextEditor()).getViewer();
        if (iSourceViewer == null) {
            this.fTextOperationAction.run();
            return;
        }
        if (iSourceViewer instanceof ITextViewerExtension4 && (iTextViewerExtension4 = (ITextViewerExtension4)iSourceViewer).moveFocusToWidgetToken()) {
            return;
        }
        if (iSourceViewer instanceof ITextViewerExtension2 && (iTextViewerExtension4 = ((ITextViewerExtension2)iSourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(iSourceViewer, (ITextHover)iTextViewerExtension4)) {
            return;
        }
        this.fTextOperationAction.run();
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        this.fEditor = iTextEditor instanceof PlainTextEditor ? (PlainTextEditor)iTextEditor : null;
    }

    private boolean makeTextHoverFocusable(ISourceViewer iSourceViewer, ITextHover iTextHover) {
        Point point = ((ITextViewerExtension2)iSourceViewer).getHoverEventLocation();
        int n = this.computeOffsetAtLocation(iSourceViewer, point.x, point.y);
        if (n == -1) {
            return false;
        }
        try {
            IRegion iRegion = iTextHover.getHoverRegion((ITextViewer)iSourceViewer, n);
            if (iRegion == null) {
                return false;
            }
            String string = iTextHover.getHoverInfo((ITextViewer)iSourceViewer, iRegion);
            IInformationControlCreator iInformationControlCreator = null;
            if (iTextHover instanceof IInformationProviderExtension2) {
                iInformationControlCreator = ((IInformationProviderExtension2)iTextHover).getInformationPresenterControlCreator();
            }
            InformationPresenter informationPresenter = this.getInformationPresenter(iSourceViewer);
            InformationProvider informationProvider = new InformationProvider(iRegion, string, iInformationControlCreator);
            informationPresenter.setOffset(n);
            informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            informationPresenter.setMargins(6, 6);
            String string2 = TextUtilities.getContentType((IDocument)iSourceViewer.getDocument(), (String)this.getDocumentPartitioning(), (int)n, (boolean)true);
            informationPresenter.setInformationProvider((IInformationProvider)informationProvider, string2);
            informationPresenter.showInformation();
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected String getDocumentPartitioning() {
        if (this.fEditor == null) {
            return "__dftl_partitioning";
        }
        return this.fEditor.getDocumentPartitioning();
    }

    private int computeOffsetAtLocation(ISourceViewer iSourceViewer, int n, int n2) {
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return -1;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        try {
            int n3 = styledText.getOffsetAtLocation(new Point(n, n2));
            Point point = styledText.getLocationAtOffset(n3);
            if (point.x > n) {
                --n3;
            }
            if (iSourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
                return iTextViewerExtension5.widgetOffset2ModelOffset(n3);
            }
            IRegion iRegion = iSourceViewer.getVisibleRegion();
            return n3 + iRegion.getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private InformationPresenter getInformationPresenter(ISourceViewer iSourceViewer) {
        if (this.fInformationPresenter == null) {
            this.fInformationPresenter = new InformationPresenter((IInformationControlCreator)new DefaultInformationControlCreator());
            this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
            this.fInformationPresenter.install((ITextViewer)iSourceViewer);
            this.fInformationPresenter.setDocumentPartitioning(this.getDocumentPartitioning());
        }
        return this.fInformationPresenter;
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion iRegion, Object object, IInformationControlCreator iInformationControlCreator) {
            this.fHoverRegion = iRegion;
            this.fHoverInfo = object;
            this.fControlCreator = iInformationControlCreator;
        }

        public IRegion getSubject(ITextViewer iTextViewer, int n) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer iTextViewer, IRegion iRegion) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }
}

