/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.IBufferReader;
import com.spket.util.Debug;

public class CharBufferReader
implements IBufferReader {
    private int fOffset;
    private int fLength;
    private char[] fSource;

    public CharBufferReader(char[] cArray, int n) {
        this.fSource = cArray;
        this.fOffset = n;
        this.fLength = cArray.length;
    }

    public CharBufferReader(char[] cArray, int n, int n2) {
        this.fSource = cArray;
        this.fOffset = n;
        this.fLength = n + n2;
        Debug.assertTrue((this.fLength <= cArray.length ? 1 : 0) != 0);
    }

    public String get(int n, int n2) {
        if (n2 == 0 || n + n2 > this.fLength) {
            return null;
        }
        return new String(this.fSource, n, n2);
    }

    public int get(int n) {
        if (n < this.fLength) {
            return this.fSource[n];
        }
        return -1;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int peek() {
        if (this.fOffset < this.fLength) {
            return this.fSource[this.fOffset];
        }
        return -1;
    }

    public int read() {
        if (this.fOffset < this.fLength) {
            return this.fSource[this.fOffset++];
        }
        return -1;
    }

    public boolean skip(char c) {
        if (this.fOffset < this.fLength && this.fSource[this.fOffset] == c) {
            ++this.fOffset;
            return true;
        }
        return false;
    }

    public boolean skip(char[] cArray) {
        if (this.fLength - this.fOffset >= cArray.length) {
            int n = this.fOffset;
            for (int i = 0; i < cArray.length; ++i) {
                if (this.fSource[n++] == cArray[i]) continue;
                return false;
            }
            this.fOffset += cArray.length;
            return true;
        }
        return false;
    }

    public void unread() {
        --this.fOffset;
    }
}

