/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.preferences;

import com.spket.laszlo.internal.LaszloPlugin;
import com.spket.laszlo.internal.LzMessages;
import com.spket.ui.internal.UIMessages;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.util.Message;
import com.spket.ui.util.StatusInfo;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class LaszloPreferencePage
extends AbstractPreferencePage {
    private Text fPath;

    protected Plugin getPlugin() {
        return LaszloPlugin.getDefault();
    }

    protected String getPluginId() {
        return "com.spket.laszlo";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LaszloPlugin.getDefault().getPreferenceStore();
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "laszlo.dir")};
        return overlayKeyArray;
    }

    protected void initialize() {
        String string;
        OverlayPreferenceStore overlayPreferenceStore = this.getOverlayPreferenceStore();
        if (this.fPath != null && (string = overlayPreferenceStore.getString("laszlo.dir")) != null) {
            this.fPath.setText(string);
        }
        super.initialize();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite2, 0);
        group.setText(LzMessages.LaszloPath_label);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fPath = new Text((Composite)group, 2052);
        this.fPath.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)group, 8);
        String string = JFaceResources.getString((String)"openBrowse");
        button.setText(string == null ? UIMessages.Browse_text : string);
        this.setButtonLayoutData(button);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (24 == event.type) {
                    LaszloPreferencePage.this.onPathChanged(event);
                } else {
                    LaszloPreferencePage.this.onBrowser(event);
                }
            }
        };
        this.fPath.addListener(24, listener);
        button.addListener(13, listener);
        return composite2;
    }

    protected void onBrowser(Event event) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fPath.getShell(), 4096);
        String string = this.fPath.getText();
        if (string != null && string.length() > 0) {
            directoryDialog.setFilterPath(string);
        }
        if ((string = directoryDialog.open()) != null) {
            this.fPath.setText(string);
        }
    }

    protected void onPathChanged(Event event) {
        StatusInfo statusInfo = null;
        String string = this.fPath.getText();
        if (string.length() > 0) {
            if (Path.ROOT.isValidPath(string)) {
                File file = new File(string);
                if (file.exists() && file.isDirectory()) {
                    File file2 = new File(file, "lps/components".replace('/', File.separatorChar));
                    if (file2.exists() && file2.isDirectory()) {
                        file2 = new File(file, "WEB-INF/lps/misc".replace('/', File.separatorChar));
                        if (!(file2 = new File(file2, "lzx-autoincludes.properties")).exists() || !file2.isFile()) {
                            statusInfo = new StatusInfo(2, this.getPluginId(), Message.format((String)LzMessages.File_not_exists, (Object)file2.getAbsolutePath()));
                        }
                    } else {
                        statusInfo = new StatusInfo(2, this.getPluginId(), Message.format((String)LzMessages.Path_cmps_not_exists, (Object)file2.getAbsolutePath()));
                    }
                } else {
                    statusInfo = new StatusInfo(2, this.getPluginId(), LzMessages.Path_not_exists);
                }
            } else {
                statusInfo = new StatusInfo(4, this.getPluginId(), LzMessages.Path_invalid);
            }
        }
        if (statusInfo == null) {
            this.getOverlayPreferenceStore().setValue("laszlo.dir", string);
        }
        this.updateStatus((IStatus)statusInfo);
    }
}

