/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.model;

import com.spket.buffer.IBuffer;
import com.spket.js.model.JSObject;
import com.spket.laszlo.model.LzClass;
import com.spket.laszlo.model.LzConstants;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.SymbolTable;

public class LzHelper
implements LzConstants {
    private static final String[] tags;
    private static final String[] attrs;
    private static Map tagMap;
    private static Map attrMap;

    public static Integer getTagID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)tagMap.get(string);
    }

    public static int getTagId(String string) {
        Integer n = LzHelper.getTagID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getTagName(int n) {
        if (n > 0 && n <= tags.length) {
            return tags[n - 1];
        }
        return null;
    }

    public static Integer getAttrID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)attrMap.get(string);
    }

    public static int getAttrId(String string) {
        Integer n = LzHelper.getAttrID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getAttrName(int n) {
        if (n > 0 && n <= attrs.length) {
            return attrs[n - 1];
        }
        return null;
    }

    public static void initSymbolTable(SymbolTable symbolTable) {
        int n;
        symbolTable.addSymbol("lzx");
        symbolTable.addSymbol("http://www.laszlosystems.com/2003/05/lzx");
        for (n = 0; n < tags.length; ++n) {
            symbolTable.addSymbol(tags[n]);
        }
        for (n = 0; n < attrs.length; ++n) {
            symbolTable.addSymbol(attrs[n]);
        }
    }

    public static XMLElement getLzNode(XMLNode xMLNode) {
        while (xMLNode != null) {
            block5: {
                short s;
                block4: {
                    s = xMLNode.getNodeType();
                    if (1 != s) break block4;
                    int n = LzHelper.getTagId(xMLNode.getLocalName());
                    switch (n) {
                        case 1: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 40: 
                        case 42: 
                        case 45: 
                        case 54: {
                            break block5;
                        }
                        default: {
                            return (XMLElement)xMLNode;
                        }
                    }
                }
                if (0 == s) break;
            }
            xMLNode = xMLNode.getParent();
        }
        return null;
    }

    public static JSObject getLzObject(JSObject jSObject, XMLElement xMLElement) {
        Object object = null;
        while (true) {
            XMLNode xMLNode;
            String string;
            if ("class".equals(string = xMLElement.getLocalName())) {
                object = new LzClass(xMLElement);
                object.setParentScope(jSObject);
            } else {
                object = jSObject.getProperty(string);
            }
            if (object != null || (xMLNode = xMLElement.getParent()) == null || xMLNode.getNodeType() != 1) break;
            xMLElement = (XMLElement)xMLNode;
        }
        return object;
    }

    public static boolean isEventName(String string) {
        return string.length() > 3 && string.startsWith("on");
    }

    public static XMLAttr getAttribute(XMLElement xMLElement, int n) {
        int n2 = xMLElement.getAttrCount();
        if (n2 > 0) {
            int n3 = n - xMLElement.getStartTagRegion().getStart();
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < n2; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                INodeRegion iNodeRegion = xMLAttr.getValueRegion();
                if (iNodeRegion == null) continue;
                if (iNodeRegion.getStart() > n3) {
                    return null;
                }
                if (iNodeRegion.getEnd() <= n3) continue;
                return xMLAttr;
            }
        }
        return null;
    }

    public static boolean isEventAttribute(XMLElement xMLElement, int n) {
        XMLAttr xMLAttr = LzHelper.getAttribute(xMLElement, n);
        if (xMLAttr == null) {
            return false;
        }
        return LzHelper.isEventAttribute(xMLAttr, n);
    }

    public static boolean isEventAttribute(XMLAttr xMLAttr, int n) {
        IBuffer iBuffer;
        XMLElement xMLElement;
        int n2;
        if (LzHelper.isEventName(xMLAttr.getName())) {
            return true;
        }
        INodeRegion iNodeRegion = xMLAttr.getValueRegion();
        if (iNodeRegion.getLength() > 3 && n > (n2 = (xMLElement = (XMLElement)xMLAttr.getParent()).getStartTagRegion().getStart() + iNodeRegion.getStart() + 1) + 1 && (iBuffer = XMLUtils.getBuffer((XMLNode)xMLAttr)) != null && iBuffer.get(n2) == '$') {
            int n3 = 0;
            switch (iBuffer.get(++n2)) {
                case '{': {
                    return true;
                }
                case 'a': {
                    n3 = 6;
                    break;
                }
                case 'i': {
                    n3 = 11;
                    break;
                }
                case 'o': {
                    n3 = 4;
                }
            }
            if (n3 > 0 && iNodeRegion.getLength() > n3 + 3 && iBuffer.get(n2 + n3) == '{') {
                return true;
            }
        }
        return false;
    }

    static {
        int n;
        tags = new String[]{"a", "agent", "allow", "animator", "animatorgroup", "attribute", "audio", "b", "br", "canvas", "class", "command", "connection", "connectiondatasource", "datapath", "datapointer", "dataselectionmanager", "dataset", "datasource", "debug", "deny", "doc", "event", "face", "font", "frame", "handler", "i", "img", "import", "include", "inputtext", "interface", "layout", "li", "library", "method", "node", "otherwise", "p", "pattern", "pre", "preloadresource", "resource", "script", "security", "selectionmanager", "splash", "state", "stylesheet", "switch", "text", "trait", "u", "view", "when"};
        attrs = new String[]{"aaactive", "aadescription", "aaname", "aasilent", "aatabindex", "acceptencodings", "accessible", "active", "align", "apply", "args", "attribute", "authenticator", "authparam", "axis", "bgcolor", "cacheable", "center", "class", "clickable", "clickregion", "clip", "color", "cursor", "dataloadtimeout", "datapath", "debug", "defaultplacement", "duration", "embedfonts", "endpoint", "event", "extends", "face", "fgcolor", "focusable", "focustrap", "font", "fontsize", "fontstyle", "frame", "from", "getresponseheaders", "group", "heartbeat", "height", "hideafterinit", "href", "hspace", "id", "ignoreplacement", "indirect", "initstage", "key", "label", "lastframe", "layout", "libraries", "locked", "maxlength", "maxtextheight", "maxtextwidth", "medialoadtimeout", "method", "motion", "multiline", "name", "namespace", "nsprefix", "onapply", "onblur", "onclick", "onconnect", "ondata", "ondblclick", "ondisconnect", "onerror", "onfocus", "oninit", "onkeydown", "onkeyup", "onload", "onmousedown", "onmouseout", "onmouseover", "onmouseup", "onremove", "onselect", "onstart", "onstop", "ontimeout", "onuserdisconnect", "opacity", "options", "p", "password", "pattern", "paused", "persistent", "pixellock", "placement", "play", "pooling", "process", "proxied", "querystring", "querytype", "queuerequests", "ratio", "receiveuserdisconnect", "reference", "relative", "repeat", "replication", "request", "required", "rerunxpath", "resizable", "resize", "resource", "resourcename", "rotation", "runtime", "secure", "secureport", "selectable", "selectiontype", "setter", "showInternalProperties", "showhandcursor", "size", "sortorder", "sortpath", "source", "spacing", "src", "stage", "start", "stretches", "style", "synchronized", "synctoload", "target", "text", "textheight", "textwidth", "timeout", "title", "to", "toggle", "trimwhitespace", "type", "url", "validate", "valign", "value", "version", "visible", "vspace", "when", "width", "with", "x", "xoffset", "xpath", "y", "yoffset"};
        tagMap = new HashMap(tags.length);
        attrMap = new HashMap(attrs.length);
        for (n = 0; n < tags.length; ++n) {
            tagMap.put(tags[n], new Integer(n + 1));
        }
        for (n = 0; n < attrs.length; ++n) {
            attrMap.put(attrs[n], new Integer(n + 1));
        }
    }
}

