/*
 * Decompiled with CFR 0.152.
 */
package com.spket.dtd.model;

import com.spket.buffer.BufferChangedEvent;
import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.xml.DTD;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class EntityManager {
    private static BufferManager gBufferManager = BufferManager.getDefault();
    private static EntityManager manager;
    private Map dtds = new HashMap();

    public static EntityManager getDefault() {
        if (manager == null) {
            manager = new EntityManager();
        }
        return manager;
    }

    public DTD getDTD(IPath iPath) {
        IBuffer iBuffer;
        DTD dTD = (DTD)this.dtds.get(iPath);
        if (dTD == null && (iBuffer = gBufferManager.getBuffer(iPath)) != null) {
            dTD = new DTD(iBuffer);
            State state = new State(dTD, iPath);
            iBuffer.addBufferListener((IBufferListener)state);
            this.dtds.put(iPath, dTD);
        }
        return dTD;
    }

    public DTD getDTD(IPath iPath, IPath iPath2) {
        IPath iPath3;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer(locale.getLanguage());
            if (stringBuffer.length() > 0 && (object = locale.getCountry()) != null && ((String)object).length() > 0) {
                stringBuffer.append('_').append((String)object);
            }
            if (stringBuffer.length() > 0) {
                DTD dTD;
                object = new HashMap();
                object.put("locale", stringBuffer.toString());
                iPath3 = gBufferManager.resolve(iPath, iPath2, (Map)object);
                if (iPath3 != null && iPath3 != iPath && (dTD = this.getDTD(iPath3)) != null) {
                    return dTD;
                }
            }
        }
        if ((iPath3 = gBufferManager.resolve(iPath, iPath2, null)) != null) {
            return this.getDTD(iPath3);
        }
        return null;
    }

    private class State
    implements IBufferListener {
        private DTD dtd;
        private IPath path;

        public State(DTD dTD, IPath iPath) {
            this.dtd = dTD;
            this.path = iPath;
        }

        public void bufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
        }

        public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
            if (this.dtd != null) {
                this.dtd.reset(false);
            }
        }

        public void bufferClosed(IBuffer iBuffer) {
            if (this.dtd != null) {
                this.dtd.reset(true);
                this.dtd = null;
            }
            if (this.path != null) {
                EntityManager.this.dtds.remove(this.path);
                this.path = null;
            }
        }
    }
}

