/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.model;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.buffer.BufferManager;
import com.spket.js.model.Context;
import com.spket.js.model.JSFunction;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.parser.ScriptManager;
import com.spket.mime.text.LexerProvider;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xul.model.XULHelper;
import com.spket.xul.model.XULModel;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class XULLexerProvider
extends LexerProvider {
    private static BufferManager gBufferManager = BufferManager.getDefault();

    static XMLAttr getEventAttr(XMLNode xMLNode, int n) {
        XMLElement xMLElement;
        int n2;
        if (xMLNode != null && xMLNode.getNodeType() == 1 && (n2 = (xMLElement = (XMLElement)xMLNode).getAttrCount()) > 0) {
            n -= xMLElement.getStartTagRegion().getStart();
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < n2; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                INodeRegion iNodeRegion = xMLAttr.getValueRegion();
                if (iNodeRegion == null) continue;
                if (iNodeRegion.getStart() > n) {
                    return null;
                }
                if (iNodeRegion.getEnd() <= n || !XULHelper.isEventAttribute(xMLAttr.getLocalName())) continue;
                return xMLAttr;
            }
        }
        return null;
    }

    public XULLexerProvider(XULModel xULModel, int n) {
        super((XMLModel)xULModel, n);
    }

    public Context getContext() {
        return XULModel.getContext(this.fModel);
    }

    public JSObject getGlobalForEdit() {
        Context context = this.getContext();
        JSObject jSObject = context.getGlobalForEdit();
        JSObject jSObject2 = jSObject.getProperty("XULDocument");
        if (jSObject2 instanceof JSFunction && (jSObject2 = ((JSFunction)jSObject2).construct(context, jSObject, null)) != null) {
            ObjectImpl objectImpl = new ObjectImpl(jSObject.getClassName());
            objectImpl.setParentScope(objectImpl.getParentScope());
            objectImpl.setPrototype(jSObject);
            objectImpl.setProperty("document", jSObject2);
            jSObject = objectImpl;
        }
        return jSObject;
    }

    public String[] getIncludes() {
        return null;
    }

    public BufferedScanner[] getScripts() {
        if (this.fModel != null) {
            XMLElement xMLElement = null;
            XMLDocument xMLDocument = this.fModel.getXMLDocument();
            if (xMLDocument != null) {
                xMLElement = xMLDocument.getDocumentElement();
            }
            if (xMLElement != null) {
                ArrayList<BufferedScanner> arrayList = null;
                ScriptManager scriptManager = this.getManager();
                int n = xMLElement.getChildrenCount();
                XMLNode[] xMLNodeArray = xMLElement.getChildren();
                for (int i = 0; i < n; ++i) {
                    Path path;
                    XMLNode xMLNode = xMLNodeArray[i];
                    if (1 != xMLNode.getNodeType() || !"script".equals(xMLNode.getLocalName())) continue;
                    BufferedScanner bufferedScanner = null;
                    XMLElement xMLElement2 = (XMLElement)xMLNode;
                    INodeRegion iNodeRegion = xMLElement2.getStartTagRegion();
                    if (iNodeRegion == null) continue;
                    if (iNodeRegion.getStart() > this.fOffset) break;
                    String string = XMLUtils.getAttrValue((XMLElement)xMLElement2, (String)"src");
                    if (string == null) {
                        if (!xMLElement2.isEmptyTag()) {
                            iNodeRegion = xMLElement2.getEndTagRegion();
                            if (iNodeRegion == null || iNodeRegion.getEnd() > this.fOffset) break;
                            if (xMLElement2.getChildrenCount() == 0) {
                                bufferedScanner = this.getLexer(3, (XMLNode)xMLElement2);
                            } else {
                                path = xMLElement2.getChildren()[0];
                                if (4 == path.getNodeType()) {
                                    bufferedScanner = this.getLexer(4, (XMLNode)path);
                                }
                            }
                        }
                    } else {
                        path = new Path(string);
                        if (path.getDevice() == null) {
                            if (!path.isAbsolute()) {
                                path = this.getPath().append((IPath)path).makeAbsolute();
                            }
                        } else {
                            path = gBufferManager.resolve((IPath)path, this.getPath(), null);
                        }
                        if (path != null) {
                            bufferedScanner = scriptManager.getLexer((IPath)path);
                        }
                    }
                    if (bufferedScanner == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<BufferedScanner>();
                    }
                    arrayList.add(bufferedScanner);
                }
                if (arrayList != null) {
                    BufferedScanner[] bufferedScannerArray = new BufferedScanner[arrayList.size()];
                    arrayList.toArray(bufferedScannerArray);
                    return bufferedScannerArray;
                }
            }
        }
        return null;
    }

    public JSObject getThisScope(JSObject jSObject) {
        Context context;
        JSObject jSObject2;
        PositionInfo positionInfo = this.getPosition();
        if (positionInfo.nodeType == 100 && (jSObject2 = jSObject.getProperty("XULElement")) instanceof JSFunction && (jSObject2 = ((JSFunction)jSObject2).construct(context = this.getContext(), jSObject, null)) != null) {
            return jSObject2;
        }
        return jSObject;
    }

    protected boolean isScript() {
        PositionInfo positionInfo = this.getPosition();
        switch (positionInfo.nodeType) {
            case 3: 
            case 4: {
                XMLNode xMLNode = positionInfo.node;
                if (xMLNode.getNodeType() != 1) {
                    xMLNode = xMLNode.getParent();
                }
                if (xMLNode.getNodeType() != 1 || !"script".equals(xMLNode.getLocalName())) break;
                return true;
            }
            case 100: {
                return XULLexerProvider.getEventAttr(positionInfo.node, this.fOffset) != null;
            }
        }
        return false;
    }
}

