/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.internal.text;

import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.js.internal.JSImages;
import com.spket.ui.UIElement;
import com.spket.ui.editors.PlainTextEditor;
import com.spket.ui.text.DefaultHyperlink;
import com.spket.ui.text.TreeInformationControl;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModelParser;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xul.internal.XULImages;
import com.spket.xul.internal.XULPlugin;
import com.spket.xul.model.XULModel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class XBLHierarchyInformationControl
extends TreeInformationControl {
    private static BufferManager gManager = BufferManager.getDefault();
    private Map documents = new HashMap();

    public XBLHierarchyInformationControl(Shell shell, int n, int n2) {
        super(shell, n, n2);
    }

    protected String getId() {
        return "com.spket.xul.internal.text.XBLQuickHierarchy";
    }

    protected IDialogSettings getDialogSettings() {
        String string = this.getId();
        IDialogSettings iDialogSettings = XULPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    public void setInput(Object object) {
        if (this.documents.size() > 0) {
            this.documents.clear();
        }
        Binding binding = null;
        if (object instanceof XMLNode) {
            binding = this.create((XMLNode)object);
            if (this.documents.size() > 0) {
                this.documents.clear();
            }
        }
        if (binding == null) {
            this.inputChanged(null, null);
        } else {
            UIElement uIElement;
            UIElement uIElement2;
            Image image = XULImages.get("binding");
            UIElement uIElement3 = uIElement2 = new UIElement();
            do {
                if (binding.url == null) {
                    uIElement2.setName(binding.name);
                } else {
                    uIElement2.setName(binding.name + " - " + binding.url);
                }
                uIElement2.setData((Object)binding);
                uIElement2.setImage(image);
                uIElement = new UIElement();
                uIElement2.setParent((Object)uIElement);
                uIElement.setChildren((Object[])new UIElement[]{uIElement2});
                uIElement2 = uIElement;
            } while ((binding = binding.parent) != null);
            uIElement2.setName("XULElement");
            uIElement2.setImage(JSImages.get((String)"c.s.js.class_obj.gif"));
            uIElement = new UIElement();
            uIElement2.setParent((Object)uIElement);
            uIElement.setName("XULElement");
            uIElement.setChildren((Object[])new UIElement[]{uIElement2});
            this.inputChanged(uIElement, uIElement3);
        }
    }

    protected void open(Object object) {
        ITextEditor iTextEditor = this.getEditor();
        if (iTextEditor == null) {
            return;
        }
        if (object instanceof UIElement) {
            object = ((UIElement)object).getData();
        }
        if (object instanceof Binding) {
            Binding binding = (Binding)object;
            if (binding.element != null) {
                IPath iPath = binding.path;
                IPath iPath2 = ((PlainTextEditor)iTextEditor).getPath();
                if (iPath != null && iPath.equals(iPath2)) {
                    iPath = null;
                }
                DefaultHyperlink defaultHyperlink = new DefaultHyperlink(iTextEditor, iPath);
                INodeRegion iNodeRegion = binding.element.getStartTagRegion();
                if (iNodeRegion != null) {
                    defaultHyperlink.setSelection(iNodeRegion.getStart(), 0);
                }
                defaultHyperlink.setSameContentType(true);
                defaultHyperlink.open();
            }
        }
    }

    protected void resolveHierarchy(Binding binding, IPath iPath) {
        XMLElement xMLElement = binding.element;
        String string = StringUtils.makeNullIfEmpty((String)XMLUtils.getAttrValue((XMLElement)xMLElement, (String)"extends"));
        if (string != null) {
            IPath iPath2 = null;
            String string2 = null;
            int n = string.lastIndexOf(35);
            if (n != -1) {
                if (n > 0) {
                    string2 = string.substring(0, n);
                    iPath2 = new Path(string2);
                    if (iPath.equals(iPath2)) {
                        iPath2 = iPath;
                    } else if ((iPath2 = gManager.resolve(iPath2, iPath, null)) != null && iPath.equals(iPath2)) {
                        iPath2 = iPath;
                    }
                }
                string = string.substring(n + 1);
            }
            if (iPath2 == null) {
                iPath2 = iPath;
            }
            XMLDocument xMLDocument = null;
            Object v = this.documents.get(iPath2);
            if (v == null) {
                IBuffer iBuffer = null;
                iBuffer = gManager.getBuffer(iPath2);
                if (iBuffer != null) {
                    XMLModelParser xMLModelParser = new XMLModelParser(XULModel.gSymbolTable);
                    xMLModelParser.parse(iBuffer);
                    xMLDocument = xMLModelParser.getDocument();
                    xMLModelParser.dispose();
                }
                if (xMLDocument == null) {
                    this.documents.put(iPath2, Boolean.FALSE);
                } else {
                    this.documents.put(iPath2, xMLDocument);
                }
            } else if (v instanceof XMLDocument) {
                xMLDocument = (XMLDocument)v;
            }
            if (xMLDocument == null) {
                binding.parent = new Binding();
                binding.parent.name = string;
            } else {
                binding.parent = this.create(xMLDocument, string, iPath2, string2);
            }
        }
    }

    protected Binding create(XMLNode xMLNode) {
        IPath iPath;
        ITextEditor iTextEditor = this.getEditor();
        if (iTextEditor instanceof PlainTextEditor && (iPath = ((PlainTextEditor)iTextEditor).getPath()) != null) {
            String string;
            XMLElement xMLElement = null;
            while (xMLNode != null) {
                if (1 == xMLNode.getNodeType() && "binding".equals(xMLNode.getLocalName())) {
                    xMLElement = (XMLElement)xMLNode;
                    break;
                }
                xMLNode = xMLNode.getParent();
            }
            if (xMLElement != null && (string = XMLUtils.getAttrValue(xMLElement, (String)"id")) != null) {
                return this.create(xMLElement.getDocument(), string, iPath, null);
            }
        }
        return null;
    }

    protected Binding create(XMLDocument xMLDocument, String string, IPath iPath, String string2) {
        Binding binding = new Binding();
        binding.name = string;
        binding.path = iPath;
        binding.url = string2;
        if (xMLDocument == null) {
            return binding;
        }
        XMLElement xMLElement = xMLDocument.getDocumentElement();
        if (xMLElement == null) {
            return binding;
        }
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLElement xMLElement2;
                XMLNode xMLNode = xMLNodeArray[i];
                if (xMLNode.getNodeType() != 1 || !"binding".equals(xMLNode.getLocalName()) || !string.equals(XMLUtils.getAttrValue((XMLElement)(xMLElement2 = (XMLElement)xMLNode), (String)"id"))) continue;
                binding.element = xMLElement2;
                this.resolveHierarchy(binding, iPath);
                break;
            }
        }
        return binding;
    }

    private static final class Binding {
        public String name;
        public String url;
        public IPath path;
        public XMLElement element;
        public Binding parent;

        private Binding() {
        }
    }
}

