/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.internal.actions;

import com.spket.js.internal.JSImages;
import com.spket.js.model.Flags;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSFunction;
import com.spket.js.model.NativeFunction;
import com.spket.js.model.Param;
import com.spket.js.model.SlotWrapper;
import com.spket.ui.text.CodeIndenter;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.widget.UIUtils;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xpc.model.Typelib;
import com.spket.xpc.model.XPClass;
import com.spket.xul.internal.actions.ActionMessages;
import com.spket.xul.internal.editors.XULEditor;
import com.spket.xul.model.XULHelper;
import com.spket.xul.model.XULModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.texteditor.IUpdate;

public class ImplementationAction
extends Action
implements IUpdate {
    private Map fields;
    private Map methods;
    private List classes;
    private XULEditor fEditor;
    private int stateMask;

    public ImplementationAction(XULEditor xULEditor) {
        this.fEditor = xULEditor;
        this.setText(ActionMessages.ImplementAction_label);
        this.setDescription(ActionMessages.ImplementAction_description);
        this.setToolTipText(ActionMessages.ImplementAction_tooltip);
        this.update();
    }

    public void update() {
        this.setEnabled(this.fEditor != null && this.fEditor.isEditable());
    }

    public void run() {
        Object[] objectArray;
        String string;
        XMLAttr xMLAttr;
        XMLNode xMLNode;
        if (this.fEditor == null || !this.fEditor.isEditable()) {
            return;
        }
        XMLModel xMLModel = this.fEditor.getModel();
        if (xMLModel == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        int n = -1;
        ISelection iSelection = this.fEditor.getSelectionProvider().getSelection();
        if (iSelection instanceof ITextSelection) {
            n = ((ITextSelection)iSelection).getOffset();
        }
        if (n < 0 || n > iDocument.getLength()) {
            return;
        }
        XMLElement xMLElement = null;
        for (xMLNode = XMLUtils.findNode((XMLModel)xMLModel, (int)n, null); xMLNode != null; xMLNode = xMLNode.getParent()) {
            short s = xMLNode.getNodeType();
            if (1 != s || !"implementation".equals(xMLNode.getLocalName())) continue;
            xMLElement = (XMLElement)xMLNode;
            break;
        }
        if (xMLElement != null && (xMLAttr = xMLElement.getAttr("implements")) != null && (string = xMLAttr.getValue()) != null && string.length() > 0 && (objectArray = StringUtils.split((String)string, (char)',', (boolean)false)).length > 0) {
            Object object;
            Typelib typelib;
            this.fields = new HashMap();
            this.methods = new HashMap();
            int n2 = xMLElement.getChildrenCount();
            if (n2 > 0) {
                typelib = xMLElement.getChildren();
                block7: for (int i = 0; i < n2; ++i) {
                    xMLNode = typelib[i];
                    if (1 != xMLNode.getNodeType()) continue;
                    switch (XULHelper.getTagId(xMLNode.getLocalName())) {
                        case 29: 
                        case 69: {
                            object = XMLUtils.getAttrValue((XMLElement)((XMLElement)xMLNode), (String)"name");
                            if (object == null) continue block7;
                            this.fields.put(object, xMLNode);
                            continue block7;
                        }
                        case 57: {
                            object = XMLUtils.getAttrValue((XMLElement)((XMLElement)xMLNode), (String)"name");
                            if (object == null) continue block7;
                            this.methods.put(object, xMLNode);
                        }
                    }
                }
            }
            if ((object = XULModel.getContext(xMLModel)) instanceof Typelib) {
                MemberDialog memberDialog;
                Object object2;
                XPClass xPClass;
                typelib = (Typelib)object;
                Map map = typelib.getInterfaces();
                this.classes = new ArrayList(objectArray.length);
                Arrays.sort(objectArray);
                block8: for (int i = 0; i < objectArray.length; ++i) {
                    xPClass = (XPClass)((SlotWrapper)map.get(objectArray[i])).getPrototype();
                    if (xPClass == null || (object2 = xPClass.getProperties()) == null) continue;
                    Iterator iterator = object2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ISlot iSlot = (ISlot)entry.getValue();
                        if (Flags.isStatic((int)iSlot.getFlags())) continue;
                        if (iSlot.getObject() instanceof JSFunction) {
                            if (this.methods.containsKey(entry.getKey())) continue;
                            this.classes.add(xPClass);
                            continue block8;
                        }
                        if (this.fields.containsKey(entry.getKey())) continue;
                        this.classes.add(xPClass);
                        continue block8;
                    }
                }
                if (this.classes.size() > 0 && (memberDialog = new MemberDialog(this.fEditor.getEditorSite().getShell())).open() == 0 && memberDialog.source != null) {
                    xPClass = new CodeIndenter(iDocument, n);
                    object2 = xPClass.format(memberDialog.source);
                    try {
                        iDocument.replace(n, 0, (String)object2);
                    }
                    catch (BadLocationException badLocationException) {
                        Debug.debug((Throwable)badLocationException);
                    }
                }
            }
        }
    }

    protected void fill(Tree tree) {
        Image image = JSImages.get((String)"c.s.js.interface_obj.png");
        Image image2 = JSImages.get((String)"c.s.js.function_obj.gif");
        Image image3 = JSImages.get((String)"c.s.js.field_public_obj.gif");
        for (int i = 0; i < this.classes.size(); ++i) {
            TreeItem treeItem = new TreeItem(tree, 0);
            XPClass xPClass = (XPClass)this.classes.get(i);
            treeItem.setText(xPClass.getClassName());
            treeItem.setImage(image);
            treeItem.setData((Object)xPClass);
            ArrayList<JSMember> arrayList = new ArrayList<JSMember>();
            Map map = xPClass.getProperties();
            if (map != null) {
                String string;
                Object object;
                TreeItem treeItem2;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    treeItem2 = iterator.next();
                    object = (ISlot)treeItem2.getValue();
                    if (Flags.isStatic((int)object.getFlags())) continue;
                    string = (String)treeItem2.getKey();
                    if (object.getObject() instanceof JSFunction) {
                        if (this.methods.containsKey(string)) continue;
                        arrayList.add(new JSMember(string, (ISlot)object));
                        continue;
                    }
                    if (this.fields.containsKey(string)) continue;
                    arrayList.add(new JSMember(string, (ISlot)object));
                }
                if (arrayList.size() > 0) {
                    Collections.sort(arrayList);
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = (JSMember)((Object)iterator.next());
                        if (((JSMember)object).slot.getObject() instanceof JSFunction) {
                            treeItem2 = new TreeItem(treeItem, 0);
                            treeItem2.setText(((JSMember)object).name);
                            treeItem2.setImage(image2);
                        } else {
                            treeItem2 = new TreeItem(treeItem, 0);
                            treeItem2.setText(((JSMember)object).name);
                            treeItem2.setImage(image3);
                            string = new TreeItem(treeItem2, 0);
                            string.setText("field");
                            string.setImage(image3);
                            string = new TreeItem(treeItem2, 0);
                            string.setText("getter");
                            string.setImage(image3);
                            string.setData((Object)Boolean.FALSE);
                            string = new TreeItem(treeItem2, 0);
                            string.setText("setter");
                            string.setImage(image3);
                            string.setData((Object)Boolean.TRUE);
                        }
                        treeItem2.setData(object);
                    }
                }
            }
            treeItem.setExpanded(true);
        }
    }

    protected void onSelectionChanged(Event event) {
        if (event.detail == 32) {
            TreeItem treeItem = (TreeItem)event.item;
            Object object = treeItem.getData();
            if (object instanceof XPClass) {
                boolean bl = treeItem.getChecked() || treeItem.getGrayed();
                TreeItem[] treeItemArray = treeItem.getItems();
                for (int i = 0; i < treeItemArray.length; ++i) {
                    this.updateItem(treeItemArray[i], bl);
                }
                treeItem.setGrayed(false);
                treeItem.setChecked(bl);
            } else {
                if (object instanceof JSMember) {
                    this.updateItem(treeItem, treeItem.getChecked() || treeItem.getGrayed());
                } else if (object instanceof Boolean) {
                    TreeItem treeItem2 = treeItem.getParentItem();
                    TreeItem[] treeItemArray = treeItem2.getItems();
                    if (treeItem.getChecked()) {
                        treeItemArray[0].setChecked(false);
                        treeItem.setGrayed(UIUtils.isControlDown((int)this.stateMask));
                    } else {
                        treeItem.setGrayed(false);
                    }
                    int n = 1;
                    for (int i = 1; i < treeItemArray.length; ++i) {
                        if (!treeItemArray[i].getChecked()) continue;
                        ++n;
                    }
                    if (n == 1) {
                        treeItem2.setGrayed(false);
                        treeItem2.setChecked(false);
                    } else {
                        treeItem2.setGrayed(n != treeItemArray.length);
                        treeItem2.setChecked(true);
                    }
                } else {
                    TreeItem treeItem3 = treeItem.getParentItem();
                    if (treeItem.getChecked()) {
                        TreeItem[] treeItemArray = treeItem3.getItems();
                        for (int i = 0; i < treeItemArray.length; ++i) {
                            TreeItem treeItem4 = treeItemArray[i];
                            if (treeItem4 == treeItem) continue;
                            treeItem4.setGrayed(false);
                            treeItem4.setChecked(false);
                        }
                    }
                    treeItem3.setGrayed(false);
                    treeItem3.setChecked(treeItem.getChecked());
                }
                this.updateStates(treeItem);
            }
        }
    }

    protected void updateItem(TreeItem treeItem, boolean bl) {
        if (treeItem.getItemCount() > 0) {
            TreeItem[] treeItemArray = treeItem.getItems();
            if (bl) {
                if (UIUtils.isShiftDown((int)this.stateMask)) {
                    treeItemArray[0].setChecked(true);
                    for (int i = 1; i < treeItemArray.length; ++i) {
                        treeItemArray[i].setGrayed(false);
                        treeItemArray[i].setChecked(false);
                    }
                } else {
                    treeItemArray[0].setChecked(false);
                    boolean bl2 = UIUtils.isControlDown((int)this.stateMask);
                    for (int i = 1; i < treeItemArray.length; ++i) {
                        treeItemArray[i].setGrayed(bl2);
                        treeItemArray[i].setChecked(bl);
                    }
                }
            } else {
                for (int i = 0; i < treeItemArray.length; ++i) {
                    treeItemArray[i].setGrayed(false);
                    treeItemArray[i].setChecked(bl);
                }
            }
            treeItem.setGrayed(false);
            treeItem.setChecked(bl);
        } else {
            treeItem.setChecked(bl);
        }
    }

    protected void updateStates(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        while (treeItem2 != null) {
            treeItem = treeItem2;
            treeItem2 = treeItem.getParentItem();
        }
        int n = 0;
        boolean bl = false;
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem3 = treeItemArray[i];
            if (treeItem3.getGrayed()) {
                bl = true;
                break;
            }
            if (!treeItem3.getChecked()) continue;
            ++n;
        }
        if (bl) {
            treeItem.setGrayed(bl);
            treeItem.setChecked(true);
        } else if (n == 0) {
            treeItem.setGrayed(false);
            treeItem.setChecked(false);
        } else {
            treeItem.setGrayed(n != treeItemArray.length);
            treeItem.setChecked(true);
        }
    }

    protected String generateCode(Tree tree) {
        StringBuffer stringBuffer = null;
        TreeItem[] treeItemArray = tree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (!treeItem.getGrayed() && !treeItem.getChecked()) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            TreeItem[] treeItemArray2 = treeItem.getItems();
            for (int j = 0; j < treeItemArray2.length; ++j) {
                TreeItem treeItem2 = treeItemArray2[j];
                if (!treeItem2.getGrayed() && !treeItem2.getChecked()) continue;
                this.generate(treeItem2, stringBuffer);
            }
        }
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    protected void generate(TreeItem treeItem, StringBuffer stringBuffer) {
        JSMember jSMember = (JSMember)treeItem.getData();
        ISlot iSlot = jSMember.slot;
        Object object = iSlot.getData((Object)ISlot.P_TYPE);
        if (iSlot.getObject() instanceof JSFunction) {
            stringBuffer.append("<method name=\"");
            stringBuffer.append(jSMember.name);
            stringBuffer.append("\">");
            this.newline(stringBuffer);
            NativeFunction nativeFunction = (NativeFunction)iSlot.getObject();
            int n = nativeFunction.getNumberOfParameters();
            if (n > 0) {
                Param[] paramArray = nativeFunction.getParameters();
                for (int i = 0; i < n; ++i) {
                    Param param = paramArray[i];
                    this.indent(stringBuffer, 1);
                    stringBuffer.append("<parameter name=\"");
                    stringBuffer.append(param.getName());
                    stringBuffer.append("\"/>");
                    this.newline(stringBuffer);
                }
            }
            this.indent(stringBuffer, 1);
            stringBuffer.append("<body><![CDATA[");
            this.newline(stringBuffer);
            if (object != null) {
                this.indent(stringBuffer, 2);
                stringBuffer.append("return ").append(this.getDefaultValue(object)).append(';');
                this.newline(stringBuffer);
            }
            this.indent(stringBuffer, 1);
            stringBuffer.append("]]></body>");
            this.newline(stringBuffer);
            stringBuffer.append("</method>");
            this.newline(stringBuffer);
        } else {
            TreeItem[] treeItemArray = treeItem.getItems();
            if (treeItemArray[0].getChecked()) {
                stringBuffer.append("<field name=\"");
                stringBuffer.append(jSMember.name);
                stringBuffer.append("\">");
                stringBuffer.append(this.getDefaultValue(object));
                stringBuffer.append("</field>");
                this.newline(stringBuffer);
            } else {
                TreeItem treeItem2 = treeItemArray[1];
                TreeItem treeItem3 = treeItemArray[2];
                stringBuffer.append("<property name=\"");
                stringBuffer.append(jSMember.name);
                if (treeItem2.getGrayed() && treeItem2.getChecked()) {
                    stringBuffer.append("\" onget=\"");
                    stringBuffer.append("return ").append(this.getDefaultValue(object)).append(';');
                }
                if (treeItem3.getChecked() && treeItem3.getGrayed()) {
                    stringBuffer.append("\" onset=\"");
                }
                if (treeItem2.getChecked() && !treeItem2.getGrayed() || treeItem3.getChecked() && !treeItem3.getGrayed()) {
                    stringBuffer.append("\">");
                    this.newline(stringBuffer);
                    if (treeItem2.getChecked() && !treeItem2.getGrayed()) {
                        this.indent(stringBuffer, 1);
                        stringBuffer.append("<getter><![CDATA[");
                        this.newline(stringBuffer);
                        this.indent(stringBuffer, 2);
                        stringBuffer.append("return ").append(this.getDefaultValue(object)).append(';');
                        this.newline(stringBuffer);
                        this.indent(stringBuffer, 1);
                        stringBuffer.append("]]></getter>");
                        this.newline(stringBuffer);
                    }
                    if (treeItem3.getChecked() && !treeItem3.getGrayed()) {
                        this.indent(stringBuffer, 1);
                        stringBuffer.append("<setter><![CDATA[");
                        this.newline(stringBuffer);
                        this.indent(stringBuffer, 1);
                        stringBuffer.append("]]></setter>");
                        this.newline(stringBuffer);
                    }
                    stringBuffer.append("</property>");
                } else {
                    stringBuffer.append("\"/>");
                }
                this.newline(stringBuffer);
            }
        }
    }

    protected void indent(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
    }

    protected void newline(StringBuffer stringBuffer) {
        stringBuffer.append('\n');
    }

    protected String getDefaultValue(Object object) {
        if ("Number".equals(object)) {
            return "0";
        }
        if ("Boolean".equals(object)) {
            return "false";
        }
        return "null";
    }

    static /* synthetic */ int access$102(ImplementationAction implementationAction, int n) {
        implementationAction.stateMask = n;
        return implementationAction.stateMask;
    }

    private class MemberDialog
    extends Dialog {
        private Tree tree;
        private String source;

        public MemberDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.tree = new Tree(composite2, 2080);
            GridData gridData = new GridData(1808);
            gridData.widthHint = this.convertWidthInCharsToPixels(60);
            gridData.heightHint = this.convertHeightInCharsToPixels(18);
            this.tree.setLayoutData((Object)gridData);
            ImplementationAction.this.fill(this.tree);
            if (this.tree.getItemCount() > 0) {
                this.tree.setSelection(this.tree.getItem(0));
            }
            Listener listener = new Listener(this){
                private final /* synthetic */ MemberDialog this$1;
                {
                    this.this$1 = memberDialog;
                }

                public void handleEvent(Event event) {
                    if (3 == event.type) {
                        ImplementationAction.access$102(MemberDialog.access$000(this.this$1), event.stateMask);
                    } else {
                        MemberDialog.access$000(this.this$1).onSelectionChanged(event);
                    }
                }
            };
            this.tree.addListener(13, listener);
            this.tree.addListener(3, listener);
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(ActionMessages.ImplementDialog_title);
        }

        protected void okPressed() {
            this.source = ImplementationAction.this.generateCode(this.tree);
            super.okPressed();
        }

        static /* synthetic */ ImplementationAction access$000(MemberDialog memberDialog) {
            return memberDialog.ImplementationAction.this;
        }
    }

    private static class JSMember
    implements Comparable {
        private String name;
        private ISlot slot;

        public JSMember(String string, ISlot iSlot) {
            this.name = string;
            this.slot = iSlot;
        }

        public int compareTo(Object object) {
            JSMember jSMember = (JSMember)object;
            if (this.slot.getObject() instanceof JSFunction) {
                if (jSMember.slot.getObject() instanceof JSFunction) {
                    return this.name.compareTo(jSMember.name);
                }
                return 1;
            }
            if (jSMember.slot.getObject() instanceof JSFunction) {
                return -1;
            }
            return this.name.compareTo(jSMember.name);
        }
    }
}

