/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.model;

import com.spket.buffer.IURIResolver;
import com.spket.buffer.ZipPath;
import com.spket.ui.internal.UIPlugin;
import com.spket.util.Debug;
import com.spket.xpc.internal.XPCPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ChromeURIResolver
implements IURIResolver,
IResourceDeltaVisitor {
    public static final String CHROME = "chrome";
    public static final String SKIN = "skin";
    public static final String LOCALE = "locale";
    public static final String CONTENT = "content";
    public static final String CHROME_DEVICE = "chrome:";
    public static final String MANIFEST = "chrome.manifest";
    private Map projects = new HashMap();
    private Map fZipFiles = new HashMap();
    private Map fProviders = new HashMap();

    public ChromeURIResolver() {
        this.initialize();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta != null) {
                    try {
                        iResourceDelta.accept((IResourceDeltaVisitor)ChromeURIResolver.this);
                    }
                    catch (CoreException coreException) {
                        UIPlugin.log((IStatus)coreException.getStatus());
                    }
                }
            }
        });
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        if (iResourceDelta == null) {
            return false;
        }
        IResource iResource = iResourceDelta.getResource();
        if (iResource != null) {
            switch (iResource.getType()) {
                case 1: {
                    switch (iResourceDelta.getKind()) {
                        case 4: {
                            if ((iResourceDelta.getFlags() & 0x100) == 0) break;
                        }
                        case 1: 
                        case 2: {
                            IPath iPath = iResource.getFullPath();
                            if (iPath.segmentCount() != 2 || !MANIFEST.equals(iPath.segment(1))) break;
                            this.projects.remove(iPath.segment(0));
                            this.add(iResource.getProject());
                        }
                    }
                    return false;
                }
                case 4: {
                    switch (iResourceDelta.getKind()) {
                        case 1: {
                            this.add((IProject)iResource);
                            return false;
                        }
                        case 2: {
                            this.projects.remove(iResource.getName());
                            return false;
                        }
                        case 4: {
                            if ((iResourceDelta.getFlags() & 0x4000) == 0) break;
                            if (iResource.isAccessible()) {
                                this.add((IProject)iResource);
                            } else {
                                this.projects.remove(iResource.getName());
                            }
                            return false;
                        }
                    }
                    return iResourceDelta.getFlags() == 0;
                }
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public IPath resolve(IPath iPath) {
        return this.resolve(iPath, null, Collections.EMPTY_MAP);
    }

    public IPath resolve(IPath iPath, IPath iPath2, Map map) {
        if (CHROME_DEVICE.equals(iPath.getDevice())) {
            if (this.exists(iPath = iPath.setDevice(null).makeUNC(false))) {
                return iPath;
            }
            if (iPath.segmentCount() > 2) {
                IPath iPath3;
                Map map2 = null;
                if (iPath2 != null && iPath2.segmentCount() > 0 && iPath2.getDevice() == null && (map2 = (Map)this.projects.get(iPath2.segment(0))) != null && (iPath3 = this.resolve(map2, iPath, map)) != null) {
                    return iPath3;
                }
                Iterator iterator = this.projects.values().iterator();
                while (iterator.hasNext()) {
                    Map map3 = (Map)iterator.next();
                    if (map3 == map2 || (iPath3 = this.resolve(map3, iPath, map)) == null) continue;
                    return iPath3;
                }
                if (this.fProviders.size() > 0 && (iPath3 = this.resolve(this.fProviders, iPath, map)) != null) {
                    return iPath3;
                }
            }
            return iPath;
        }
        return iPath;
    }

    protected IPath resolve(Map map, IPath iPath, Map map2) {
        IPath iPath2 = null;
        String string = iPath.segment(1);
        Map map3 = (Map)map.get(string);
        if (map3 != null) {
            Map map4;
            Object v = map3.get(iPath.segment(0));
            if (v instanceof IPath) {
                iPath2 = (IPath)v;
            } else if (v instanceof Map && (map4 = (Map)v).size() > 0) {
                Object var9_9 = null;
                if (map2 != null) {
                    var9_9 = map2.get(string);
                }
                iPath2 = var9_9 == null ? (IPath)map4.values().iterator().next() : (IPath)map4.get(var9_9);
            }
            if (iPath2 != null) {
                iPath2 = iPath2.append(iPath.removeFirstSegments(2));
            }
        }
        if (iPath2 != null && this.exists(iPath2)) {
            return iPath2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void add(IProject var1_1) {
        if (var1_1.isOpen() && (var2_2 = var1_1.getFile("chrome.manifest")).exists()) {
            block16: {
                var3_3 = null;
                var4_4 = var1_1.getName();
                var5_5 = new HashMap<K, V>();
                try {
                    var3_3 = var2_2.getContents();
                    this.parse(var3_3, var4_4, var5_5, false);
                    var8_6 = null;
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var7_16) {
                    var8_9 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var9_13) {
                            Debug.warn((Throwable)var9_13);
                        }
                    }
                    throw var7_16;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var9_10) {
                        Debug.warn((Throwable)var9_10);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (CoreException var6_14) {
                        Debug.debug((Throwable)var6_14);
                        var8_7 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var9_11) {
                                Debug.warn((Throwable)var9_11);
                            }
                        }
                        break block16;
                    }
                    catch (IOException var6_15) {
                        Debug.debug((Throwable)var6_15);
                        var8_8 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var9_12) {
                                Debug.warn((Throwable)var9_12);
                            }
                        }
                    }
                }
            }
            if (var5_5 != null) {
                this.projects.put(var4_4, var5_5);
            }
        }
    }

    protected void initialize() {
        IPreferenceStore iPreferenceStore;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot != null && (iPreferenceStore = iWorkspaceRoot.getProjects()) != null) {
            for (int i = 0; i < ((IPreferenceStore)iPreferenceStore).length; ++i) {
                this.add((IProject)iPreferenceStore[i]);
            }
        }
        iPreferenceStore = XPCPlugin.getDefault().getPreferenceStore();
        this.add(iPreferenceStore);
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ff.dir".equals(propertyChangeEvent.getProperty())) {
                    if (ChromeURIResolver.this.fProviders.size() > 0) {
                        ChromeURIResolver.this.fProviders.clear();
                    }
                    if (ChromeURIResolver.this.fZipFiles.size() > 0) {
                        ChromeURIResolver.this.fZipFiles.clear();
                    }
                    ChromeURIResolver.this.add(XPCPlugin.getDefault().getPreferenceStore());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void add(IPreferenceStore iPreferenceStore) {
        File file;
        String string = iPreferenceStore.getString("ff.dir");
        if (string != null && string.length() > 0 && (file = new File(string)).exists() && file.isDirectory()) {
            String[] stringArray;
            file = new File(file, CHROME);
            String string2 = file.getAbsolutePath();
            if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2;
                    string = stringArray[i];
                    if (!string.endsWith(".manifest") || !(file2 = new File(file, string)).isFile()) continue;
                    FileInputStream fileInputStream = null;
                    fileInputStream = new FileInputStream(file2);
                    this.parse(fileInputStream, string2, this.fProviders, true);
                    Object var11_10 = null;
                    if (fileInputStream == null) continue;
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException2) {
                        Debug.warn((Throwable)iOException2);
                    }
                    continue;
                    {
                        catch (IOException iOException) {
                            Debug.debug((Throwable)iOException);
                            var11_10 = null;
                            if (fileInputStream == null) continue;
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException2) {
                                Debug.warn((Throwable)iOException2);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException2) {
                                Debug.warn((Throwable)iOException2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    protected void parse(InputStream inputStream, String string, Map map, boolean bl) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            LinkedHashMap<String, IPath> linkedHashMap;
            Map<String, LinkedHashMap<String, IPath>> map2;
            IPath iPath;
            String[] stringArray = this.split(string2);
            if (stringArray == null || stringArray.length <= 2) continue;
            String string3 = stringArray[1];
            String string4 = stringArray[0];
            if (CONTENT.equals(string4)) {
                iPath = this.parseURL(stringArray[2], string, bl);
                if (iPath == null) continue;
                map2 = (HashMap<String, IPath>)map.get(CONTENT);
                if (map2 == null) {
                    map2 = new HashMap<String, IPath>();
                    map.put(CONTENT, map2);
                }
                map2.put(string3, (LinkedHashMap<String, IPath>)iPath);
                continue;
            }
            if (stringArray.length <= 3 || !LOCALE.equals(string4) && !SKIN.equals(string4) || (iPath = this.parseURL(stringArray[3], string, bl)) == null) continue;
            map2 = (Map)map.get(string4);
            if (map2 == null) {
                map2 = new HashMap();
                map.put(string4, map2);
            }
            if ((linkedHashMap = (LinkedHashMap<String, IPath>)map2.get(string3)) == null) {
                linkedHashMap = new LinkedHashMap<String, IPath>();
                map2.put(string3, linkedHashMap);
            }
            linkedHashMap.put(stringArray[2], iPath);
        }
    }

    protected IPath parseURL(String string, String string2, boolean bl) {
        int n;
        if (string.length() > 0 && (n = string.indexOf(58)) > 0) {
            String string3 = string.substring(0, n);
            if ("jar".equals(string3)) {
                if ((n = string.indexOf(33, n)) > 0) {
                    boolean bl2;
                    Path path = null;
                    boolean bl3 = bl2 = string.charAt(4) == '/';
                    if (!bl2) {
                        int n2 = string.indexOf(58, 4);
                        boolean bl4 = bl2 = n2 > 0 && n2 < n;
                    }
                    if (bl || bl2) {
                        if (bl2) {
                            path = new Path(string.substring(4, n)).makeAbsolute();
                        } else {
                            path = new Path(string2);
                            path = path.append(string.substring(4, n));
                        }
                        if (string.charAt(++n) == '/') {
                            ++n;
                        }
                        path = new ZipPath((IPath)path, (IPath)new Path(string.substring(n)));
                    } else {
                        path = new Path(string2).makeAbsolute();
                        path = path.append(string.substring(n + 1));
                    }
                    return path;
                }
            } else if ("file".equals(string3)) {
                try {
                    File file = new File(new URI(string));
                    return Path.fromOSString((String)file.getAbsolutePath());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected String[] split(String string) {
        if (string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (stringBuffer.length() <= 0) continue;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(stringBuffer.toString());
            }
            if (arrayList.size() > 0) {
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                return stringArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean exists(IPath iPath) {
        block17: {
            Map<String, Boolean> map;
            ZipPath zipPath;
            block18: {
                if (iPath.getDevice() == null) {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    return iWorkspaceRoot.exists(iPath);
                }
                if (!(iPath instanceof ZipPath)) break block17;
                zipPath = (ZipPath)iPath;
                String string = zipPath.getFileName();
                map = (HashMap)this.fZipFiles.get(string);
                if (map == null) {
                    map = new HashMap();
                    ZipFile zipFile = null;
                    try {
                        zipFile = new ZipFile(zipPath.getFileName());
                        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                        while (enumeration.hasMoreElements()) {
                            ZipEntry zipEntry = enumeration.nextElement();
                            map.put(zipEntry.getName(), zipEntry.isDirectory() ? Boolean.TRUE : Boolean.FALSE);
                        }
                        Object var9_11 = null;
                        if (map.size() == 0) {
                            map = Collections.EMPTY_MAP;
                        }
                        this.fZipFiles.put(string, map);
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        if (map.size() == 0) {
                            map = Collections.EMPTY_MAP;
                        }
                        this.fZipFiles.put(string, map);
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {
                                Debug.warn((Throwable)iOException);
                            }
                        }
                        throw throwable;
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {
                            Debug.warn((Throwable)iOException);
                        }
                    }
                    break block18;
                    {
                        catch (IOException iOException) {
                            Object var9_12 = null;
                            if (map.size() == 0) {
                                map = Collections.EMPTY_MAP;
                            }
                            this.fZipFiles.put(string, map);
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException2) {
                                    Debug.warn((Throwable)iOException2);
                                }
                            }
                        }
                    }
                }
            }
            return map.containsKey(zipPath.getEntryName());
        }
        File file = iPath.toFile();
        return file.exists();
    }
}

